/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.pcap4j.core.PcapDumper;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.AbstractPacketTest;
import org.pcap4j.packet.IcmpV4CommonPacket;
import org.pcap4j.packet.IcmpV4EchoPacket;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IcmpV6EchoRequestPacket;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV4Rfc1349Tos;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.IpV6SimpleFlowLabel;
import org.pcap4j.packet.IpV6SimpleTrafficClass;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.SimpleBuilder;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.DataLinkType;
import org.pcap4j.packet.namednumber.IcmpV4Code;
import org.pcap4j.packet.namednumber.IcmpV4Type;
import org.pcap4j.packet.namednumber.IcmpV6Code;
import org.pcap4j.packet.namednumber.IcmpV6Type;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;

public class DltRawTest {
    private String originalLineSeparator;
    private String resourceDirPath;
    private String tmpDirPath;
    private final Packet ipV4 = DltRawTest.newIpV4Packet();
    private final Packet ipV6 = DltRawTest.newIpV6Packet();

    @Before
    public void setUp() throws Exception {
        this.originalLineSeparator = System.setProperty("line.separator", "\r\n");
        this.resourceDirPath = System.getProperty(AbstractPacketTest.RESOURCE_DIR_PROP, "src/test/resources");
        this.tmpDirPath = System.getProperty(AbstractPacketTest.TMP_DIR_PROP, "testdata");
        File tmpDir = new File(this.tmpDirPath);
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new IOException("Failed to make a test diectory: " + this.tmpDirPath);
        }
    }

    @After
    public void tearDown() throws Exception {
        System.setProperty("line.separator", this.originalLineSeparator);
    }

    @Test
    public void testDump() throws Exception {
        int size;
        String dumpFile = this.tmpDirPath + "/" + this.getClass().getSimpleName() + ".pcap";
        PcapHandle handle = Pcaps.openDead((DataLinkType)DataLinkType.RAW, (int)65536);
        PcapDumper dumper = handle.dumpOpen(dumpFile);
        Timestamp ts = new Timestamp(0L);
        dumper.dump(this.ipV4, ts);
        dumper.dump(this.ipV6, ts);
        dumper.close();
        handle.close();
        FileInputStream in1 = new FileInputStream(this.resourceDirPath + "/" + this.getClass().getSimpleName() + ".pcap");
        FileInputStream in2 = new FileInputStream(dumpFile);
        byte[] buffer1 = new byte[100];
        byte[] buffer2 = new byte[100];
        while ((size = in1.read(buffer1)) != -1) {
            Assert.assertEquals((long)size, (long)in2.read(buffer2));
            Assert.assertArrayEquals((byte[])buffer1, (byte[])buffer2);
        }
        in1.close();
        in2.close();
    }

    @Test
    public void testRead() throws Exception {
        String line;
        String pcapFile = this.resourceDirPath + "/" + this.getClass().getSimpleName() + ".pcap";
        PcapHandle ph = Pcaps.openOffline((String)pcapFile);
        StringBuilder sb = new StringBuilder(1000);
        sb.append(ph.getNextPacket().toString()).append(System.getProperty("line.separator")).append(ph.getNextPacket().toString());
        ph.close();
        FileReader fr = new FileReader(this.resourceDirPath + "/" + this.getClass().getSimpleName() + ".log");
        BufferedReader fbr = new BufferedReader(fr);
        StringReader sr = new StringReader(sb.toString());
        BufferedReader sbr = new BufferedReader(sr);
        while ((line = fbr.readLine()) != null) {
            Assert.assertEquals((Object)line, (Object)sbr.readLine());
        }
        Assert.assertNull((Object)sbr.readLine());
        fbr.close();
        fr.close();
        sr.close();
        sbr.close();
    }

    private static Packet newIpV4Packet() {
        short identifier = 1234;
        short sequenceNumber = 4321;
        UnknownPacket.Builder unknownb = new UnknownPacket.Builder();
        unknownb.rawData(new byte[]{0, 1, 2, 3});
        IcmpV4EchoPacket.Builder b = new IcmpV4EchoPacket.Builder();
        b.identifier(identifier).sequenceNumber(sequenceNumber).payloadBuilder((Packet.Builder)unknownb);
        IcmpV4EchoPacket packet = b.build();
        IcmpV4CommonPacket.Builder icmpV4b = new IcmpV4CommonPacket.Builder();
        icmpV4b.type(IcmpV4Type.ECHO).code(IcmpV4Code.NO_CODE).payloadBuilder((Packet.Builder)new SimpleBuilder((Packet)packet)).correctChecksumAtBuild(true);
        IpV4Packet.Builder ipv4b = new IpV4Packet.Builder();
        try {
            ipv4b.version(IpVersion.IPV4).tos((IpV4Packet.IpV4Tos)IpV4Rfc1349Tos.newInstance((byte)0)).identification((short)100).ttl((byte)100).protocol(IpNumber.ICMPV4).srcAddr((Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 1})).dstAddr((Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 2})).payloadBuilder((Packet.Builder)icmpV4b).correctChecksumAtBuild(true).correctLengthAtBuild(true);
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)"Never get here.");
        }
        return ipv4b.build();
    }

    private static Packet newIpV6Packet() {
        Inet6Address dstAddr;
        Inet6Address srcAddr;
        short identifier = 1234;
        short sequenceNumber = 4321;
        UnknownPacket.Builder unknownb = new UnknownPacket.Builder();
        unknownb.rawData(new byte[]{0, 1, 2, 3});
        IcmpV6EchoRequestPacket.Builder b = new IcmpV6EchoRequestPacket.Builder();
        b.identifier(identifier).sequenceNumber(sequenceNumber).payloadBuilder((Packet.Builder)unknownb);
        IcmpV6EchoRequestPacket packet = b.build();
        try {
            srcAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:1");
            dstAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:2");
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        IcmpV6CommonPacket.Builder icmpV6b = new IcmpV6CommonPacket.Builder();
        icmpV6b.type(IcmpV6Type.ECHO_REQUEST).code(IcmpV6Code.NO_CODE).srcAddr(srcAddr).dstAddr(dstAddr).payloadBuilder((Packet.Builder)new SimpleBuilder((Packet)packet)).correctChecksumAtBuild(true);
        IpV6Packet.Builder ipv6b = new IpV6Packet.Builder();
        ipv6b.version(IpVersion.IPV6).trafficClass((IpV6Packet.IpV6TrafficClass)IpV6SimpleTrafficClass.newInstance((byte)18)).flowLabel((IpV6Packet.IpV6FlowLabel)IpV6SimpleFlowLabel.newInstance((int)74565)).nextHeader(IpNumber.ICMPV6).hopLimit((byte)100).srcAddr(srcAddr).dstAddr(dstAddr).correctLengthAtBuild(true).payloadBuilder((Packet.Builder)icmpV6b);
        return ipv6b.build();
    }
}

