/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.AbstractPacketTest;
import org.pcap4j.packet.DnsDomainName;
import org.pcap4j.packet.DnsPacket;
import org.pcap4j.packet.DnsQuestion;
import org.pcap4j.packet.DnsRDataA;
import org.pcap4j.packet.DnsRDataAaaa;
import org.pcap4j.packet.DnsRDataCName;
import org.pcap4j.packet.DnsRDataCaa;
import org.pcap4j.packet.DnsRDataHInfo;
import org.pcap4j.packet.DnsRDataMInfo;
import org.pcap4j.packet.DnsRDataMb;
import org.pcap4j.packet.DnsRDataMd;
import org.pcap4j.packet.DnsRDataMf;
import org.pcap4j.packet.DnsRDataMg;
import org.pcap4j.packet.DnsRDataMr;
import org.pcap4j.packet.DnsRDataMx;
import org.pcap4j.packet.DnsRDataNs;
import org.pcap4j.packet.DnsRDataNull;
import org.pcap4j.packet.DnsRDataPtr;
import org.pcap4j.packet.DnsRDataSoa;
import org.pcap4j.packet.DnsRDataTxt;
import org.pcap4j.packet.DnsRDataWks;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.IpV6SimpleFlowLabel;
import org.pcap4j.packet.IpV6SimpleTrafficClass;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.SimpleBuilder;
import org.pcap4j.packet.UdpPacket;
import org.pcap4j.packet.namednumber.DnsClass;
import org.pcap4j.packet.namednumber.DnsOpCode;
import org.pcap4j.packet.namednumber.DnsRCode;
import org.pcap4j.packet.namednumber.DnsResourceRecordType;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.packet.namednumber.UdpPort;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(DnsPacketTest.class);
    private final DnsPacket packet;
    private final short id = (short)12233;
    private final boolean response;
    private final DnsOpCode opCode = DnsOpCode.STATUS;
    private final boolean authoritativeAnswer;
    private final boolean truncated;
    private final boolean recursionDesired;
    private final boolean recursionAvailable;
    private final boolean reserved;
    private final boolean authenticData;
    private final boolean checkingDisabled;
    private final DnsRCode rCode = DnsRCode.NOT_AUTH;
    private final short qdCount;
    private final short anCount = (short)6;
    private final short nsCount = (short)6;
    private final short arCount = (short)9;
    private final List<DnsQuestion> questions = new ArrayList<DnsQuestion>();
    private final List<DnsResourceRecord> answers = new ArrayList<DnsResourceRecord>();
    private final List<DnsResourceRecord> authorities = new ArrayList<DnsResourceRecord>();
    private final List<DnsResourceRecord> additionalInfo = new ArrayList<DnsResourceRecord>();

    public DnsPacketTest() throws Exception {
        this.response = true;
        this.authoritativeAnswer = false;
        this.truncated = false;
        this.recursionDesired = true;
        this.recursionAvailable = true;
        this.reserved = false;
        this.authenticData = true;
        this.checkingDisabled = false;
        this.qdCount = 1;
        ArrayList<String> hogeDomain = new ArrayList<String>();
        hogeDomain.add("hoge");
        hogeDomain.add("co");
        hogeDomain.add("jp");
        ArrayList<String> www = new ArrayList<String>();
        www.add("www");
        ArrayList<String> fooDomain = new ArrayList<String>();
        fooDomain.add("foo");
        fooDomain.add("org");
        DnsQuestion question = new DnsQuestion.Builder().qName(new DnsDomainName.Builder().labels(hogeDomain).build()).qType(DnsResourceRecordType.A).qClass(DnsClass.IN).build();
        this.questions.add(question);
        DnsResourceRecord aRR = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.A).dataClass(DnsClass.ANY).ttl(123123).rData((DnsResourceRecord.DnsRData)new DnsRDataA.Builder().address((Inet4Address)InetAddress.getByName("1.2.3.4")).addressPlainText(false).build()).correctLengthAtBuild(true).build();
        this.answers.add(aRR);
        DnsResourceRecord aaaaRR = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.AAAA).dataClass(DnsClass.ANY).ttl(123123).rData((DnsResourceRecord.DnsRData)new DnsRDataAaaa.Builder().address((Inet6Address)InetAddress.getByName("2001:db8::3:2:1")).build()).correctLengthAtBuild(true).build();
        this.answers.add(aaaaRR);
        DnsResourceRecord cnameRR = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.CNAME).dataClass(DnsClass.ANY).ttl(123123).rData((DnsResourceRecord.DnsRData)new DnsRDataCName.Builder().cName(new DnsDomainName.Builder().labels(www).pointer(Short.valueOf((short)12)).build()).build()).correctLengthAtBuild(true).build();
        this.answers.add(cnameRR);
        DnsResourceRecord hinfoRR = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.HINFO).dataClass(DnsClass.ANY).ttl(123123).rData((DnsResourceRecord.DnsRData)new DnsRDataHInfo.Builder().cpu("AWESOME CPU").os("Windows").build()).correctLengthAtBuild(true).build();
        this.answers.add(hinfoRR);
        DnsResourceRecord mbRR = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.MB).dataClass(DnsClass.ANY).ttl(123123).rData((DnsResourceRecord.DnsRData)new DnsRDataMb.Builder().maDName(new DnsDomainName.Builder().labels(www).pointer(Short.valueOf((short)12)).build()).build()).correctLengthAtBuild(true).build();
        this.answers.add(mbRR);
        DnsResourceRecord aCaaRR = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.CAA).dataClass(DnsClass.ANY).ttl(321321).rData((DnsResourceRecord.DnsRData)new DnsRDataCaa.Builder().critical(true).reservedFlags((byte)18).tag("issue").value("ca.local").build()).correctLengthAtBuild(true).build();
        this.answers.add(aCaaRR);
        DnsResourceRecord mdRR = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.MD).dataClass(DnsClass.ANY).ttl(321321).rData((DnsResourceRecord.DnsRData)new DnsRDataMd.Builder().maDName(new DnsDomainName.Builder().labels(www).pointer(Short.valueOf((short)12)).build()).build()).correctLengthAtBuild(true).build();
        this.authorities.add(mdRR);
        DnsResourceRecord mfRR = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.MF).dataClass(DnsClass.ANY).ttl(321321).rData((DnsResourceRecord.DnsRData)new DnsRDataMf.Builder().maDName(new DnsDomainName.Builder().labels(www).pointer(Short.valueOf((short)12)).build()).build()).correctLengthAtBuild(true).build();
        this.authorities.add(mfRR);
        DnsResourceRecord mgRR = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.MG).dataClass(DnsClass.ANY).ttl(321321).rData((DnsResourceRecord.DnsRData)new DnsRDataMg.Builder().mgMName(new DnsDomainName.Builder().labels(www).pointer(Short.valueOf((short)12)).build()).build()).correctLengthAtBuild(true).build();
        this.authorities.add(mgRR);
        DnsResourceRecord minfoRR = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.MINFO).dataClass(DnsClass.ANY).ttl(321321).rData((DnsResourceRecord.DnsRData)new DnsRDataMInfo.Builder().eMailBx(new DnsDomainName.Builder().labels(hogeDomain).build()).rMailBx(new DnsDomainName.Builder().labels(fooDomain).build()).build()).correctLengthAtBuild(true).build();
        this.authorities.add(minfoRR);
        DnsResourceRecord mrRR = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.MR).dataClass(DnsClass.ANY).ttl(321321).rData((DnsResourceRecord.DnsRData)new DnsRDataMr.Builder().newName(new DnsDomainName.Builder().labels(fooDomain).build()).build()).correctLengthAtBuild(true).build();
        this.authorities.add(mrRR);
        DnsResourceRecord mxRR = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.MX).dataClass(DnsClass.ANY).ttl(321321).rData((DnsResourceRecord.DnsRData)new DnsRDataMx.Builder().preference((short)-11111).exchange(new DnsDomainName.Builder().labels(fooDomain).build()).build()).correctLengthAtBuild(true).build();
        this.authorities.add(mxRR);
        DnsResourceRecord nsRR = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.NS).dataClass(DnsClass.ANY).ttl(321321).rData((DnsResourceRecord.DnsRData)new DnsRDataNs.Builder().nsDName(new DnsDomainName.Builder().labels(fooDomain).build()).build()).correctLengthAtBuild(true).build();
        this.additionalInfo.add(nsRR);
        DnsResourceRecord nullRR = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.NULL).dataClass(DnsClass.ANY).ttl(123456).rData((DnsResourceRecord.DnsRData)new DnsRDataNull.Builder().rawData(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}).build()).correctLengthAtBuild(true).build();
        this.additionalInfo.add(nullRR);
        DnsResourceRecord ptrRR = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.PTR).dataClass(DnsClass.ANY).ttl(321321).rData((DnsResourceRecord.DnsRData)new DnsRDataPtr.Builder().ptrDName(new DnsDomainName.Builder().labels(fooDomain).build()).build()).correctLengthAtBuild(true).build();
        this.additionalInfo.add(ptrRR);
        DnsResourceRecord soaRR = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.SOA).dataClass(DnsClass.ANY).ttl(321321).rData((DnsResourceRecord.DnsRData)new DnsRDataSoa.Builder().mName(new DnsDomainName.Builder().labels(hogeDomain).build()).rName(new DnsDomainName.Builder().labels(fooDomain).build()).serial(11111111).refresh(22222222).retry(33333333).expire(44444444).minimum(55555555).build()).correctLengthAtBuild(true).build();
        this.additionalInfo.add(soaRR);
        ArrayList<String> txts = new ArrayList<String>();
        txts.add("Pen");
        txts.add("Pineapple");
        txts.add("Apple");
        txts.add("Pen");
        DnsResourceRecord txtRR = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.TXT).dataClass(DnsClass.ANY).ttl(321321).rData((DnsResourceRecord.DnsRData)new DnsRDataTxt.Builder().texts(txts).build()).correctLengthAtBuild(true).build();
        this.additionalInfo.add(txtRR);
        DnsResourceRecord wksRR1 = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.WKS).dataClass(DnsClass.ANY).ttl(321321).rData((DnsResourceRecord.DnsRData)new DnsRDataWks.Builder().address((Inet4Address)InetAddress.getByName("4.3.2.1")).protocol(IpNumber.UDP).bitMap(new byte[]{0, 0, 0, 0, -127, 0, 16}).build()).correctLengthAtBuild(true).build();
        this.additionalInfo.add(wksRR1);
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ports.add(20);
        ports.add(300);
        ports.add(4000);
        DnsResourceRecord wksRR2 = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.WKS).dataClass(DnsClass.ANY).ttl(321321).rData((DnsResourceRecord.DnsRData)new DnsRDataWks.Builder().address((Inet4Address)InetAddress.getByName("2.3.2.3")).protocol(IpNumber.TCP).portNumbers(ports).build()).correctLengthAtBuild(true).build();
        this.additionalInfo.add(wksRR2);
        DnsResourceRecord aRRStr = (DnsResourceRecord)new DnsResourceRecord.Builder().name(new DnsDomainName.Builder().labels(hogeDomain).build()).dataType(DnsResourceRecordType.A).dataClass(DnsClass.ANY).ttl(123123).rData((DnsResourceRecord.DnsRData)new DnsRDataA.Builder().address((Inet4Address)InetAddress.getByName("192.168.0.100")).addressPlainText(true).build()).correctLengthAtBuild(true).build();
        this.additionalInfo.add(aRRStr);
        DnsResourceRecord optRR = (DnsResourceRecord)new DnsResourceRecord.Builder().name(DnsDomainName.ROOT_DOMAIN).dataType(DnsResourceRecordType.OPT).dataClass(DnsClass.ANY).ttl(123123).correctLengthAtBuild(true).build();
        this.additionalInfo.add(optRR);
        this.packet = new DnsPacket.Builder().id(this.id).response(this.response).opCode(this.opCode).authoritativeAnswer(this.authoritativeAnswer).truncated(this.truncated).recursionDesired(this.recursionDesired).recursionAvailable(this.recursionAvailable).reserved(this.reserved).authenticData(this.authenticData).checkingDisabled(this.checkingDisabled).rCode(this.rCode).qdCount(this.qdCount).anCount(this.anCount).nsCount(this.nsCount).arCount(this.arCount).questions(this.questions).answers(this.answers).authorities(this.authorities).additionalInfo(this.additionalInfo).build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        Inet6Address dstAddr;
        Inet6Address srcAddr;
        try {
            srcAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:1");
            dstAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:2");
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)"Never get here.");
        }
        UdpPacket.Builder udpb = new UdpPacket.Builder().dstPort(UdpPort.DOMAIN).srcPort(UdpPort.getInstance((Short)32211)).srcAddr((InetAddress)srcAddr).dstAddr((InetAddress)dstAddr).correctChecksumAtBuild(true).correctLengthAtBuild(true).payloadBuilder((Packet.Builder)new SimpleBuilder((Packet)this.packet));
        IpV6Packet.Builder IpV6b = new IpV6Packet.Builder().version(IpVersion.IPV6).trafficClass((IpV6Packet.IpV6TrafficClass)IpV6SimpleTrafficClass.newInstance((byte)18)).flowLabel((IpV6Packet.IpV6FlowLabel)IpV6SimpleFlowLabel.newInstance((int)74565)).nextHeader(IpNumber.UDP).hopLimit((byte)100).srcAddr(srcAddr).dstAddr(dstAddr).payloadBuilder((Packet.Builder)udpb).correctLengthAtBuild(true);
        EthernetPacket.Builder eb = new EthernetPacket.Builder().dstAddr(MacAddress.getByName((String)"fe:00:00:00:00:02")).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV6).payloadBuilder((Packet.Builder)IpV6b).paddingAtBuild(true);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + DnsPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        logger.info("########## " + DnsPacketTest.class.getSimpleName() + " END ##########");
    }

    @Test
    public void testGetHeader() {
        int i;
        DnsPacket.DnsHeader h = this.packet.getHeader();
        Assert.assertEquals((long)this.id, (long)h.getId());
        Assert.assertEquals((Object)this.response, (Object)h.isResponse());
        Assert.assertEquals((Object)this.opCode, (Object)h.getOpCode());
        Assert.assertEquals((Object)this.authoritativeAnswer, (Object)h.isAuthoritativeAnswer());
        Assert.assertEquals((Object)this.truncated, (Object)h.isTruncated());
        Assert.assertEquals((Object)this.recursionDesired, (Object)h.isRecursionDesired());
        Assert.assertEquals((Object)this.recursionAvailable, (Object)h.isRecursionAvailable());
        Assert.assertEquals((Object)this.reserved, (Object)h.getReservedBit());
        Assert.assertEquals((Object)this.authenticData, (Object)h.isAuthenticData());
        Assert.assertEquals((Object)this.checkingDisabled, (Object)h.isCheckingDisabled());
        Assert.assertEquals((Object)this.rCode, (Object)h.getrCode());
        Assert.assertEquals((long)this.qdCount, (long)h.getQdCount());
        Assert.assertEquals((long)this.anCount, (long)h.getAnCount());
        Assert.assertEquals((long)this.nsCount, (long)h.getNsCount());
        Assert.assertEquals((long)this.arCount, (long)h.getArCount());
        Assert.assertEquals((long)this.questions.size(), (long)h.getQuestions().size());
        for (i = 0; i < this.questions.size(); ++i) {
            Assert.assertEquals((Object)this.questions.get(i), h.getQuestions().get(i));
        }
        Assert.assertEquals((long)this.answers.size(), (long)h.getAnswers().size());
        for (i = 0; i < this.answers.size(); ++i) {
            Assert.assertEquals((Object)this.answers.get(i), h.getAnswers().get(i));
        }
        Assert.assertEquals((long)this.authorities.size(), (long)h.getAuthorities().size());
        for (i = 0; i < this.authorities.size(); ++i) {
            Assert.assertEquals((Object)this.authorities.get(i), h.getAuthorities().get(i));
        }
        Assert.assertEquals((long)this.additionalInfo.size(), (long)h.getAdditionalInfo().size());
        for (i = 0; i < this.additionalInfo.size(); ++i) {
            Assert.assertEquals((Object)this.additionalInfo.get(i), h.getAdditionalInfo().get(i));
        }
        DnsPacket.Builder bldr = this.packet.getBuilder();
        bldr.qdCount((short)0);
        bldr.anCount((short)0);
        bldr.nsCount((short)0);
        bldr.arCount((short)0);
        DnsPacket p = bldr.build();
        Assert.assertEquals((long)0L, (long)((short)p.getHeader().getQdCountAsInt()));
        Assert.assertEquals((long)0L, (long)((short)p.getHeader().getAnCountAsInt()));
        Assert.assertEquals((long)0L, (long)((short)p.getHeader().getNsCountAsInt()));
        Assert.assertEquals((long)0L, (long)((short)p.getHeader().getArCountAsInt()));
        bldr.qdCount((short)12345);
        bldr.anCount((short)12345);
        bldr.nsCount((short)12345);
        bldr.arCount((short)12345);
        p = bldr.build();
        Assert.assertEquals((long)12345L, (long)((short)p.getHeader().getQdCountAsInt()));
        Assert.assertEquals((long)12345L, (long)((short)p.getHeader().getAnCountAsInt()));
        Assert.assertEquals((long)12345L, (long)((short)p.getHeader().getNsCountAsInt()));
        Assert.assertEquals((long)12345L, (long)((short)p.getHeader().getArCountAsInt()));
        bldr.qdCount((short)Short.MAX_VALUE);
        bldr.anCount((short)Short.MAX_VALUE);
        bldr.nsCount((short)Short.MAX_VALUE);
        bldr.arCount((short)Short.MAX_VALUE);
        p = bldr.build();
        Assert.assertEquals((long)32767L, (long)((short)p.getHeader().getQdCountAsInt()));
        Assert.assertEquals((long)32767L, (long)((short)p.getHeader().getAnCountAsInt()));
        Assert.assertEquals((long)32767L, (long)((short)p.getHeader().getNsCountAsInt()));
        Assert.assertEquals((long)32767L, (long)((short)p.getHeader().getArCountAsInt()));
        bldr.qdCount((short)-1);
        bldr.anCount((short)-1);
        bldr.nsCount((short)-1);
        bldr.arCount((short)-1);
        p = bldr.build();
        Assert.assertEquals((long)-1L, (long)((short)p.getHeader().getQdCountAsInt()));
        Assert.assertEquals((long)-1L, (long)((short)p.getHeader().getAnCountAsInt()));
        Assert.assertEquals((long)-1L, (long)((short)p.getHeader().getNsCountAsInt()));
        Assert.assertEquals((long)-1L, (long)((short)p.getHeader().getArCountAsInt()));
        bldr.qdCount((short)Short.MIN_VALUE);
        bldr.anCount((short)Short.MIN_VALUE);
        bldr.nsCount((short)Short.MIN_VALUE);
        bldr.arCount((short)Short.MIN_VALUE);
        p = bldr.build();
        Assert.assertEquals((long)-32768L, (long)((short)p.getHeader().getQdCountAsInt()));
        Assert.assertEquals((long)-32768L, (long)((short)p.getHeader().getAnCountAsInt()));
        Assert.assertEquals((long)-32768L, (long)((short)p.getHeader().getNsCountAsInt()));
        Assert.assertEquals((long)-32768L, (long)((short)p.getHeader().getArCountAsInt()));
    }

    @Test
    public void testNewPacket() {
        try {
            DnsPacket p = DnsPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }
}

