/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.AbstractPacketTest;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.IpV6SimpleFlowLabel;
import org.pcap4j.packet.IpV6SimpleTrafficClass;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.RandomPacketTester;
import org.pcap4j.packet.UdpPacket;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.packet.namednumber.UdpPort;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpV6PacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(IpV6PacketTest.class);
    private final IpVersion version = IpVersion.IPV6;
    private final IpV6Packet.IpV6TrafficClass trafficClass = IpV6SimpleTrafficClass.newInstance((byte)18);
    private final IpV6Packet.IpV6FlowLabel flowLabel = IpV6SimpleFlowLabel.newInstance((int)74565);
    private final short payloadLength = (short)12;
    private final IpNumber nextHeader = IpNumber.UDP;
    private final byte hopLimit = (byte)100;
    private final Inet6Address srcAddr;
    private final Inet6Address dstAddr;
    private final IpV6Packet packet;

    public IpV6PacketTest() throws Exception {
        try {
            this.srcAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:1");
            this.dstAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:2");
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        UnknownPacket.Builder unknownb = new UnknownPacket.Builder();
        unknownb.rawData(new byte[]{0, 1, 2, 3});
        UdpPacket.Builder udpb = new UdpPacket.Builder();
        udpb.dstPort(UdpPort.getInstance((Short)0)).srcPort(UdpPort.SNMP_TRAP).dstAddr((InetAddress)this.dstAddr).srcAddr((InetAddress)this.srcAddr).payloadBuilder((Packet.Builder)unknownb).correctChecksumAtBuild(true).correctLengthAtBuild(true);
        IpV6Packet.Builder b = new IpV6Packet.Builder();
        b.version(this.version).trafficClass(this.trafficClass).flowLabel(this.flowLabel).payloadLength(this.payloadLength).nextHeader(this.nextHeader).hopLimit(this.hopLimit).srcAddr(this.srcAddr).dstAddr(this.dstAddr).correctLengthAtBuild(false).payloadBuilder((Packet.Builder)udpb);
        this.packet = b.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.getByName((String)"fe:00:00:00:00:02")).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV6).payloadBuilder((Packet.Builder)this.packet.getBuilder()).paddingAtBuild(true);
        ((UdpPacket.Builder)eb.get(UdpPacket.Builder.class)).dstAddr((InetAddress)this.packet.getHeader().getDstAddr()).srcAddr((InetAddress)this.packet.getHeader().getSrcAddr());
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + IpV6PacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            IpV6Packet p = IpV6Packet.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testNewPacketRandom() {
        RandomPacketTester.testClass(IpV6Packet.class, (Packet)this.packet);
    }

    @Test
    public void testGetHeader() {
        IpV6Packet.IpV6Header h = this.packet.getHeader();
        Assert.assertEquals((Object)this.version, (Object)h.getVersion());
        Assert.assertEquals((Object)this.trafficClass, (Object)h.getTrafficClass());
        Assert.assertEquals((Object)this.flowLabel, (Object)h.getFlowLabel());
        Assert.assertEquals((long)this.payloadLength, (long)h.getPayloadLength());
        Assert.assertEquals((Object)this.nextHeader, (Object)h.getNextHeader());
        Assert.assertEquals((long)this.hopLimit, (long)h.getHopLimit());
        Assert.assertEquals((Object)this.srcAddr, (Object)h.getSrcAddr());
        Assert.assertEquals((Object)this.dstAddr, (Object)h.getDstAddr());
        IpV6Packet.Builder b = this.packet.getBuilder();
        b.payloadLength((short)0);
        b.hopLimit((byte)0);
        IpV6Packet p = b.build();
        Assert.assertEquals((long)0L, (long)((short)p.getHeader().getPayloadLengthAsInt()));
        Assert.assertEquals((long)0L, (long)((byte)p.getHeader().getHopLimitAsInt()));
        b.payloadLength((short)-1);
        b.hopLimit((byte)-1);
        p = b.build();
        Assert.assertEquals((long)-1L, (long)((short)p.getHeader().getPayloadLengthAsInt()));
        Assert.assertEquals((long)-1L, (long)((byte)p.getHeader().getHopLimitAsInt()));
        b.payloadLength((short)Short.MAX_VALUE);
        b.hopLimit((byte)127);
        p = b.build();
        Assert.assertEquals((long)32767L, (long)((short)p.getHeader().getPayloadLengthAsInt()));
        Assert.assertEquals((long)127L, (long)((byte)p.getHeader().getHopLimitAsInt()));
        b.payloadLength((short)Short.MIN_VALUE);
        b.hopLimit((byte)-128);
        p = b.build();
        Assert.assertEquals((long)-32768L, (long)((short)p.getHeader().getPayloadLengthAsInt()));
        Assert.assertEquals((long)-128L, (long)((byte)p.getHeader().getHopLimitAsInt()));
    }
}

