/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.AbstractPacketTest;
import org.pcap4j.packet.ArpPacket;
import org.pcap4j.packet.Dot1qVlanTagPacket;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.RandomPacketTester;
import org.pcap4j.packet.SimpleBuilder;
import org.pcap4j.packet.namednumber.ArpHardwareType;
import org.pcap4j.packet.namednumber.ArpOperation;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dot1qVlanTaggedPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(Dot1qVlanTaggedPacketTest.class);
    private final Dot1qVlanTagPacket packet;
    private final byte priority;
    private final boolean cfi;
    private final short vid;
    private final EtherType type;

    public Dot1qVlanTaggedPacketTest() {
        ArpPacket.Builder ab = new ArpPacket.Builder();
        try {
            ab.hardwareType(ArpHardwareType.ETHERNET).protocolType(EtherType.IPV4).hardwareAddrLength((byte)6).protocolAddrLength((byte)4).srcHardwareAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).dstHardwareAddr(MacAddress.ETHER_BROADCAST_ADDRESS).srcProtocolAddr(InetAddress.getByAddress(new byte[]{-64, 0, 2, 1})).dstProtocolAddr(InetAddress.getByAddress(new byte[]{-64, 0, 2, 2})).operation(ArpOperation.REQUEST);
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        this.priority = (byte)3;
        this.cfi = false;
        this.vid = (short)123;
        this.type = EtherType.ARP;
        Dot1qVlanTagPacket.Builder db = new Dot1qVlanTagPacket.Builder();
        db.priority(this.priority).cfi(this.cfi).vid(this.vid).type(this.type).payloadBuilder((Packet.Builder)ab);
        this.packet = db.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(((ArpPacket)this.packet.getPayload()).getHeader().getDstHardwareAddr()).srcAddr(((ArpPacket)this.packet.getPayload()).getHeader().getSrcHardwareAddr()).type(EtherType.DOT1Q_VLAN_TAGGED_FRAMES).payloadBuilder((Packet.Builder)new SimpleBuilder((Packet)this.packet)).paddingAtBuild(true);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + Dot1qVlanTaggedPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            Dot1qVlanTagPacket p = Dot1qVlanTagPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testNewPacketRandom() {
        RandomPacketTester.testClass(Dot1qVlanTagPacket.class, (Packet)this.packet);
    }

    @Test
    public void testGetHeader() {
        Dot1qVlanTagPacket.Dot1qVlanTagHeader h = this.packet.getHeader();
        Assert.assertEquals((long)this.priority, (long)h.getPriority());
        Assert.assertEquals((Object)this.cfi, (Object)h.getCfi());
        Assert.assertEquals((long)this.vid, (long)h.getVid());
        Assert.assertEquals((Object)this.type, (Object)h.getType());
        Dot1qVlanTagPacket.Builder b = this.packet.getBuilder();
        b.vid((short)0);
        Dot1qVlanTagPacket p = b.build();
        Assert.assertEquals((long)0L, (long)((short)p.getHeader().getVidAsInt()));
        b.vid((short)1000);
        p = b.build();
        Assert.assertEquals((long)1000L, (long)((short)p.getHeader().getVidAsInt()));
        b.vid((short)4095);
        p = b.build();
        Assert.assertEquals((long)4095L, (long)((short)p.getHeader().getVidAsInt()));
        b.vid((short)4096);
        try {
            p = b.build();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        b.vid((short)-1);
        try {
            p = b.build();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        b.vid((short)100);
        b.priority((byte)-1);
        try {
            p = b.build();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        b.priority((byte)0);
        try {
            p = b.build();
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
        b.priority((byte)7);
        try {
            p = b.build();
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
        b.priority((byte)8);
        try {
            p = b.build();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }
}

