/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet6Address;
import java.net.InetAddress;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.AbstractPacketTest;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.GtpV1Packet;
import org.pcap4j.packet.GtpVersion;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.IpV6SimpleFlowLabel;
import org.pcap4j.packet.IpV6SimpleTrafficClass;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UdpPacket;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.GtpV1ExtensionHeaderType;
import org.pcap4j.packet.namednumber.GtpV1MessageType;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.packet.namednumber.UdpPort;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtpV1PacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(GtpV1PacketTest.class);
    private final GtpVersion version = GtpVersion.V1;
    private final GtpV1Packet.ProtocolType protocolType = GtpV1Packet.ProtocolType.GTP;
    private final boolean reserved;
    private final boolean extensionHeaderFlag;
    private final boolean sequenceNumberFlag;
    private final boolean nPduNumberFlag;
    private final GtpV1MessageType messageType = GtpV1MessageType.ECHO_RESPONSE;
    private final short length = (short)8;
    private final int teid;
    private final Short sequenceNumber = 4321;
    private final Byte nPduNumber = -34;
    private final GtpV1ExtensionHeaderType nextExtensionHeaderType = GtpV1ExtensionHeaderType.PDCP_PDU_NUMBER;
    private final GtpV1Packet packet;

    public GtpV1PacketTest() throws Exception {
        this.reserved = false;
        this.extensionHeaderFlag = false;
        this.sequenceNumberFlag = true;
        this.nPduNumberFlag = true;
        this.teid = 1234567890;
        UnknownPacket.Builder unknownb = new UnknownPacket.Builder();
        unknownb.rawData(new byte[]{0, 1, 2, 3});
        GtpV1Packet.Builder b = new GtpV1Packet.Builder();
        b.version(this.version).protocolType(this.protocolType).reserved(this.reserved).extensionHeaderFlag(this.extensionHeaderFlag).sequenceNumberFlag(this.sequenceNumberFlag).nPduNumberFlag(this.nPduNumberFlag).messageType(this.messageType).length(this.length).teid(this.teid).sequenceNumber(this.sequenceNumber).nPduNumber(this.nPduNumber).nextExtensionHeaderType(this.nextExtensionHeaderType).payloadBuilder((Packet.Builder)unknownb);
        this.packet = b.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        Inet6Address dstAddr;
        Inet6Address srcAddr;
        try {
            srcAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:1");
            dstAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:2");
        }
        catch (Exception e) {
            throw new AssertionError((Object)"Never get here.");
        }
        UdpPacket.Builder b = new UdpPacket.Builder();
        b.dstPort(UdpPort.GTP_C).srcPort(UdpPort.getInstance((Short)12345)).correctChecksumAtBuild(true).correctLengthAtBuild(true).payloadBuilder((Packet.Builder)this.packet.getBuilder().correctLengthAtBuild(true));
        IpV6Packet.Builder IpV6b = new IpV6Packet.Builder();
        IpV6b.version(IpVersion.IPV6).trafficClass((IpV6Packet.IpV6TrafficClass)IpV6SimpleTrafficClass.newInstance((byte)18)).flowLabel((IpV6Packet.IpV6FlowLabel)IpV6SimpleFlowLabel.newInstance((int)74565)).nextHeader(IpNumber.UDP).hopLimit((byte)100).srcAddr(srcAddr).dstAddr(dstAddr).payloadBuilder((Packet.Builder)b).correctLengthAtBuild(true);
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.getByName((String)"fe:00:00:00:00:02")).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV6).payloadBuilder((Packet.Builder)IpV6b).paddingAtBuild(true);
        ((UdpPacket.Builder)eb.get(UdpPacket.Builder.class)).dstAddr((InetAddress)dstAddr).srcAddr((InetAddress)srcAddr);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + GtpV1PacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            GtpV1Packet p = GtpV1Packet.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testGetHeader() {
        GtpV1Packet.GtpV1Header h = this.packet.getHeader();
        Assert.assertEquals((Object)this.version, (Object)h.getVersion());
        Assert.assertEquals((Object)this.protocolType, (Object)h.getProtocolType());
        Assert.assertEquals((Object)this.extensionHeaderFlag, (Object)h.isExtensionHeaderFieldPresent());
        Assert.assertEquals((Object)this.sequenceNumberFlag, (Object)h.isSequenceNumberFieldPresent());
        Assert.assertEquals((Object)this.nPduNumberFlag, (Object)h.isNPduNumberFieldPresent());
        Assert.assertEquals((Object)this.messageType, (Object)h.getMessageType());
        Assert.assertEquals((long)this.length, (long)h.getLength());
        Assert.assertEquals((long)this.teid, (long)h.getTeid());
        Assert.assertEquals((Object)this.sequenceNumber, (Object)h.getSequenceNumber());
        Assert.assertEquals((Object)this.nPduNumber, (Object)h.getNPduNumber());
        Assert.assertEquals((Object)this.nextExtensionHeaderType, (Object)h.getNextExtensionHeaderType());
        GtpV1Packet.Builder b = this.packet.getBuilder();
        b.length((short)0);
        GtpV1Packet p = b.build();
        Assert.assertEquals((long)0L, (long)((short)p.getHeader().getLengthAsInt()));
        b.length((short)-1);
        p = b.build();
        Assert.assertEquals((long)-1L, (long)((short)p.getHeader().getLengthAsInt()));
        b.length((short)Short.MAX_VALUE);
        p = b.build();
        Assert.assertEquals((long)32767L, (long)((short)p.getHeader().getLengthAsInt()));
        b.length((short)Short.MIN_VALUE);
        p = b.build();
        Assert.assertEquals((long)-32768L, (long)((short)p.getHeader().getLengthAsInt()));
        b.teid(0);
        p = b.build();
        Assert.assertEquals((long)0L, (long)((int)p.getHeader().getTeidAsLong()));
        b.teid(-1);
        p = b.build();
        Assert.assertEquals((long)-1L, (long)((int)p.getHeader().getTeidAsLong()));
        b.teid(Integer.MAX_VALUE);
        p = b.build();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)((int)p.getHeader().getTeidAsLong()));
        b.teid(Integer.MIN_VALUE);
        p = b.build();
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)((int)p.getHeader().getTeidAsLong()));
        b.sequenceNumber(Short.valueOf((short)0));
        p = b.build();
        Assert.assertEquals((long)0L, (long)p.getHeader().getSequenceNumberAsInt().shortValue());
        b.sequenceNumber(Short.valueOf((short)-1));
        p = b.build();
        Assert.assertEquals((long)-1L, (long)p.getHeader().getSequenceNumberAsInt().shortValue());
        b.sequenceNumber(Short.valueOf((short)Short.MAX_VALUE));
        p = b.build();
        Assert.assertEquals((long)32767L, (long)p.getHeader().getSequenceNumberAsInt().shortValue());
        b.sequenceNumber(Short.valueOf((short)Short.MIN_VALUE));
        p = b.build();
        Assert.assertEquals((long)-32768L, (long)p.getHeader().getSequenceNumberAsInt().shortValue());
        b.nPduNumber(Byte.valueOf((byte)0));
        p = b.build();
        Assert.assertEquals((long)0L, (long)p.getHeader().getNPduNumberAsInt().byteValue());
        b.nPduNumber(Byte.valueOf((byte)-1));
        p = b.build();
        Assert.assertEquals((long)-1L, (long)p.getHeader().getNPduNumberAsInt().byteValue());
        b.nPduNumber(Byte.valueOf((byte)127));
        p = b.build();
        Assert.assertEquals((long)127L, (long)p.getHeader().getNPduNumberAsInt().byteValue());
        b.nPduNumber(Byte.valueOf((byte)-128));
        p = b.build();
        Assert.assertEquals((long)-128L, (long)p.getHeader().getNPduNumberAsInt().byteValue());
    }
}

