/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.AbstractPacketTest;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IcmpV6RouterSolicitationPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6NeighborDiscoverySourceLinkLayerAddressOption;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.IpV6SimpleFlowLabel;
import org.pcap4j.packet.IpV6SimpleTrafficClass;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.SimpleBuilder;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IcmpV6Code;
import org.pcap4j.packet.namednumber.IcmpV6Type;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcmpV6RouterSolicitationPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(IcmpV6RouterSolicitationPacketTest.class);
    private final IcmpV6RouterSolicitationPacket packet;
    private final int reserved;
    private final List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> options = new ArrayList<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption>();

    public IcmpV6RouterSolicitationPacketTest() {
        this.reserved = 123454321;
        IpV6NeighborDiscoverySourceLinkLayerAddressOption.Builder opt = new IpV6NeighborDiscoverySourceLinkLayerAddressOption.Builder();
        opt.linkLayerAddress(new byte[]{-1, 0, 0, 1, 2, 3}).correctLengthAtBuild(true);
        this.options.add((IcmpV6CommonPacket.IpV6NeighborDiscoveryOption)opt.build());
        IcmpV6RouterSolicitationPacket.Builder b = new IcmpV6RouterSolicitationPacket.Builder();
        b.reserved(this.reserved).options(this.options);
        this.packet = b.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        Inet6Address dstAddr;
        Inet6Address srcAddr;
        try {
            srcAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:1");
            dstAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:2");
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        IcmpV6CommonPacket.Builder icmpV6b = new IcmpV6CommonPacket.Builder();
        icmpV6b.type(IcmpV6Type.ROUTER_SOLICITATION).code(IcmpV6Code.NO_CODE).srcAddr(srcAddr).dstAddr(dstAddr).payloadBuilder((Packet.Builder)new SimpleBuilder((Packet)this.packet)).correctChecksumAtBuild(true);
        IpV6Packet.Builder ipv6b = new IpV6Packet.Builder();
        ipv6b.version(IpVersion.IPV6).trafficClass((IpV6Packet.IpV6TrafficClass)IpV6SimpleTrafficClass.newInstance((byte)18)).flowLabel((IpV6Packet.IpV6FlowLabel)IpV6SimpleFlowLabel.newInstance((int)74565)).nextHeader(IpNumber.ICMPV6).hopLimit((byte)100).srcAddr(srcAddr).dstAddr(dstAddr).correctLengthAtBuild(true).payloadBuilder((Packet.Builder)icmpV6b);
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.getByName((String)"fe:00:00:00:00:02")).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV6).payloadBuilder((Packet.Builder)ipv6b).paddingAtBuild(true);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + IcmpV6RouterSolicitationPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            IcmpV6RouterSolicitationPacket p = IcmpV6RouterSolicitationPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testGetHeader() {
        IcmpV6RouterSolicitationPacket.IcmpV6RouterSolicitationHeader h = this.packet.getHeader();
        Assert.assertEquals((long)this.reserved, (long)h.getReserved());
        Iterator iter = h.getOptions().iterator();
        for (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption expected : this.options) {
            IcmpV6CommonPacket.IpV6NeighborDiscoveryOption actual = (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption)iter.next();
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }
}

