/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.test.packet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.sql.Timestamp;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.pcap4j.core.PcapDumper;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.namednumber.DataLinkType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPacketTest.class);
    public static final String RESOURCE_DIR_PROP = AbstractPacketTest.class.getName() + ".resourceDir";
    public static final String TMP_DIR_PROP = AbstractPacketTest.class.getName() + ".tmpDir";
    private String originalLineSeparator;
    protected String resourceDirPath;
    protected String tmpDirPath;

    @Before
    public void setUp() throws Exception {
        this.originalLineSeparator = System.setProperty("line.separator", "\r\n");
        this.resourceDirPath = System.getProperty(RESOURCE_DIR_PROP, "src/test/resources");
        this.tmpDirPath = System.getProperty(TMP_DIR_PROP, "testdata");
        File tmpDir = new File(this.tmpDirPath);
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new IOException("Failed to make a test diectory: " + this.tmpDirPath);
        }
    }

    @After
    public void tearDown() throws Exception {
        System.setProperty("line.separator", this.originalLineSeparator);
        logger.info("==================================================");
    }

    protected abstract Packet getPacket() throws Exception;

    protected abstract Packet getWholePacket() throws Exception;

    @Test
    public void testGetBuilder() throws Exception {
        Packet.Builder ab = this.getPacket().getBuilder();
        Assert.assertEquals((Object)this.getPacket(), (Object)ab.build());
    }

    @Test
    public void testLength() throws Exception {
        Assert.assertEquals((long)this.getPacket().getRawData().length, (long)this.getPacket().length());
    }

    @Test
    public void testToString() throws Exception {
        String line;
        FileReader fr = new FileReader(this.resourceDirPath + "/" + this.getClass().getSimpleName() + ".log");
        BufferedReader fbr = new BufferedReader(fr);
        StringReader sr = new StringReader(this.getPacket().toString());
        BufferedReader sbr = new BufferedReader(sr);
        while ((line = fbr.readLine()) != null) {
            Assert.assertEquals((Object)line, (Object)sbr.readLine());
        }
        Assert.assertNull((Object)sbr.readLine());
        fbr.close();
        fr.close();
        sr.close();
        sbr.close();
    }

    @Test
    public void testDump() throws Exception {
        int size;
        String dumpFile = this.tmpDirPath + "/" + this.getClass().getSimpleName() + ".pcap";
        Packet p = this.getWholePacket();
        PcapHandle handle = Pcaps.openDead((DataLinkType)this.getDataLinkType(), (int)65536);
        PcapDumper dumper = handle.dumpOpen(dumpFile);
        dumper.dump(p, new Timestamp(0L));
        dumper.close();
        handle.close();
        PcapHandle reader = Pcaps.openOffline((String)dumpFile);
        Assert.assertEquals((Object)p, (Object)reader.getNextPacket());
        reader.close();
        FileInputStream in1 = new FileInputStream(this.resourceDirPath + "/" + this.getClass().getSimpleName() + ".pcap");
        FileInputStream in2 = new FileInputStream(dumpFile);
        byte[] buffer1 = new byte[100];
        byte[] buffer2 = new byte[100];
        while ((size = in1.read(buffer1)) != -1) {
            Assert.assertEquals((long)size, (long)in2.read(buffer2));
            Assert.assertArrayEquals((byte[])buffer1, (byte[])buffer2);
        }
        in1.close();
        in2.close();
    }

    protected DataLinkType getDataLinkType() {
        return DataLinkType.EN10MB;
    }

    @Test
    public void testWriteRead() throws Exception {
        String objFile = this.tmpDirPath + "/" + this.getClass().getSimpleName() + ".obj";
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(new File(objFile)));
        oos.writeObject(this.getPacket());
        oos.close();
        ObjectInputStream ois1 = new ObjectInputStream(new FileInputStream(new File(objFile)));
        Assert.assertEquals((Object)this.getPacket(), (Object)ois1.readObject());
        ois1.close();
        ObjectInputStream ois2 = new ObjectInputStream(new FileInputStream(new File(this.resourceDirPath + "/" + this.getClass().getSimpleName() + ".obj")));
        Assert.assertEquals((Object)this.getPacket(), (Object)ois2.readObject());
        ois2.close();
    }
}

