/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.test.packet;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.ArpPacket;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.SimpleBuilder;
import org.pcap4j.packet.namednumber.ArpHardwareType;
import org.pcap4j.packet.namednumber.ArpOperation;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.test.packet.AbstractPacketTest;
import org.pcap4j.test.packet.RandomPacketTester;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArpPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(ArpPacketTest.class);
    private final ArpPacket packet;
    private final ArpHardwareType hardwareType = ArpHardwareType.ETHERNET;
    private final EtherType protocolType = EtherType.IPV4;
    private final byte hardwareLength = (byte)6;
    private final byte protocolLength = (byte)4;
    private final MacAddress srcHardwareAddr = MacAddress.getByName((String)"fe:00:00:00:00:01");
    private final MacAddress dstHardwareAddr = MacAddress.ETHER_BROADCAST_ADDRESS;
    private final InetAddress srcProtocolAddr;
    private final InetAddress dstProtocolAddr;
    private final ArpOperation operation;

    public ArpPacketTest() {
        try {
            this.srcProtocolAddr = InetAddress.getByAddress(new byte[]{-64, 0, 2, 1});
            this.dstProtocolAddr = InetAddress.getByAddress(new byte[]{-64, 0, 2, 2});
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        this.operation = ArpOperation.REQUEST;
        ArpPacket.Builder ab = new ArpPacket.Builder();
        ab.hardwareType(this.hardwareType).protocolType(this.protocolType).hardwareAddrLength(this.hardwareLength).protocolAddrLength(this.protocolLength).srcHardwareAddr(this.srcHardwareAddr).dstHardwareAddr(this.dstHardwareAddr).srcProtocolAddr(this.srcProtocolAddr).dstProtocolAddr(this.dstProtocolAddr).operation(this.operation);
        this.packet = ab.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(this.packet.getHeader().getDstHardwareAddr()).srcAddr(this.packet.getHeader().getSrcHardwareAddr()).type(EtherType.ARP).payloadBuilder((Packet.Builder)new SimpleBuilder((Packet)this.packet)).paddingAtBuild(true);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + ArpPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        logger.info("########## " + ArpPacketTest.class.getSimpleName() + " END ##########");
    }

    @Test
    public void testGetHeader() {
        ArpPacket.ArpHeader h = this.packet.getHeader();
        Assert.assertEquals((Object)this.hardwareType, (Object)h.getHardwareType());
        Assert.assertEquals((Object)this.protocolType, (Object)h.getProtocolType());
        Assert.assertEquals((long)this.hardwareLength, (long)h.getHardwareAddrLength());
        Assert.assertEquals((long)this.hardwareLength, (long)((byte)h.getHardwareAddrLengthAsInt()));
        Assert.assertEquals((long)this.protocolLength, (long)h.getProtocolAddrLength());
        Assert.assertEquals((long)this.protocolLength, (long)((byte)h.getProtocolAddrLengthAsInt()));
        Assert.assertEquals((Object)this.dstHardwareAddr, (Object)h.getDstHardwareAddr());
        Assert.assertEquals((Object)this.srcHardwareAddr, (Object)h.getSrcHardwareAddr());
        Assert.assertEquals((Object)this.dstProtocolAddr, (Object)h.getDstProtocolAddr());
        Assert.assertEquals((Object)this.srcProtocolAddr, (Object)h.getSrcProtocolAddr());
        Assert.assertEquals((Object)this.operation, (Object)h.getOperation());
        ArpPacket.Builder ab = this.packet.getBuilder();
        ab.hardwareAddrLength((byte)0);
        ab.protocolAddrLength((byte)0);
        ArpPacket p = ab.build();
        Assert.assertEquals((long)0L, (long)((byte)p.getHeader().getHardwareAddrLengthAsInt()));
        Assert.assertEquals((long)0L, (long)((byte)p.getHeader().getProtocolAddrLengthAsInt()));
        ab.hardwareAddrLength((byte)50);
        ab.protocolAddrLength((byte)50);
        p = ab.build();
        Assert.assertEquals((long)50L, (long)((byte)p.getHeader().getHardwareAddrLengthAsInt()));
        Assert.assertEquals((long)50L, (long)((byte)p.getHeader().getProtocolAddrLengthAsInt()));
        ab.hardwareAddrLength((byte)127);
        ab.protocolAddrLength((byte)127);
        p = ab.build();
        Assert.assertEquals((long)127L, (long)((byte)p.getHeader().getHardwareAddrLengthAsInt()));
        Assert.assertEquals((long)127L, (long)((byte)p.getHeader().getProtocolAddrLengthAsInt()));
        ab.hardwareAddrLength((byte)-1);
        ab.protocolAddrLength((byte)-1);
        p = ab.build();
        Assert.assertEquals((long)-1L, (long)((byte)p.getHeader().getHardwareAddrLengthAsInt()));
        Assert.assertEquals((long)-1L, (long)((byte)p.getHeader().getProtocolAddrLengthAsInt()));
        ab.hardwareAddrLength((byte)-128);
        ab.protocolAddrLength((byte)-128);
        p = ab.build();
        Assert.assertEquals((long)-128L, (long)((byte)p.getHeader().getHardwareAddrLengthAsInt()));
        Assert.assertEquals((long)-128L, (long)((byte)p.getHeader().getProtocolAddrLengthAsInt()));
    }

    @Test
    public void testNewPacket() {
        try {
            ArpPacket p = ArpPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testNewPacketRandom() {
        RandomPacketTester.testClass(ArpPacket.class, (Packet)this.packet);
    }
}

