/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.test.packet;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.ArpPacket;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.namednumber.ArpHardwareType;
import org.pcap4j.packet.namednumber.ArpOperation;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.test.packet.AbstractPacketTest;
import org.pcap4j.test.packet.RandomPacketTester;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EthernetPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(EthernetPacketTest.class);
    private final EthernetPacket packet;
    private final MacAddress dstAddr = MacAddress.ETHER_BROADCAST_ADDRESS;
    private final MacAddress srcAddr = MacAddress.getByName((String)"fe:00:00:00:00:01");
    private final EtherType type = EtherType.ARP;
    private final byte[] pad = new byte[]{0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1};

    public EthernetPacketTest() {
        ArpPacket.Builder ab = new ArpPacket.Builder();
        try {
            ab.hardwareType(ArpHardwareType.ETHERNET).protocolType(EtherType.IPV4).hardwareAddrLength((byte)6).protocolAddrLength((byte)4).srcHardwareAddr(this.srcAddr).dstHardwareAddr(this.dstAddr).srcProtocolAddr(InetAddress.getByAddress(new byte[]{-64, 0, 2, 1})).dstProtocolAddr(InetAddress.getByAddress(new byte[]{-64, 0, 2, 2})).operation(ArpOperation.REQUEST);
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(this.dstAddr).srcAddr(this.srcAddr).type(this.type).payloadBuilder((Packet.Builder)ab).pad(this.pad).paddingAtBuild(false);
        this.packet = eb.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        return this.packet;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + EthernetPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            EthernetPacket p = EthernetPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testNewPacketRandom() {
        RandomPacketTester.testClass(EthernetPacket.class, (Packet)this.packet);
    }

    @Test
    public void testGetHeader() {
        EthernetPacket.EthernetHeader h = this.packet.getHeader();
        Assert.assertEquals((Object)this.dstAddr, (Object)h.getDstAddr());
        Assert.assertEquals((Object)this.srcAddr, (Object)h.getSrcAddr());
        Assert.assertEquals((Object)this.type, (Object)h.getType());
        Assert.assertArrayEquals((byte[])this.pad, (byte[])this.packet.getPad());
    }
}

