/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.test.packet;

import java.net.Inet4Address;
import java.net.InetAddress;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.HdlcPppPacket;
import org.pcap4j.packet.IcmpV4CommonPacket;
import org.pcap4j.packet.IcmpV4EchoPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV4Rfc1349Tos;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.DataLinkType;
import org.pcap4j.packet.namednumber.IcmpV4Code;
import org.pcap4j.packet.namednumber.IcmpV4Type;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.packet.namednumber.PppDllProtocol;
import org.pcap4j.test.packet.AbstractPacketTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdlcPppPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(HdlcPppPacketTest.class);
    private final byte address = (byte)-1;
    private final byte control = (byte)3;
    private final PppDllProtocol protocol = PppDllProtocol.IPV4;
    private final byte[] pad = new byte[]{0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1};
    private final HdlcPppPacket packet;

    public HdlcPppPacketTest() throws Exception {
        UnknownPacket.Builder unknownb = new UnknownPacket.Builder().rawData(new byte[]{0, 1, 2, 3});
        IcmpV4EchoPacket.Builder echob = new IcmpV4EchoPacket.Builder().identifier((short)1234).sequenceNumber((short)4321).payloadBuilder((Packet.Builder)unknownb);
        IcmpV4CommonPacket.Builder icmpb = new IcmpV4CommonPacket.Builder().type(IcmpV4Type.ECHO).code(IcmpV4Code.NO_CODE).correctChecksumAtBuild(true).payloadBuilder((Packet.Builder)echob);
        IpV4Packet.Builder ipb = new IpV4Packet.Builder().version(IpVersion.IPV4).tos((IpV4Packet.IpV4Tos)IpV4Rfc1349Tos.newInstance((byte)117)).identification((short)123).reservedFlag(false).dontFragmentFlag(false).moreFragmentFlag(false).fragmentOffset((short)0).ttl((byte)111).protocol(IpNumber.ICMPV4).srcAddr((Inet4Address)InetAddress.getByName("192.0.2.1")).dstAddr((Inet4Address)InetAddress.getByName("192.0.2.2")).correctChecksumAtBuild(true).correctLengthAtBuild(true).paddingAtBuild(true).payloadBuilder((Packet.Builder)icmpb);
        HdlcPppPacket.Builder b = new HdlcPppPacket.Builder().address(this.address).control(this.control).protocol(this.protocol).payloadBuilder((Packet.Builder)ipb).pad(this.pad);
        this.packet = b.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        return this.packet;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + HdlcPppPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            HdlcPppPacket p = HdlcPppPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testGetHeader() {
        HdlcPppPacket.HdlcPppHeader h = this.packet.getHeader();
        Assert.assertEquals((long)this.address, (long)h.getAddress());
        Assert.assertEquals((long)this.control, (long)h.getControl());
        Assert.assertEquals((Object)this.protocol, (Object)h.getProtocol());
        Assert.assertArrayEquals((byte[])this.pad, (byte[])this.packet.getPad());
    }

    @Override
    protected DataLinkType getDataLinkType() {
        return DataLinkType.PPP;
    }
}

