/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.test.packet;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IcmpV4CommonPacket;
import org.pcap4j.packet.IcmpV4EchoPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV4Rfc1349Tos;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IcmpV4Code;
import org.pcap4j.packet.namednumber.IcmpV4Type;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.test.packet.AbstractPacketTest;
import org.pcap4j.test.packet.RandomPacketTester;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcmpV4CommonPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(IcmpV4CommonPacketTest.class);
    private final IcmpV4CommonPacket packet;
    private final IcmpV4Type type;
    private final IcmpV4Code code;
    private final short checksum;

    public IcmpV4CommonPacketTest() {
        UnknownPacket.Builder unknownb = new UnknownPacket.Builder();
        unknownb.rawData(new byte[]{0, 1, 2, 3});
        IcmpV4EchoPacket.Builder echob = new IcmpV4EchoPacket.Builder();
        echob.identifier((short)100).sequenceNumber((short)10).payloadBuilder((Packet.Builder)unknownb);
        this.type = IcmpV4Type.ECHO;
        this.code = IcmpV4Code.NO_CODE;
        this.checksum = (short)4660;
        IcmpV4CommonPacket.Builder b = new IcmpV4CommonPacket.Builder();
        b.type(this.type).code(this.code).checksum(this.checksum).correctChecksumAtBuild(false).payloadBuilder((Packet.Builder)echob);
        this.packet = b.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() throws UnknownHostException {
        IpV4Packet.Builder ipv4b = new IpV4Packet.Builder();
        ipv4b.version(IpVersion.IPV4).tos((IpV4Packet.IpV4Tos)IpV4Rfc1349Tos.newInstance((byte)0)).identification((short)100).ttl((byte)100).protocol(IpNumber.ICMPV4).srcAddr((Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 1})).dstAddr((Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 2})).payloadBuilder((Packet.Builder)this.packet.getBuilder().correctChecksumAtBuild(true)).correctChecksumAtBuild(true).correctLengthAtBuild(true);
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.getByName((String)"fe:00:00:00:00:02")).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV4).payloadBuilder((Packet.Builder)ipv4b).paddingAtBuild(true);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + IcmpV4CommonPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            IcmpV4CommonPacket p = IcmpV4CommonPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testNewPacketRandom() {
        RandomPacketTester.testClass(IcmpV4CommonPacket.class, (Packet)this.packet);
    }

    @Test
    public void testGetHeader() {
        IcmpV4CommonPacket.IcmpV4CommonHeader h = this.packet.getHeader();
        Assert.assertEquals((Object)this.type, (Object)h.getType());
        Assert.assertEquals((Object)this.code, (Object)h.getCode());
        Assert.assertEquals((long)this.checksum, (long)h.getChecksum());
    }

    @Test
    public void testHasValidChecksum() {
        Assert.assertFalse((boolean)this.packet.hasValidChecksum(false));
        Assert.assertFalse((boolean)this.packet.hasValidChecksum(true));
        IcmpV4CommonPacket.Builder b = this.packet.getBuilder();
        b.checksum((short)0).correctChecksumAtBuild(false);
        IcmpV4CommonPacket p = b.build();
        Assert.assertFalse((boolean)p.hasValidChecksum(false));
        Assert.assertTrue((boolean)p.hasValidChecksum(true));
        b.correctChecksumAtBuild(true);
        p = b.build();
        Assert.assertTrue((boolean)p.hasValidChecksum(false));
        Assert.assertTrue((boolean)p.hasValidChecksum(true));
    }
}

