/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.test.packet;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IcmpV4CommonPacket;
import org.pcap4j.packet.IcmpV4DestinationUnreachablePacket;
import org.pcap4j.packet.IcmpV4EchoPacket;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV4Rfc1349Tos;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.SimpleBuilder;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IcmpV4Code;
import org.pcap4j.packet.namednumber.IcmpV4Type;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.test.packet.AbstractPacketTest;
import org.pcap4j.util.IcmpV4Helper;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcmpV4DestinationUnreachablePacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(IcmpV4DestinationUnreachablePacketTest.class);
    private final IcmpV4DestinationUnreachablePacket packet;
    private final int unused;

    public IcmpV4DestinationUnreachablePacketTest() {
        this.unused = 12345;
        IcmpV4EchoPacket.Builder echob = new IcmpV4EchoPacket.Builder();
        echob.identifier((short)100).sequenceNumber((short)10).payloadBuilder((Packet.Builder)new UnknownPacket.Builder().rawData(new byte[]{0, 1, 2}));
        IcmpV4CommonPacket.Builder icmpV4b = new IcmpV4CommonPacket.Builder();
        icmpV4b.type(IcmpV4Type.ECHO).code(IcmpV4Code.NO_CODE).payloadBuilder((Packet.Builder)echob).correctChecksumAtBuild(true);
        IpV4Packet.Builder ipv4b = new IpV4Packet.Builder();
        try {
            ipv4b.version(IpVersion.IPV4).tos((IpV4Packet.IpV4Tos)IpV4Rfc1349Tos.newInstance((byte)0)).identification((short)100).ttl((byte)100).protocol(IpNumber.ICMPV4).srcAddr((Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 2})).dstAddr((Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 1})).payloadBuilder((Packet.Builder)icmpV4b).correctChecksumAtBuild(true).correctLengthAtBuild(true);
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        IcmpV4DestinationUnreachablePacket.Builder b = new IcmpV4DestinationUnreachablePacket.Builder();
        b.unused(this.unused).payload(IcmpV4Helper.makePacketForInvokingPacketField((Packet)ipv4b.build()));
        this.packet = b.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() throws UnknownHostException {
        IcmpV4CommonPacket.Builder icmpV4b = new IcmpV4CommonPacket.Builder();
        icmpV4b.type(IcmpV4Type.DESTINATION_UNREACHABLE).code(IcmpV4Code.HOST_UNREACHABLE).payloadBuilder((Packet.Builder)new SimpleBuilder((Packet)this.packet)).correctChecksumAtBuild(true);
        IpV4Packet.Builder ipv4b = new IpV4Packet.Builder();
        ipv4b.version(IpVersion.IPV4).tos((IpV4Packet.IpV4Tos)IpV4Rfc1349Tos.newInstance((byte)0)).identification((short)100).ttl((byte)100).protocol(IpNumber.ICMPV4).srcAddr((Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 1})).dstAddr((Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 2})).payloadBuilder((Packet.Builder)icmpV4b).correctChecksumAtBuild(true).correctLengthAtBuild(true);
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.getByName((String)"fe:00:00:00:00:02")).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV4).payloadBuilder((Packet.Builder)ipv4b).paddingAtBuild(true);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + IcmpV4DestinationUnreachablePacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        IcmpV4DestinationUnreachablePacket p;
        try {
            p = IcmpV4DestinationUnreachablePacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
        Assert.assertEquals((Object)this.packet, (Object)p);
        Assert.assertTrue((boolean)p.getPayload().contains(IpV4Packet.class));
        Assert.assertTrue((boolean)p.getPayload().contains(IcmpV4CommonPacket.class));
        Assert.assertTrue((boolean)p.getPayload().contains(IcmpV4EchoPacket.class));
        Assert.assertFalse((boolean)p.getPayload().contains(UnknownPacket.class));
        Assert.assertFalse((boolean)p.getPayload().contains(IllegalPacket.class));
    }

    @Test
    public void testGetHeader() {
        IcmpV4DestinationUnreachablePacket.IcmpV4DestinationUnreachableHeader h = this.packet.getHeader();
        Assert.assertEquals((long)this.unused, (long)h.getUnused());
    }
}

