/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.test.packet;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IcmpV6EchoRequestPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.IpV6SimpleFlowLabel;
import org.pcap4j.packet.IpV6SimpleTrafficClass;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IcmpV6Code;
import org.pcap4j.packet.namednumber.IcmpV6Type;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.test.packet.AbstractPacketTest;
import org.pcap4j.test.packet.RandomPacketTester;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcmpV6CommonPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(IcmpV6CommonPacketTest.class);
    private final IcmpV6CommonPacket packet;
    private final IcmpV6Type type;
    private final IcmpV6Code code;
    private final short checksum;
    private final Inet6Address srcAddr;
    private final Inet6Address dstAddr;

    public IcmpV6CommonPacketTest() {
        UnknownPacket.Builder unknownb = new UnknownPacket.Builder();
        unknownb.rawData(new byte[]{0, 1, 2, 3});
        IcmpV6EchoRequestPacket.Builder echob = new IcmpV6EchoRequestPacket.Builder();
        echob.identifier((short)100).sequenceNumber((short)10).payloadBuilder((Packet.Builder)unknownb);
        this.type = IcmpV6Type.ECHO_REQUEST;
        this.code = IcmpV6Code.NO_CODE;
        this.checksum = (short)4660;
        try {
            this.srcAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:1");
            this.dstAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:2");
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        IcmpV6CommonPacket.Builder b = new IcmpV6CommonPacket.Builder();
        b.type(this.type).code(this.code).checksum(this.checksum).srcAddr(this.srcAddr).dstAddr(this.dstAddr).correctChecksumAtBuild(false).payloadBuilder((Packet.Builder)echob);
        this.packet = b.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        IpV6Packet.Builder ipv6b = new IpV6Packet.Builder();
        ipv6b.version(IpVersion.IPV6).trafficClass((IpV6Packet.IpV6TrafficClass)IpV6SimpleTrafficClass.newInstance((byte)18)).flowLabel((IpV6Packet.IpV6FlowLabel)IpV6SimpleFlowLabel.newInstance((int)74565)).nextHeader(IpNumber.ICMPV6).hopLimit((byte)100).srcAddr(this.srcAddr).dstAddr(this.dstAddr).correctLengthAtBuild(true).payloadBuilder((Packet.Builder)this.packet.getBuilder().srcAddr(this.srcAddr).dstAddr(this.dstAddr).correctChecksumAtBuild(true));
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.getByName((String)"fe:00:00:00:00:02")).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV6).payloadBuilder((Packet.Builder)ipv6b).paddingAtBuild(true);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + IcmpV6CommonPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            IcmpV6CommonPacket p = IcmpV6CommonPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testNewPacketRandom() {
        RandomPacketTester.testClass(IcmpV6CommonPacket.class, (Packet)this.packet);
    }

    @Test
    public void testGetHeader() {
        IcmpV6CommonPacket.IcmpV6CommonHeader h = this.packet.getHeader();
        Assert.assertEquals((Object)this.type, (Object)h.getType());
        Assert.assertEquals((Object)this.code, (Object)h.getCode());
        Assert.assertEquals((long)this.checksum, (long)h.getChecksum());
    }

    @Test
    public void testHasValidChecksum() {
        IcmpV6CommonPacket.Builder b = this.packet.getBuilder();
        b.srcAddr(this.srcAddr).dstAddr(this.dstAddr);
        IcmpV6CommonPacket p = b.correctChecksumAtBuild(false).build();
        Assert.assertFalse((boolean)this.packet.hasValidChecksum(this.srcAddr, this.dstAddr, false));
        Assert.assertFalse((boolean)this.packet.hasValidChecksum(this.srcAddr, this.dstAddr, true));
        b.checksum((short)0).correctChecksumAtBuild(false);
        p = b.build();
        Assert.assertFalse((boolean)p.hasValidChecksum(this.srcAddr, this.dstAddr, false));
        Assert.assertTrue((boolean)p.hasValidChecksum(this.srcAddr, this.dstAddr, true));
        b.checksum((short)1234).correctChecksumAtBuild(true);
        p = b.build();
        Assert.assertTrue((boolean)p.hasValidChecksum(this.srcAddr, this.dstAddr, false));
        Assert.assertTrue((boolean)p.hasValidChecksum(this.srcAddr, this.dstAddr, true));
    }
}

