/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.test.packet;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IcmpV6HomeAgentAddressDiscoveryReplyPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.IpV6SimpleFlowLabel;
import org.pcap4j.packet.IpV6SimpleTrafficClass;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.SimpleBuilder;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IcmpV6Code;
import org.pcap4j.packet.namednumber.IcmpV6Type;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.test.packet.AbstractPacketTest;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcmpV6HomeAgentAddressDiscoveryReplyPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(IcmpV6HomeAgentAddressDiscoveryReplyPacketTest.class);
    private final IcmpV6HomeAgentAddressDiscoveryReplyPacket packet;
    private final short identifier;
    private final short reserved;
    private final List<Inet6Address> homeAgentAddresses = new ArrayList<Inet6Address>();

    public IcmpV6HomeAgentAddressDiscoveryReplyPacketTest() throws UnknownHostException {
        this.identifier = (short)1234;
        this.reserved = (short)12345;
        this.homeAgentAddresses.add((Inet6Address)InetAddress.getByName("2001:db8::aaaa:bbbb:0:0"));
        this.homeAgentAddresses.add((Inet6Address)InetAddress.getByName("2001:db8::aaaa:bbbb:0:1"));
        IcmpV6HomeAgentAddressDiscoveryReplyPacket.Builder b = new IcmpV6HomeAgentAddressDiscoveryReplyPacket.Builder();
        b.identifier(this.identifier).reserved(this.reserved).homeAgentAddresses(this.homeAgentAddresses);
        this.packet = b.build();
    }

    @Override
    public Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        Inet6Address dstAddr;
        Inet6Address srcAddr;
        try {
            srcAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:2");
            dstAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:1");
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        IcmpV6CommonPacket.Builder icmpV6b = new IcmpV6CommonPacket.Builder();
        icmpV6b.type(IcmpV6Type.HOME_AGENT_ADDRESS_DISCOVERY_REPLY).code(IcmpV6Code.NO_CODE).srcAddr(srcAddr).dstAddr(dstAddr).payloadBuilder((Packet.Builder)new SimpleBuilder((Packet)this.packet)).correctChecksumAtBuild(true);
        IpV6Packet.Builder ipv6b = new IpV6Packet.Builder();
        ipv6b.version(IpVersion.IPV6).trafficClass((IpV6Packet.IpV6TrafficClass)IpV6SimpleTrafficClass.newInstance((byte)18)).flowLabel((IpV6Packet.IpV6FlowLabel)IpV6SimpleFlowLabel.newInstance((int)74565)).nextHeader(IpNumber.ICMPV6).hopLimit((byte)100).srcAddr(srcAddr).dstAddr(dstAddr).correctLengthAtBuild(true).payloadBuilder((Packet.Builder)icmpV6b);
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.getByName((String)"fe:00:00:00:00:02")).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV6).payloadBuilder((Packet.Builder)ipv6b).paddingAtBuild(true);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + IcmpV6HomeAgentAddressDiscoveryReplyPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            IcmpV6HomeAgentAddressDiscoveryReplyPacket p = IcmpV6HomeAgentAddressDiscoveryReplyPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testGetHeader() {
        IcmpV6HomeAgentAddressDiscoveryReplyPacket.IcmpV6HomeAgentAddressDiscoveryReplyHeader h = this.packet.getHeader();
        Assert.assertEquals((long)this.identifier, (long)h.getIdentifier());
        Assert.assertEquals((long)this.reserved, (long)h.getReserved());
        Assert.assertEquals(this.homeAgentAddresses, (Object)h.getHomeAgentAddresses());
        IcmpV6HomeAgentAddressDiscoveryReplyPacket.Builder b = this.packet.getBuilder();
        b.identifier((short)0);
        IcmpV6HomeAgentAddressDiscoveryReplyPacket p = b.build();
        Assert.assertEquals((long)0L, (long)((short)p.getHeader().getIdentifierAsInt()));
        b.identifier((short)10000);
        p = b.build();
        Assert.assertEquals((long)10000L, (long)((short)p.getHeader().getIdentifierAsInt()));
        b.identifier((short)Short.MAX_VALUE);
        p = b.build();
        Assert.assertEquals((long)32767L, (long)((short)p.getHeader().getIdentifierAsInt()));
        b.identifier((short)-1);
        p = b.build();
        Assert.assertEquals((long)-1L, (long)((short)p.getHeader().getIdentifierAsInt()));
        b.identifier((short)Short.MIN_VALUE);
        p = b.build();
        Assert.assertEquals((long)-32768L, (long)((short)p.getHeader().getIdentifierAsInt()));
    }
}

