/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.test.packet;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.StringReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.core.PcapDumper;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.FragmentedPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4EndOfOptionList;
import org.pcap4j.packet.IpV4LooseSourceRouteOption;
import org.pcap4j.packet.IpV4NoOperationOption;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV4Rfc1349Tos;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UdpPacket;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.DataLinkType;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.packet.namednumber.UdpPort;
import org.pcap4j.test.packet.AbstractPacketTest;
import org.pcap4j.test.packet.RandomPacketTester;
import org.pcap4j.util.ByteArrays;
import org.pcap4j.util.IpV4Helper;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpV4PacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(IpV4PacketTest.class);
    private final IpVersion version;
    private final byte ihl;
    private final IpV4Packet.IpV4Tos tos;
    private final short totalLength;
    private final short identification;
    private final boolean reservedFlag;
    private final boolean dontFragmentFlag;
    private final boolean moreFragmentFlag;
    private final short fragmentOffset;
    private final byte ttl;
    private final IpNumber protocol;
    private final short headerChecksum;
    private final Inet4Address srcAddr;
    private final Inet4Address dstAddr;
    private final List<IpV4Packet.IpV4Option> options = new ArrayList<IpV4Packet.IpV4Option>();
    private final byte[] padding;
    private final IpV4Packet packet1;
    private final IpV4Packet packet2;

    public IpV4PacketTest() throws Exception {
        this.version = IpVersion.IPV4;
        this.ihl = (byte)9;
        this.tos = IpV4Rfc1349Tos.newInstance((byte)117);
        this.totalLength = (short)44;
        this.identification = (short)123;
        this.reservedFlag = true;
        this.dontFragmentFlag = false;
        this.moreFragmentFlag = true;
        this.fragmentOffset = 0;
        this.ttl = (byte)111;
        this.protocol = IpNumber.UDP;
        this.headerChecksum = (short)-4370;
        try {
            this.srcAddr = (Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 1});
            this.dstAddr = (Inet4Address)InetAddress.getByAddress(new byte[]{-64, 0, 2, 2});
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        ArrayList<Inet4Address> routeData = new ArrayList<Inet4Address>();
        routeData.add((Inet4Address)InetAddress.getByName("192.168.1.1"));
        routeData.add((Inet4Address)InetAddress.getByName("192.168.1.2"));
        IpV4LooseSourceRouteOption.Builder lsrrb = new IpV4LooseSourceRouteOption.Builder();
        lsrrb.pointer((byte)8).routeData(routeData).correctLengthAtBuild(true);
        this.options.add((IpV4Packet.IpV4Option)lsrrb.build());
        this.options.add((IpV4Packet.IpV4Option)IpV4NoOperationOption.getInstance());
        this.options.add((IpV4Packet.IpV4Option)IpV4NoOperationOption.getInstance());
        this.options.add((IpV4Packet.IpV4Option)IpV4NoOperationOption.getInstance());
        this.options.add((IpV4Packet.IpV4Option)IpV4EndOfOptionList.getInstance());
        this.padding = new byte[]{-86};
        UnknownPacket.Builder unknownb = new UnknownPacket.Builder();
        unknownb.rawData(new byte[]{0, 1, 2, 3, 0, 1, 2, 3});
        UdpPacket.Builder udpb = new UdpPacket.Builder();
        udpb.srcPort(UdpPort.SNMP).dstPort(UdpPort.getInstance((Short)0)).srcAddr((InetAddress)this.srcAddr).dstAddr((InetAddress)this.dstAddr).payloadBuilder((Packet.Builder)unknownb).correctChecksumAtBuild(true).correctLengthAtBuild(true);
        byte[] rawPayload = udpb.build().getRawData();
        IpV4Packet.Builder b = new IpV4Packet.Builder();
        b.version(this.version).ihl(this.ihl).tos(this.tos).totalLength(this.totalLength).identification(this.identification).reservedFlag(this.reservedFlag).dontFragmentFlag(this.dontFragmentFlag).moreFragmentFlag(this.moreFragmentFlag).fragmentOffset(this.fragmentOffset).ttl(this.ttl).protocol(this.protocol).headerChecksum(this.headerChecksum).srcAddr(this.srcAddr).dstAddr(this.dstAddr).options(this.options).padding(this.padding).correctChecksumAtBuild(false).correctLengthAtBuild(false).paddingAtBuild(false).payloadBuilder((Packet.Builder)new FragmentedPacket.Builder().rawData(ByteArrays.getSubArray((byte[])rawPayload, (int)0, (int)8)));
        this.packet1 = b.build();
        b.fragmentOffset((short)1).moreFragmentFlag(false).payloadBuilder((Packet.Builder)new FragmentedPacket.Builder().rawData(ByteArrays.getSubArray((byte[])rawPayload, (int)8, (int)8)));
        this.packet2 = b.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet1;
    }

    @Override
    protected Packet getWholePacket() {
        throw new UnsupportedOperationException();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + IpV4PacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            IpV4Packet p = IpV4Packet.newPacket((byte[])this.packet1.getRawData(), (int)0, (int)this.packet1.getRawData().length);
            Assert.assertEquals((Object)this.packet1, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testNewPacketRandom() {
        RandomPacketTester.testClass(IpV4Packet.class, (Packet)this.packet1);
    }

    @Test
    public void testGetHeader() {
        IpV4Packet.IpV4Header h = this.packet1.getHeader();
        Assert.assertEquals((Object)this.version, (Object)h.getVersion());
        Assert.assertEquals((long)this.ihl, (long)h.getIhl());
        Assert.assertEquals((Object)this.tos, (Object)h.getTos());
        Assert.assertEquals((long)this.totalLength, (long)h.getTotalLength());
        Assert.assertEquals((long)this.identification, (long)h.getIdentification());
        Assert.assertEquals((Object)this.reservedFlag, (Object)h.getReservedFlag());
        Assert.assertEquals((Object)this.dontFragmentFlag, (Object)h.getDontFragmentFlag());
        Assert.assertEquals((Object)this.moreFragmentFlag, (Object)h.getMoreFragmentFlag());
        Assert.assertEquals((long)this.fragmentOffset, (long)h.getFragmentOffset());
        Assert.assertEquals((long)this.ttl, (long)h.getTtl());
        Assert.assertEquals((Object)this.protocol, (Object)h.getProtocol());
        Assert.assertEquals((long)this.headerChecksum, (long)h.getHeaderChecksum());
        Assert.assertEquals((Object)this.srcAddr, (Object)h.getSrcAddr());
        Assert.assertEquals((Object)this.dstAddr, (Object)h.getDstAddr());
        Assert.assertEquals((long)this.options.size(), (long)h.getOptions().size());
        Iterator iter = h.getOptions().iterator();
        for (IpV4Packet.IpV4Option expected : this.options) {
            IpV4Packet.IpV4Option actual = (IpV4Packet.IpV4Option)iter.next();
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        Assert.assertArrayEquals((byte[])this.padding, (byte[])h.getPadding());
        IpV4Packet.Builder b = this.packet1.getBuilder();
        b.ihl((byte)0);
        IpV4Packet p = b.build();
        Assert.assertEquals((long)0L, (long)p.getHeader().getIhl());
        b.ihl((byte)15);
        p = b.build();
        Assert.assertEquals((long)15L, (long)p.getHeader().getIhl());
        b.ihl((byte)16);
        try {
            p = b.build();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        b.ihl((byte)-1);
        try {
            p = b.build();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        b.ihl((byte)1);
        b.fragmentOffset((short)0);
        p = b.build();
        Assert.assertEquals((long)0L, (long)p.getHeader().getFragmentOffset());
        b.fragmentOffset((short)8191);
        p = b.build();
        Assert.assertEquals((long)8191L, (long)p.getHeader().getFragmentOffset());
        b.fragmentOffset((short)8192);
        try {
            p = b.build();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        b.fragmentOffset((short)-1);
        try {
            p = b.build();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        b.fragmentOffset((short)0);
        b.totalLength((short)0);
        b.identification((short)0);
        b.ttl((byte)0);
        p = b.build();
        Assert.assertEquals((long)0L, (long)((short)p.getHeader().getTotalLengthAsInt()));
        Assert.assertEquals((long)0L, (long)((short)p.getHeader().getIdentificationAsInt()));
        Assert.assertEquals((long)0L, (long)((byte)p.getHeader().getTtlAsInt()));
        b.totalLength((short)Short.MAX_VALUE);
        b.identification((short)Short.MAX_VALUE);
        b.ttl((byte)127);
        p = b.build();
        Assert.assertEquals((long)32767L, (long)((short)p.getHeader().getTotalLengthAsInt()));
        Assert.assertEquals((long)32767L, (long)((short)p.getHeader().getIdentificationAsInt()));
        Assert.assertEquals((long)127L, (long)((byte)p.getHeader().getTtlAsInt()));
        b.totalLength((short)-1);
        b.identification((short)-1);
        b.ttl((byte)0);
        p = b.build();
        Assert.assertEquals((long)-1L, (long)((short)p.getHeader().getTotalLengthAsInt()));
        Assert.assertEquals((long)-1L, (long)((short)p.getHeader().getIdentificationAsInt()));
        Assert.assertEquals((long)0L, (long)((byte)p.getHeader().getTtlAsInt()));
        b.totalLength((short)Short.MIN_VALUE);
        b.identification((short)Short.MIN_VALUE);
        b.ttl((byte)-128);
        p = b.build();
        Assert.assertEquals((long)-32768L, (long)((short)p.getHeader().getTotalLengthAsInt()));
        Assert.assertEquals((long)-32768L, (long)((short)p.getHeader().getIdentificationAsInt()));
        Assert.assertEquals((long)-128L, (long)((byte)p.getHeader().getTtlAsInt()));
    }

    @Test
    public void testHasValidChecksum() {
        Assert.assertFalse((boolean)this.packet1.getHeader().hasValidChecksum(false));
        Assert.assertFalse((boolean)this.packet1.getHeader().hasValidChecksum(true));
        IpV4Packet.Builder b = this.packet1.getBuilder();
        b.headerChecksum((short)0).correctChecksumAtBuild(false);
        IpV4Packet p = b.build();
        Assert.assertFalse((boolean)p.getHeader().hasValidChecksum(false));
        Assert.assertTrue((boolean)p.getHeader().hasValidChecksum(true));
        b.correctChecksumAtBuild(true);
        p = b.build();
        Assert.assertTrue((boolean)p.getHeader().hasValidChecksum(false));
        Assert.assertTrue((boolean)p.getHeader().hasValidChecksum(true));
    }

    @Override
    @Test
    public void testLength() {
        Assert.assertEquals((long)this.packet1.getRawData().length, (long)this.packet1.length());
    }

    @Override
    @Test
    public void testToString() throws Exception {
        String line;
        FileReader fr = new FileReader(this.resourceDirPath + "/" + this.getClass().getSimpleName() + ".log");
        BufferedReader fbr = new BufferedReader(fr);
        StringReader sr = new StringReader(this.packet1.toString());
        BufferedReader sbr = new BufferedReader(sr);
        while ((line = sbr.readLine()) != null) {
            Assert.assertEquals((Object)fbr.readLine(), (Object)line);
        }
        sr.close();
        sbr.close();
        sr = new StringReader(this.packet2.toString());
        sbr = new BufferedReader(sr);
        while ((line = sbr.readLine()) != null) {
            Assert.assertEquals((Object)fbr.readLine(), (Object)line);
        }
        sr.close();
        sbr.close();
        ArrayList<IpV4Packet> list = new ArrayList<IpV4Packet>();
        list.add(this.packet1);
        list.add(this.packet2);
        sr = new StringReader(IpV4Helper.defragment(list).toString());
        sbr = new BufferedReader(sr);
        while ((line = sbr.readLine()) != null) {
            Assert.assertEquals((Object)fbr.readLine(), (Object)line);
        }
        Assert.assertNull((Object)sbr.readLine());
        fbr.close();
        fr.close();
        sr.close();
        sbr.close();
    }

    @Override
    @Test
    public void testDump() throws Exception {
        int size;
        String dumpFile = this.tmpDirPath + "/" + this.getClass().getSimpleName() + ".pcap";
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.getByName((String)"fe:00:00:00:00:02")).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV4).payloadBuilder((Packet.Builder)this.packet1.getBuilder().correctChecksumAtBuild(true).correctLengthAtBuild(true).paddingAtBuild(true)).paddingAtBuild(true);
        EthernetPacket ep1 = eb.build();
        EthernetPacket ep2 = eb.payloadBuilder((Packet.Builder)this.packet2.getBuilder().correctChecksumAtBuild(true).correctLengthAtBuild(true)).build();
        PcapHandle handle = Pcaps.openDead((DataLinkType)DataLinkType.EN10MB, (int)65536);
        PcapDumper dumper = handle.dumpOpen(dumpFile);
        Timestamp ts = new Timestamp(0L);
        dumper.dump((Packet)ep1, ts);
        dumper.dump((Packet)ep2, ts);
        dumper.close();
        handle.close();
        PcapHandle reader = Pcaps.openOffline((String)dumpFile);
        Assert.assertEquals((Object)ep1, (Object)reader.getNextPacket());
        Assert.assertEquals((Object)ep2, (Object)reader.getNextPacket());
        reader.close();
        FileInputStream in1 = new FileInputStream(this.resourceDirPath + "/" + this.getClass().getSimpleName() + ".pcap");
        FileInputStream in2 = new FileInputStream(dumpFile);
        byte[] buffer1 = new byte[100];
        byte[] buffer2 = new byte[100];
        while ((size = in1.read(buffer1)) != -1) {
            Assert.assertEquals((long)size, (long)in2.read(buffer2));
            Assert.assertArrayEquals((byte[])buffer1, (byte[])buffer2);
        }
        in1.close();
        in2.close();
    }
}

