/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.test.packet;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;

public class RandomPacketTester {
    private static Random r = new Random();

    public static void testClass(Class<? extends Packet> clazz, Packet original) {
        Method newPacket = null;
        try {
            newPacket = clazz.getMethod("newPacket", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (SecurityException e) {
            Assert.fail((String)e.toString());
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)e.toString());
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Task theTask = new Task(10000, newPacket, original);
        Future<String> future = executor.submit(theTask);
        String result = null;
        for (int loop = 0; loop < 2; ++loop) {
            try {
                result = future.get(30L, TimeUnit.SECONDS);
                continue;
            }
            catch (TimeoutException e) {
                if (loop == 0) {
                    theTask.shutdown();
                    continue;
                }
                executor.shutdownNow();
                Assert.fail((String)"Timed out. Possible loop?");
                continue;
            }
            catch (InterruptedException e) {
                executor.shutdownNow();
                Assert.fail((String)e.toString());
                continue;
            }
            catch (ExecutionException e) {
                executor.shutdownNow();
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof AssertionError) {
                    throw (AssertionError)((Object)e.getCause());
                }
                Assert.fail((String)e.toString());
            }
        }
        executor.shutdownNow();
        System.out.println(result);
    }

    private static void testMethod(Method newPacket, byte[] data) throws Throwable {
        try {
            newPacket.invoke(null, data, 0, data.length);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private static class Task
    implements Callable<String> {
        private Method newPacket;
        private Packet original;
        private int loopCount;
        private boolean shutdown;

        public Task(int loopCount, Method newPacket, Packet original) {
            this.loopCount = loopCount;
            this.newPacket = newPacket;
            this.original = original;
        }

        public void shutdown() {
            this.shutdown = true;
        }

        @Override
        public String call() throws Exception {
            this.shutdown = false;
            HashMap<String, Integer> failures = new HashMap<String, Integer>();
            HashMap<String, StackTracePrinter> details = new HashMap<String, StackTracePrinter>();
            for (int i = 0; i < this.loopCount && !this.shutdown; ++i) {
                byte[] data = this.original.getRawData();
                for (int j = r.nextInt(4); j >= 0; --j) {
                    int n = r.nextInt(data.length);
                    data[n] = (byte)(data[n] ^ 1 << r.nextInt(8));
                }
                if (r.nextInt(3) == 0) {
                    int len = r.nextInt(8) + 1;
                    int pos1 = r.nextInt(data.length - len);
                    int pos2 = r.nextInt(data.length - len);
                    byte[] buff = new byte[len];
                    System.arraycopy(data, pos1, buff, 0, len);
                    System.arraycopy(data, pos2, data, pos1, len);
                    System.arraycopy(buff, 0, data, pos2, len);
                }
                try {
                    RandomPacketTester.testMethod(this.newPacket, data);
                    continue;
                }
                catch (IllegalRawDataException len) {
                    continue;
                }
                catch (Throwable e) {
                    String name = e.getClass().getCanonicalName();
                    Integer count = (Integer)failures.get(name);
                    if (count == null) {
                        count = 0;
                    }
                    failures.put(name, count + 1);
                    if (details.get(name) != null) continue;
                    details.put(name, new StackTracePrinter(e, data));
                }
            }
            Assert.assertEquals((String)("Got failures: " + failures + "\n" + details), (long)0L, (long)failures.size());
            return String.format("Processed %d randomized packets", this.loopCount);
        }
    }

    private static class StackTracePrinter {
        Throwable t;
        byte[] data;

        public StackTracePrinter(Throwable t, byte[] data) {
            this.t = t;
            this.data = data;
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            for (byte b : this.data) {
                sw.append(String.format("%02X ", b));
            }
            sw.append("\n");
            this.t.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }
    }
}

