/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.test.packet;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.IpV6SimpleFlowLabel;
import org.pcap4j.packet.IpV6SimpleTrafficClass;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.SctpPacket;
import org.pcap4j.packet.TransportPacket;
import org.pcap4j.packet.UnknownSctpChunk;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.packet.namednumber.Port;
import org.pcap4j.packet.namednumber.SctpChunkType;
import org.pcap4j.packet.namednumber.SctpPort;
import org.pcap4j.test.packet.AbstractPacketTest;
import org.pcap4j.test.packet.RandomPacketTester;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SctpPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(SctpPacketTest.class);
    private final SctpPort srcPort = SctpPort.getInstance((Short)0);
    private final SctpPort dstPort = SctpPort.HTTP;
    private final int verificationTag;
    private final int checksum;
    private final List<SctpPacket.SctpChunk> chunks = new ArrayList<SctpPacket.SctpChunk>();
    private final SctpPacket packet;

    public SctpPacketTest() throws Exception {
        this.verificationTag = -86050082;
        this.checksum = -1412584499;
        this.chunks.add((SctpPacket.SctpChunk)new UnknownSctpChunk.Builder().type(SctpChunkType.SHUTDOWN).flags((byte)-81).value(new byte[]{1, 2, 3, 4}).correctLengthAtBuild(true).paddingAtBuild(true).build());
        SctpPacket.Builder b = new SctpPacket.Builder();
        b.dstPort(this.dstPort).srcPort(this.srcPort).verificationTag(this.verificationTag).checksum(this.checksum).chunks(this.chunks);
        this.packet = b.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        Inet6Address dstAddr;
        Inet6Address srcAddr;
        try {
            srcAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:1");
            dstAddr = (Inet6Address)InetAddress.getByName("2001:db8::3:2:2");
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        IpV6Packet.Builder IpV6b = new IpV6Packet.Builder();
        IpV6b.version(IpVersion.IPV6).trafficClass((IpV6Packet.IpV6TrafficClass)IpV6SimpleTrafficClass.newInstance((byte)18)).flowLabel((IpV6Packet.IpV6FlowLabel)IpV6SimpleFlowLabel.newInstance((int)74565)).nextHeader(IpNumber.SCTP).hopLimit((byte)100).srcAddr(srcAddr).dstAddr(dstAddr).payloadBuilder((Packet.Builder)this.packet.getBuilder()).correctLengthAtBuild(true);
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.getByName((String)"fe:00:00:00:00:02")).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV6).payloadBuilder((Packet.Builder)IpV6b).paddingAtBuild(true);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + SctpPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            SctpPacket p = SctpPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testNewPacketRandom() {
        RandomPacketTester.testClass(SctpPacket.class, (Packet)this.packet);
    }

    @Test
    public void testGetHeader() {
        SctpPacket.SctpHeader h = this.packet.getHeader();
        Assert.assertEquals((Object)this.srcPort, (Object)h.getSrcPort());
        Assert.assertEquals((Object)this.dstPort, (Object)h.getDstPort());
        Assert.assertEquals((long)this.verificationTag, (long)h.getVerificationTag());
        Assert.assertEquals((long)this.checksum, (long)h.getChecksum());
        Assert.assertEquals(this.chunks, (Object)h.getChunks());
    }

    @Test
    public void testHasValidChecksum() {
        SctpPacket.Builder b = this.packet.getBuilder();
        SctpPacket p = b.correctChecksumAtBuild(false).build();
        Assert.assertFalse((boolean)this.packet.hasValidChecksum());
        b.correctChecksumAtBuild(true);
        p = b.build();
        Assert.assertTrue((boolean)p.hasValidChecksum());
    }

    @Test
    public void testGetPacketWithTransportPacket() {
        Packet wholePacket = this.getWholePacket();
        TransportPacket tPacket = (TransportPacket)wholePacket.get(TransportPacket.class);
        Assert.assertNotNull((Object)tPacket);
        Assert.assertEquals((long)0L, (long)tPacket.getHeader().getDstPort().compareTo((Port)this.dstPort));
        Assert.assertEquals((long)0L, (long)tPacket.getHeader().getSrcPort().compareTo((Port)this.srcPort));
    }
}

