/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.test.packet;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.ArpPacket;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LlcControlUnnumbered;
import org.pcap4j.packet.LlcPacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.SimpleBuilder;
import org.pcap4j.packet.SnapPacket;
import org.pcap4j.packet.namednumber.ArpHardwareType;
import org.pcap4j.packet.namednumber.ArpOperation;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.LlcControlModifierFunction;
import org.pcap4j.packet.namednumber.LlcNumber;
import org.pcap4j.packet.namednumber.Oui;
import org.pcap4j.test.packet.AbstractPacketTest;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(SnapPacketTest.class);
    private final SnapPacket packet;
    private final Oui oui;
    private final EtherType protocolId;

    public SnapPacketTest() {
        ArpPacket.Builder ab = new ArpPacket.Builder();
        try {
            ab.hardwareType(ArpHardwareType.ETHERNET).protocolType(EtherType.IPV4).hardwareAddrLength((byte)6).protocolAddrLength((byte)4).srcHardwareAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).dstHardwareAddr(MacAddress.ETHER_BROADCAST_ADDRESS).srcProtocolAddr(InetAddress.getByAddress(new byte[]{-64, 0, 2, 1})).dstProtocolAddr(InetAddress.getByAddress(new byte[]{-64, 0, 2, 2})).operation(ArpOperation.REQUEST);
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        this.oui = Oui.CISCO_00000C;
        this.protocolId = EtherType.ARP;
        SnapPacket.Builder db = new SnapPacket.Builder();
        db.oui(this.oui).protocolId(this.protocolId).payloadBuilder((Packet.Builder)ab);
        this.packet = db.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        LlcPacket llc = new LlcPacket.Builder().dsap(LlcNumber.SNAP).ssap(LlcNumber.SNAP).control((LlcPacket.LlcControl)new LlcControlUnnumbered.Builder().modifierFunction(LlcControlModifierFunction.UI).pfBit(false).build()).payloadBuilder((Packet.Builder)new SimpleBuilder((Packet)this.packet)).build();
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(((ArpPacket)this.packet.getPayload()).getHeader().getDstHardwareAddr()).srcAddr(((ArpPacket)this.packet.getPayload()).getHeader().getSrcHardwareAddr()).type(EtherType.getInstance((Short)((short)llc.length()))).payloadBuilder((Packet.Builder)new SimpleBuilder((Packet)llc)).paddingAtBuild(true);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + SnapPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            SnapPacket p = SnapPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testGetHeader() {
        SnapPacket.SnapHeader h = this.packet.getHeader();
        Assert.assertEquals((Object)this.oui, (Object)h.getOui());
        Assert.assertEquals((Object)this.protocolId, (Object)h.getProtocolId());
    }
}

