/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.test.packet;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV4Rfc1349Tos;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.TcpEndOfOptionList;
import org.pcap4j.packet.TcpMaximumSegmentSizeOption;
import org.pcap4j.packet.TcpNoOperationOption;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.TcpSackOption;
import org.pcap4j.packet.TcpSackPermittedOption;
import org.pcap4j.packet.TcpTimestampsOption;
import org.pcap4j.packet.TcpWindowScaleOption;
import org.pcap4j.packet.TransportPacket;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.packet.namednumber.Port;
import org.pcap4j.packet.namednumber.TcpPort;
import org.pcap4j.test.packet.AbstractPacketTest;
import org.pcap4j.test.packet.RandomPacketTester;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpPacketTest
extends AbstractPacketTest {
    private static final Logger logger = LoggerFactory.getLogger(TcpPacketTest.class);
    private final TcpPort srcPort = TcpPort.SNMP;
    private final TcpPort dstPort = TcpPort.getInstance((Short)0);
    private final int sequenceNumber;
    private final int acknowledgmentNumber;
    private final byte dataOffset = (byte)15;
    private final byte reserved = (byte)11;
    private final boolean urg;
    private final boolean ack;
    private final boolean psh;
    private final boolean rst;
    private final boolean syn;
    private final boolean fin;
    private final short window = (short)9999;
    private final short checksum = (short)-21555;
    private final short urgentPointer = (short)1111;
    private final List<TcpPacket.TcpOption> options = new ArrayList<TcpPacket.TcpOption>();
    private final byte[] padding;
    private final Inet4Address srcAddr;
    private final Inet4Address dstAddr;
    private final TcpPacket packet;

    public TcpPacketTest() throws Exception {
        this.sequenceNumber = 1234567;
        this.acknowledgmentNumber = 7654321;
        this.urg = false;
        this.ack = true;
        this.psh = false;
        this.rst = true;
        this.syn = false;
        this.fin = true;
        this.options.add((TcpPacket.TcpOption)new TcpMaximumSegmentSizeOption.Builder().maxSegSize((short)5555).correctLengthAtBuild(true).build());
        this.options.add((TcpPacket.TcpOption)TcpNoOperationOption.getInstance());
        this.options.add((TcpPacket.TcpOption)new TcpWindowScaleOption.Builder().shiftCount((byte)2).correctLengthAtBuild(true).build());
        this.options.add((TcpPacket.TcpOption)TcpSackPermittedOption.getInstance());
        this.options.add((TcpPacket.TcpOption)new TcpTimestampsOption.Builder().tsValue(200).tsEchoReply(111).correctLengthAtBuild(true).build());
        ArrayList<TcpSackOption.Sack> sacks = new ArrayList<TcpSackOption.Sack>();
        sacks.add(new TcpSackOption.Sack(2000, 4000));
        sacks.add(new TcpSackOption.Sack(6000, 10000));
        this.options.add((TcpPacket.TcpOption)new TcpSackOption.Builder().sacks(sacks).correctLengthAtBuild(true).build());
        this.options.add((TcpPacket.TcpOption)TcpEndOfOptionList.getInstance());
        this.padding = new byte[]{-86};
        try {
            this.srcAddr = (Inet4Address)InetAddress.getByName("192.168.0.1");
            this.dstAddr = (Inet4Address)InetAddress.getByName("192.168.0.2");
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
        UnknownPacket.Builder unknownb = new UnknownPacket.Builder();
        unknownb.rawData(new byte[]{0, 1, 2, 3});
        TcpPacket.Builder b = new TcpPacket.Builder();
        b.dstPort(this.dstPort).srcPort(this.srcPort).sequenceNumber(this.sequenceNumber).acknowledgmentNumber(this.acknowledgmentNumber).dataOffset(this.dataOffset).reserved(this.reserved).urg(this.urg).ack(this.ack).psh(this.psh).rst(this.rst).syn(this.syn).fin(this.fin).window(this.window).checksum(this.checksum).urgentPointer(this.urgentPointer).options(this.options).padding(this.padding).correctChecksumAtBuild(false).correctLengthAtBuild(false).paddingAtBuild(false).payloadBuilder((Packet.Builder)unknownb);
        this.packet = b.build();
    }

    @Override
    protected Packet getPacket() {
        return this.packet;
    }

    @Override
    protected Packet getWholePacket() {
        IpV4Packet.Builder IpV4b = new IpV4Packet.Builder();
        IpV4b.version(IpVersion.IPV4).tos((IpV4Packet.IpV4Tos)IpV4Rfc1349Tos.newInstance((byte)0)).identification((short)100).ttl((byte)100).protocol(IpNumber.TCP).srcAddr(this.srcAddr).dstAddr(this.dstAddr).payloadBuilder((Packet.Builder)this.packet.getBuilder().correctChecksumAtBuild(true).correctLengthAtBuild(true).paddingAtBuild(true)).correctChecksumAtBuild(true).correctLengthAtBuild(true).paddingAtBuild(true);
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.dstAddr(MacAddress.getByName((String)"fe:00:00:00:00:02")).srcAddr(MacAddress.getByName((String)"fe:00:00:00:00:01")).type(EtherType.IPV4).payloadBuilder((Packet.Builder)IpV4b).paddingAtBuild(true);
        ((TcpPacket.Builder)eb.get(TcpPacket.Builder.class)).dstAddr((InetAddress)this.dstAddr).srcAddr((InetAddress)this.srcAddr);
        return eb.build();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        logger.info("########## " + TcpPacketTest.class.getSimpleName() + " START ##########");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testNewPacket() {
        try {
            TcpPacket p = TcpPacket.newPacket((byte[])this.packet.getRawData(), (int)0, (int)this.packet.getRawData().length);
            Assert.assertEquals((Object)this.packet, (Object)p);
        }
        catch (IllegalRawDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testNewPacketRandom() {
        RandomPacketTester.testClass(TcpPacket.class, (Packet)this.packet);
    }

    @Test
    public void testGetHeader() {
        TcpPacket.TcpHeader h = this.packet.getHeader();
        Assert.assertEquals((Object)this.srcPort, (Object)h.getSrcPort());
        Assert.assertEquals((Object)this.dstPort, (Object)h.getDstPort());
        Assert.assertEquals((long)this.sequenceNumber, (long)h.getSequenceNumber());
        Assert.assertEquals((long)this.acknowledgmentNumber, (long)h.getAcknowledgmentNumber());
        Assert.assertEquals((long)this.dataOffset, (long)h.getDataOffset());
        Assert.assertEquals((long)this.reserved, (long)h.getReserved());
        Assert.assertEquals((Object)this.urg, (Object)h.getUrg());
        Assert.assertEquals((Object)this.ack, (Object)h.getAck());
        Assert.assertEquals((Object)this.psh, (Object)h.getPsh());
        Assert.assertEquals((Object)this.rst, (Object)h.getRst());
        Assert.assertEquals((Object)this.syn, (Object)h.getSyn());
        Assert.assertEquals((Object)this.fin, (Object)h.getFin());
        Assert.assertEquals((long)this.window, (long)h.getWindow());
        Assert.assertEquals((long)this.checksum, (long)h.getChecksum());
        Assert.assertEquals((long)this.urgentPointer, (long)h.getUrgentPointer());
        Assert.assertEquals((long)this.options.size(), (long)h.getOptions().size());
        Iterator iter = h.getOptions().iterator();
        for (TcpPacket.TcpOption o : this.options) {
            TcpPacket.TcpOption actual = (TcpPacket.TcpOption)iter.next();
            Assert.assertEquals((Object)o, (Object)actual);
        }
        Assert.assertArrayEquals((byte[])this.padding, (byte[])h.getPadding());
        TcpPacket.Builder b = this.packet.getBuilder();
        b.sequenceNumber(0);
        b.acknowledgmentNumber(0);
        b.window((short)0);
        b.urgentPointer((short)0);
        TcpPacket p = b.build();
        Assert.assertEquals((long)0L, (long)((int)p.getHeader().getSequenceNumberAsLong()));
        Assert.assertEquals((long)0L, (long)((int)p.getHeader().getAcknowledgmentNumberAsLong()));
        Assert.assertEquals((long)0L, (long)((short)p.getHeader().getWindowAsInt()));
        Assert.assertEquals((long)0L, (long)((short)p.getHeader().getUrgentPointerAsInt()));
        b.sequenceNumber(-1);
        b.acknowledgmentNumber(-1);
        b.window((short)-1);
        b.urgentPointer((short)-1);
        p = b.build();
        Assert.assertEquals((long)-1L, (long)((int)p.getHeader().getSequenceNumberAsLong()));
        Assert.assertEquals((long)-1L, (long)((int)p.getHeader().getAcknowledgmentNumberAsLong()));
        Assert.assertEquals((long)-1L, (long)((short)p.getHeader().getWindowAsInt()));
        Assert.assertEquals((long)-1L, (long)((short)p.getHeader().getUrgentPointerAsInt()));
        b.sequenceNumber(Integer.MIN_VALUE);
        b.acknowledgmentNumber(Integer.MIN_VALUE);
        b.window((short)Short.MIN_VALUE);
        b.urgentPointer((short)Short.MIN_VALUE);
        p = b.build();
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)((int)p.getHeader().getSequenceNumberAsLong()));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)((int)p.getHeader().getAcknowledgmentNumberAsLong()));
        Assert.assertEquals((long)-32768L, (long)((short)p.getHeader().getWindowAsInt()));
        Assert.assertEquals((long)-32768L, (long)((short)p.getHeader().getUrgentPointerAsInt()));
        b.sequenceNumber(Integer.MAX_VALUE);
        b.acknowledgmentNumber(Integer.MAX_VALUE);
        b.window((short)Short.MAX_VALUE);
        b.urgentPointer((short)Short.MAX_VALUE);
        p = b.build();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)((int)p.getHeader().getSequenceNumberAsLong()));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)((int)p.getHeader().getAcknowledgmentNumberAsLong()));
        Assert.assertEquals((long)32767L, (long)((short)p.getHeader().getWindowAsInt()));
        Assert.assertEquals((long)32767L, (long)((short)p.getHeader().getUrgentPointerAsInt()));
        b.dataOffset((byte)0);
        p = b.build();
        Assert.assertEquals((long)0L, (long)p.getHeader().getDataOffset());
        b.dataOffset((byte)15);
        p = b.build();
        Assert.assertEquals((long)15L, (long)p.getHeader().getDataOffset());
        b.dataOffset((byte)16);
        try {
            p = b.build();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        b.dataOffset((byte)-1);
        try {
            p = b.build();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        b.dataOffset((byte)0);
        b.reserved((byte)0);
        p = b.build();
        Assert.assertEquals((long)0L, (long)p.getHeader().getReserved());
        b.reserved((byte)63);
        p = b.build();
        Assert.assertEquals((long)63L, (long)p.getHeader().getReserved());
        b.reserved((byte)64);
        try {
            p = b.build();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        b.reserved((byte)-1);
        try {
            p = b.build();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        b.reserved((byte)0);
    }

    @Test
    public void testHasValidChecksum() {
        TcpPacket.Builder b = this.packet.getBuilder();
        b.srcAddr((InetAddress)this.srcAddr).dstAddr((InetAddress)this.dstAddr);
        TcpPacket p = b.correctChecksumAtBuild(false).build();
        Assert.assertFalse((boolean)this.packet.hasValidChecksum((InetAddress)this.srcAddr, (InetAddress)this.dstAddr, false));
        Assert.assertFalse((boolean)this.packet.hasValidChecksum((InetAddress)this.srcAddr, (InetAddress)this.dstAddr, true));
        b.checksum((short)0).correctChecksumAtBuild(false);
        p = b.build();
        Assert.assertFalse((boolean)p.hasValidChecksum((InetAddress)this.srcAddr, (InetAddress)this.dstAddr, false));
        Assert.assertTrue((boolean)p.hasValidChecksum((InetAddress)this.srcAddr, (InetAddress)this.dstAddr, true));
        b.correctChecksumAtBuild(true);
        p = b.build();
        Assert.assertTrue((boolean)p.hasValidChecksum((InetAddress)this.srcAddr, (InetAddress)this.dstAddr, false));
        Assert.assertTrue((boolean)p.hasValidChecksum((InetAddress)this.srcAddr, (InetAddress)this.dstAddr, true));
    }

    @Test
    public void testGetPacketWithTransportPacket() {
        Packet wholePacket = this.getWholePacket();
        TransportPacket tPacket = (TransportPacket)wholePacket.get(TransportPacket.class);
        Assert.assertNotNull((Object)tPacket);
        Assert.assertEquals((long)0L, (long)tPacket.getHeader().getDstPort().compareTo((Port)this.dstPort));
        Assert.assertEquals((long)0L, (long)tPacket.getHeader().getSrcPort().compareTo((Port)this.srcPort));
    }
}

