/*
 * Decompiled with CFR 0.152.
 */
package org.pcre4j.jna;

import com.sun.jna.FunctionMapper;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.pcre4j.api.IPcre2;

public class Pcre2
implements IPcre2 {
    private final Library library;

    public Pcre2() {
        this(System.getProperty("pcre2.library.name", "pcre2-8"), System.getProperty("pcre2.function.suffix", "_8"));
    }

    public Pcre2(String library, String suffix) {
        if (library == null) {
            throw new IllegalArgumentException("library must not be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("suffix must not be null");
        }
        this.library = (Library)Native.load((String)library, Library.class, Map.of("function-mapper", new SuffixFunctionMapper(suffix)));
    }

    public int config(int what) {
        return this.library.pcre2_config(what, Pointer.NULL);
    }

    public int config(int what, int[] where) {
        if (where == null) {
            throw new IllegalArgumentException("where must not be null");
        }
        if (where.length != 1) {
            throw new IllegalArgumentException("where must be an array of length 1");
        }
        IntByReference whereRef = new IntByReference();
        int result = this.library.pcre2_config(what, whereRef.getPointer());
        where[0] = whereRef.getValue();
        return result;
    }

    public int config(int what, ByteBuffer where) {
        if (where == null) {
            throw new IllegalArgumentException("where must not be null");
        }
        if (!where.isDirect()) {
            throw new IllegalArgumentException("where must be a direct buffer");
        }
        Pointer pWhere = Native.getDirectBufferPointer((Buffer)where);
        return this.library.pcre2_config(what, pWhere);
    }

    public long generalContextCreate(long privateMalloc, long privateFree, long memoryData) {
        Pointer pPrivateMalloc = new Pointer(privateMalloc);
        Pointer pPrivateFree = new Pointer(privateFree);
        Pointer pMemoryData = new Pointer(memoryData);
        Pointer pGContext = this.library.pcre2_general_context_create(pPrivateMalloc, pPrivateFree, pMemoryData);
        return Pointer.nativeValue((Pointer)pGContext);
    }

    public long generalContextCopy(long gcontext) {
        Pointer pGContext = new Pointer(gcontext);
        Pointer pNewGContext = this.library.pcre2_general_context_copy(pGContext);
        return Pointer.nativeValue((Pointer)pNewGContext);
    }

    public void generalContextFree(long gcontext) {
        Pointer pGContext = new Pointer(gcontext);
        this.library.pcre2_general_context_free(pGContext);
    }

    public long compileContextCreate(long gcontext) {
        Pointer pGContext = new Pointer(gcontext);
        Pointer pCContext = this.library.pcre2_compile_context_create(pGContext);
        return Pointer.nativeValue((Pointer)pCContext);
    }

    public long compileContextCopy(long ccontext) {
        Pointer pCContext = new Pointer(ccontext);
        Pointer pNewCContext = this.library.pcre2_compile_context_copy(pCContext);
        return Pointer.nativeValue((Pointer)pNewCContext);
    }

    public void compileContextFree(long ccontext) {
        Pointer pCContext = new Pointer(ccontext);
        this.library.pcre2_compile_context_free(pCContext);
    }

    public long compile(String pattern, int options, int[] errorcode, long[] erroroffset, long ccontext) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern must not be null");
        }
        if (errorcode == null || errorcode.length < 1) {
            throw new IllegalArgumentException("errorcode must be an array of length 1");
        }
        if (erroroffset == null || erroroffset.length < 1) {
            throw new IllegalArgumentException("erroroffset must be an array of length 1");
        }
        byte[] pszPattern = pattern.getBytes(StandardCharsets.UTF_8);
        Pointer patternSize = new Pointer((long)pszPattern.length);
        IntByReference errorCodeRef = new IntByReference();
        LongByReference errorOffsetRef = new LongByReference();
        Pointer pCContext = new Pointer(ccontext);
        Pointer pCode = this.library.pcre2_compile(pszPattern, patternSize, options, errorCodeRef, errorOffsetRef, pCContext);
        errorcode[0] = errorCodeRef.getValue();
        erroroffset[0] = errorOffsetRef.getValue();
        return Pointer.nativeValue((Pointer)pCode);
    }

    public void codeFree(long code) {
        Pointer pCode = new Pointer(code);
        this.library.pcre2_code_free(pCode);
    }

    public int getErrorMessage(int errorcode, ByteBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer must not be null");
        }
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("buffer must be direct");
        }
        Pointer pszBuffer = Native.getDirectBufferPointer((Buffer)buffer);
        Pointer bufferSize = new Pointer((long)buffer.capacity());
        return this.library.pcre2_get_error_message(errorcode, pszBuffer, bufferSize);
    }

    public int patternInfo(long code, int what) {
        Pointer pCode = new Pointer(code);
        return this.library.pcre2_pattern_info(pCode, what, Pointer.NULL);
    }

    public int patternInfo(long code, int what, int[] where) {
        if (where == null) {
            throw new IllegalArgumentException("where must not be null");
        }
        if (where.length != 1) {
            throw new IllegalArgumentException("where must be an array of length 1");
        }
        Pointer pCode = new Pointer(code);
        IntByReference whereRef = new IntByReference();
        int result = this.library.pcre2_pattern_info(pCode, what, whereRef.getPointer());
        where[0] = whereRef.getValue();
        return result;
    }

    public int patternInfo(long code, int what, long[] where) {
        if (where == null) {
            throw new IllegalArgumentException("where must not be null");
        }
        if (where.length != 1) {
            throw new IllegalArgumentException("where must be an array of length 1");
        }
        Pointer pCode = new Pointer(code);
        LongByReference whereRef = new LongByReference();
        int result = this.library.pcre2_pattern_info(pCode, what, whereRef.getPointer());
        where[0] = whereRef.getValue();
        return result;
    }

    public int patternInfo(long code, int what, ByteBuffer where) {
        if (where == null) {
            throw new IllegalArgumentException("where must not be null");
        }
        Pointer pCode = new Pointer(code);
        PointerByReference whereRef = new PointerByReference();
        int result = this.library.pcre2_pattern_info(pCode, what, whereRef.getPointer());
        where.put(whereRef.getValue().getByteArray(0L, where.capacity()));
        return result;
    }

    public int jitCompile(long code, int options) {
        Pointer pCode = new Pointer(code);
        return this.library.pcre2_jit_compile(pCode, options);
    }

    public int jitMatch(long code, String subject, int startoffset, int options, long matchData, long mcontext) {
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        Pointer pCode = new Pointer(code);
        byte[] pszSubject = subject.getBytes(StandardCharsets.UTF_8);
        Pointer subjectLength = new Pointer((long)pszSubject.length);
        Pointer startOffset = new Pointer((long)startoffset);
        Pointer pMatchData = new Pointer(matchData);
        Pointer pMContext = new Pointer(mcontext);
        return this.library.pcre2_jit_match(pCode, pszSubject, subjectLength, startOffset, options, pMatchData, pMContext);
    }

    public long jitStackCreate(long startsize, long maxsize, long gcontext) {
        Pointer startSize = new Pointer(startsize);
        Pointer maxSize = new Pointer(maxsize);
        Pointer pGContext = new Pointer(gcontext);
        Pointer jitStack = this.library.pcre2_jit_stack_create(startSize, maxSize, pGContext);
        return Pointer.nativeValue((Pointer)jitStack);
    }

    public void jitStackFree(long stack) {
        Pointer pStack = new Pointer(stack);
        this.library.pcre2_jit_stack_free(pStack);
    }

    public void jitStackAssign(long mcontext, long callback, long data) {
        Pointer pMContext = new Pointer(mcontext);
        Pointer pCallback = new Pointer(callback);
        Pointer pData = new Pointer(data);
        this.library.pcre2_jit_stack_assign(pMContext, pCallback, pData);
    }

    public long matchDataCreate(int ovecsize, long gcontext) {
        Pointer pGContext = new Pointer(gcontext);
        Pointer pMatchData = this.library.pcre2_match_data_create(ovecsize, pGContext);
        return Pointer.nativeValue((Pointer)pMatchData);
    }

    public long matchDataCreateFromPattern(long code, long gcontext) {
        Pointer pCode = new Pointer(code);
        Pointer pGContext = new Pointer(gcontext);
        Pointer pMatchData = this.library.pcre2_match_data_create_from_pattern(pCode, pGContext);
        return Pointer.nativeValue((Pointer)pMatchData);
    }

    public void matchDataFree(long matchData) {
        Pointer pMatchData = new Pointer(matchData);
        this.library.pcre2_match_data_free(pMatchData);
    }

    public long matchContextCreate(long gcontext) {
        Pointer pGContext = new Pointer(gcontext);
        Pointer pMatchContext = this.library.pcre2_match_context_create(pGContext);
        return Pointer.nativeValue((Pointer)pMatchContext);
    }

    public long matchContextCopy(long mcontext) {
        Pointer pMContext = new Pointer(mcontext);
        Pointer pNewMatchContext = this.library.pcre2_match_context_copy(pMContext);
        return Pointer.nativeValue((Pointer)pNewMatchContext);
    }

    public void matchContextFree(long mcontext) {
        Pointer pMContext = new Pointer(mcontext);
        this.library.pcre2_match_context_free(pMContext);
    }

    public int match(long code, String subject, int startoffset, int options, long matchData, long mcontext) {
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        Pointer pCode = new Pointer(code);
        byte[] pszSubject = subject.getBytes(StandardCharsets.UTF_8);
        Pointer subjectLength = new Pointer((long)pszSubject.length);
        Pointer startOffset = new Pointer((long)startoffset);
        Pointer pMatchData = new Pointer(matchData);
        Pointer pMContext = new Pointer(mcontext);
        return this.library.pcre2_match(pCode, pszSubject, subjectLength, startOffset, options, pMatchData, pMContext);
    }

    public int getOvectorCount(long matchData) {
        Pointer pMatchData = new Pointer(matchData);
        return this.library.pcre2_get_ovector_count(pMatchData);
    }

    public void getOvector(long matchData, long[] ovector) {
        if (ovector == null) {
            throw new IllegalArgumentException("ovector must not be null");
        }
        Pointer pMatchData = new Pointer(matchData);
        Pointer pOvector = this.library.pcre2_get_ovector_pointer(pMatchData);
        pOvector.read(0L, ovector, 0, ovector.length);
    }

    public int setNewline(long ccontext, int value) {
        Pointer pCContext = new Pointer(ccontext);
        return this.library.pcre2_set_newline(pCContext, value);
    }

    private static interface Library
    extends com.sun.jna.Library {
        public int pcre2_config(int var1, Pointer var2);

        public Pointer pcre2_general_context_create(Pointer var1, Pointer var2, Pointer var3);

        public Pointer pcre2_general_context_copy(Pointer var1);

        public void pcre2_general_context_free(Pointer var1);

        public Pointer pcre2_compile_context_create(Pointer var1);

        public Pointer pcre2_compile_context_copy(Pointer var1);

        public void pcre2_compile_context_free(Pointer var1);

        public Pointer pcre2_compile(byte[] var1, Pointer var2, int var3, IntByReference var4, LongByReference var5, Pointer var6);

        public void pcre2_code_free(Pointer var1);

        public int pcre2_get_error_message(int var1, Pointer var2, Pointer var3);

        public int pcre2_pattern_info(Pointer var1, int var2, Pointer var3);

        public int pcre2_jit_compile(Pointer var1, int var2);

        public int pcre2_jit_match(Pointer var1, byte[] var2, Pointer var3, Pointer var4, int var5, Pointer var6, Pointer var7);

        public Pointer pcre2_jit_stack_create(Pointer var1, Pointer var2, Pointer var3);

        public void pcre2_jit_stack_free(Pointer var1);

        public void pcre2_jit_stack_assign(Pointer var1, Pointer var2, Pointer var3);

        public Pointer pcre2_match_data_create(int var1, Pointer var2);

        public Pointer pcre2_match_data_create_from_pattern(Pointer var1, Pointer var2);

        public void pcre2_match_data_free(Pointer var1);

        public Pointer pcre2_match_context_create(Pointer var1);

        public Pointer pcre2_match_context_copy(Pointer var1);

        public void pcre2_match_context_free(Pointer var1);

        public int pcre2_match(Pointer var1, byte[] var2, Pointer var3, Pointer var4, int var5, Pointer var6, Pointer var7);

        public int pcre2_get_ovector_count(Pointer var1);

        public Pointer pcre2_get_ovector_pointer(Pointer var1);

        public int pcre2_set_newline(Pointer var1, int var2);
    }

    private record SuffixFunctionMapper(String suffix) implements FunctionMapper
    {
        public String getFunctionName(NativeLibrary nativeLibrary, Method method) {
            return method.getName() + this.suffix;
        }
    }
}

