/*
 * Decompiled with CFR 0.152.
 */
package org.pcre4j;

import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.EnumSet;
import org.pcre4j.Pcre2Bsr;
import org.pcre4j.Pcre2CompileContext;
import org.pcre4j.Pcre2CompileError;
import org.pcre4j.Pcre2CompileOption;
import org.pcre4j.Pcre2MatchContext;
import org.pcre4j.Pcre2MatchData;
import org.pcre4j.Pcre2MatchOption;
import org.pcre4j.Pcre2Newline;
import org.pcre4j.Pcre2PatternInfo;
import org.pcre4j.Pcre2PatternInfoSizeError;
import org.pcre4j.Pcre4j;
import org.pcre4j.Pcre4jUtils;
import org.pcre4j.api.IPcre2;

public class Pcre2Code {
    private static final Cleaner cleaner = Cleaner.create();
    final long handle;
    final IPcre2 api;
    private final Cleaner.Cleanable cleanable;

    public Pcre2Code(String pattern) {
        this(pattern, null, null);
    }

    public Pcre2Code(String pattern, EnumSet<Pcre2CompileOption> options) {
        this(pattern, options, null);
    }

    public Pcre2Code(String pattern, EnumSet<Pcre2CompileOption> options, Pcre2CompileContext compileContext) {
        this(Pcre4j.api(), pattern, options, compileContext);
    }

    public Pcre2Code(IPcre2 api, String pattern) {
        this(api, pattern, null, null);
    }

    public Pcre2Code(IPcre2 api, String pattern, EnumSet<Pcre2CompileOption> options) {
        this(api, pattern, options, null);
    }

    public Pcre2Code(IPcre2 api, String pattern, EnumSet<Pcre2CompileOption> options, Pcre2CompileContext compileContext) {
        if (api == null) {
            throw new IllegalArgumentException("api cannot be null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("pattern cannot be null");
        }
        if (options == null) {
            options = EnumSet.noneOf(Pcre2CompileOption.class);
        }
        int[] errorcode = new int[1];
        long[] erroroffset = new long[1];
        long handle = api.compile(pattern, options.stream().mapToInt(Pcre2CompileOption::value).sum(), errorcode, erroroffset, compileContext != null ? compileContext.handle : 0L);
        if (handle == 0L) {
            throw new Pcre2CompileError(pattern, erroroffset[0], Pcre4jUtils.getErrorMessage(api, errorcode[0]));
        }
        this.api = api;
        this.handle = handle;
        this.cleanable = cleaner.register(this, new Clean(api, handle));
    }

    private int getPatternIntInfo(int info) {
        int size = this.api.patternInfo(this.handle, info);
        if (size != 4) {
            throw new Pcre2PatternInfoSizeError(Pcre2PatternInfo.valueOf(info).orElseThrow(), size);
        }
        int[] where = new int[1];
        int error = this.api.patternInfo(this.handle, info, where);
        if (error != 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(this.api, error));
        }
        return where[0];
    }

    private long getPatternSizeInfo(int info) {
        int infoSize = this.api.patternInfo(this.handle, 24);
        if (infoSize == 4) {
            int[] where = new int[1];
            int error = this.api.patternInfo(this.handle, 24, where);
            if (error != 0) {
                throw new IllegalStateException(Pcre4jUtils.getErrorMessage(this.api, error));
            }
            return where[0];
        }
        if (infoSize == 8) {
            long[] where = new long[1];
            int error = this.api.patternInfo(this.handle, 24, where);
            if (error != 0) {
                throw new IllegalStateException(Pcre4jUtils.getErrorMessage(this.api, error));
            }
            return where[0];
        }
        throw new Pcre2PatternInfoSizeError(Pcre2PatternInfo.valueOf(24).orElseThrow(), infoSize);
    }

    public IPcre2 api() {
        return this.api;
    }

    public long handle() {
        return this.handle;
    }

    public int backRefMax() {
        return this.getPatternIntInfo(2);
    }

    public EnumSet<Pcre2CompileOption> argOptions() {
        int argOptions = this.getPatternIntInfo(1);
        return Arrays.stream(Pcre2CompileOption.values()).filter(flag -> (argOptions & flag.value()) != 0).collect(() -> EnumSet.noneOf(Pcre2CompileOption.class), AbstractCollection::add, AbstractCollection::addAll);
    }

    public int captureCount() {
        return this.getPatternIntInfo(4);
    }

    public Pcre2Bsr bsr() {
        int bsr = this.getPatternIntInfo(3);
        return Pcre2Bsr.valueOf(bsr).orElseThrow();
    }

    public int depthLimit() {
        int depthLimit = this.getPatternIntInfo(21);
        if (depthLimit == -55) {
            throw new IllegalStateException("Depth limit is not set");
        }
        return depthLimit;
    }

    public long frameSize() {
        return this.getPatternSizeInfo(24);
    }

    public boolean hasBackslashC() {
        int hasBackslashC = this.getPatternIntInfo(23);
        return hasBackslashC == 1;
    }

    public boolean hasCrOrLf() {
        int hasCrOrLf = this.getPatternIntInfo(8);
        return hasCrOrLf == 1;
    }

    public int heapLimit() {
        int heapLimit = this.getPatternIntInfo(25);
        if (heapLimit == -55) {
            throw new IllegalStateException("Heap limit is not set");
        }
        return heapLimit;
    }

    public boolean jChanged() {
        int jChanged = this.getPatternIntInfo(9);
        return jChanged == 1;
    }

    public long jitSize() {
        return this.getPatternSizeInfo(10);
    }

    public boolean matchEmpty() {
        int matchEmpty = this.getPatternIntInfo(13);
        return matchEmpty == 1;
    }

    public int matchLimit() {
        int matchLimit = this.getPatternIntInfo(21);
        if (matchLimit == -55) {
            throw new IllegalStateException("Match limit is not set");
        }
        return matchLimit;
    }

    public int maxLookBehind() {
        return this.getPatternIntInfo(15);
    }

    public int minLength() {
        return this.getPatternIntInfo(16);
    }

    public int nameCount() {
        return this.getPatternIntInfo(17);
    }

    public Pcre2Newline newline() {
        int newline = this.getPatternIntInfo(20);
        return Pcre2Newline.valueOf(newline).orElseThrow();
    }

    public int nameEntrySize() {
        return this.getPatternIntInfo(18);
    }

    public NameTableEntry[] nameTable() {
        int nameEntrySize;
        int nameCount = this.nameCount();
        ByteBuffer where = ByteBuffer.allocate(nameCount * (nameEntrySize = this.nameEntrySize()));
        int error = this.api.patternInfo(this.handle, 19, where);
        if (error != 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(this.api, error));
        }
        NameTableEntry[] nameTable = new NameTableEntry[nameCount];
        for (int nameIndex = 0; nameIndex < nameCount; ++nameIndex) {
            int offset = nameIndex * nameEntrySize;
            short groupIndex = where.slice(offset, 2).getShort();
            ByteBuffer groupNameUtf8 = where.slice(offset + 2, nameEntrySize - 2);
            while (groupNameUtf8.remaining() > 0) {
                if (groupNameUtf8.get() != 0) continue;
                groupNameUtf8.limit(groupNameUtf8.position() - 1);
                groupNameUtf8.position(0);
                break;
            }
            String groupName = StandardCharsets.UTF_8.decode(groupNameUtf8).toString();
            nameTable[nameIndex] = new NameTableEntry(groupIndex, groupName);
        }
        return nameTable;
    }

    public long size() {
        return this.getPatternSizeInfo(22);
    }

    public int match(String subject, int startOffset, EnumSet<Pcre2MatchOption> options, Pcre2MatchData matchData, Pcre2MatchContext matchContext) {
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (startOffset < 0) {
            throw new IllegalArgumentException("startOffset must be greater than or equal to zero");
        }
        if (startOffset >= subject.length()) {
            throw new IllegalArgumentException("startOffset must be less than the length of the subject");
        }
        if (matchData == null) {
            throw new IllegalArgumentException("matchData must not be null");
        }
        return this.api.match(this.handle, subject, Pcre4jUtils.convertCharacterIndexToByteOffset(subject, startOffset), options.stream().mapToInt(Pcre2MatchOption::value).sum(), matchData.handle, matchContext != null ? matchContext.handle : 0L);
    }

    private record Clean(IPcre2 api, long code) implements Runnable
    {
        @Override
        public void run() {
            this.api.codeFree(this.code);
        }
    }

    public record NameTableEntry(int group, String name) {
    }
}

