/*
 * Decompiled with CFR 0.152.
 */
package org.pcre4j;

import java.lang.ref.Cleaner;
import org.pcre4j.Pcre2GeneralContext;
import org.pcre4j.Pcre2Newline;
import org.pcre4j.Pcre4j;
import org.pcre4j.Pcre4jUtils;
import org.pcre4j.api.IPcre2;

public class Pcre2CompileContext {
    private static final Cleaner cleaner = Cleaner.create();
    final long handle;
    final IPcre2 api;
    private final Cleaner.Cleanable cleanable;

    public Pcre2CompileContext(Pcre2GeneralContext generalContext) {
        this(Pcre4j.api(), generalContext);
    }

    public Pcre2CompileContext(IPcre2 api, Pcre2GeneralContext generalContext) {
        if (api == null) {
            throw new IllegalArgumentException("api cannot be null");
        }
        long handle = api.compileContextCreate(generalContext != null ? generalContext.handle : 0L);
        if (handle == 0L) {
            throw new IllegalStateException("Failed to create compile context");
        }
        this.api = api;
        this.handle = handle;
        this.cleanable = cleaner.register(this, new Clean(api, handle));
    }

    public IPcre2 api() {
        return this.api;
    }

    public long handle() {
        return this.handle;
    }

    public void setNewline(Pcre2Newline newline) {
        if (newline == null) {
            throw new IllegalArgumentException("newline cannot be null");
        }
        int result = this.api.setNewline(this.handle, newline.value());
        if (result != 0) {
            String errorMessage = Pcre4jUtils.getErrorMessage(this.api, result);
            throw new RuntimeException("Failed set the newline convention", new IllegalStateException(errorMessage));
        }
    }

    private record Clean(IPcre2 api, long compileContext) implements Runnable
    {
        @Override
        public void run() {
            this.api.compileContextFree(this.compileContext);
        }
    }
}

