/*
 * Decompiled with CFR 0.152.
 */
package org.pcre4j;

public class Pcre2CompileError
extends IllegalArgumentException {
    private static final int PATTERN_REGION_SIZE = 3;
    private final String pattern;
    private final long offset;
    private final String message;

    public Pcre2CompileError(String pattern, long offset, String message) {
        this(pattern, offset, message, null);
    }

    public Pcre2CompileError(String pattern, long offset, String message, Throwable cause) {
        super("Error in pattern at %d \"%s\": %s".formatted(offset, Pcre2CompileError.getPatternRegion(pattern, offset), message), cause);
        this.pattern = pattern;
        this.offset = offset;
        this.message = message;
    }

    private static String getPatternRegion(String pattern, long offset) {
        long since = Math.max(0L, offset - 3L);
        long until = Math.min((long)pattern.length(), offset + 3L);
        Object region = pattern.substring((int)since, (int)until);
        if (since > 0L) {
            region = "\u2026" + (String)region;
        }
        if (until < (long)pattern.length()) {
            region = (String)region + "\u2026";
        }
        return region;
    }

    public String pattern() {
        return this.pattern;
    }

    public long offset() {
        return this.offset;
    }

    public String message() {
        return this.message;
    }
}

