/*
 * Decompiled with CFR 0.152.
 */
package org.pcre4j;

import java.util.EnumSet;
import org.pcre4j.Pcre2Code;
import org.pcre4j.Pcre2CompileContext;
import org.pcre4j.Pcre2CompileOption;
import org.pcre4j.Pcre2JitOption;
import org.pcre4j.Pcre2MatchContext;
import org.pcre4j.Pcre2MatchData;
import org.pcre4j.Pcre2MatchOption;
import org.pcre4j.Pcre4j;
import org.pcre4j.Pcre4jUtils;
import org.pcre4j.api.IPcre2;

public class Pcre2JitCode
extends Pcre2Code {
    private static final EnumSet<Pcre2MatchOption> SUPPORTED_MATCH_OPTIONS = EnumSet.of(Pcre2MatchOption.NOTBOL, new Pcre2MatchOption[]{Pcre2MatchOption.NOTEOL, Pcre2MatchOption.NOTEMPTY, Pcre2MatchOption.NOTEMPTY_ATSTART, Pcre2MatchOption.PARTIAL_HARD, Pcre2MatchOption.PARTIAL_SOFT});

    public Pcre2JitCode(String pattern, EnumSet<Pcre2CompileOption> options, EnumSet<Pcre2JitOption> jitOptions, Pcre2CompileContext compileContext) {
        this(Pcre4j.api(), pattern, options, jitOptions, compileContext);
    }

    public Pcre2JitCode(IPcre2 api, String pattern, EnumSet<Pcre2CompileOption> options, EnumSet<Pcre2JitOption> jitOptions, Pcre2CompileContext compileContext) {
        super(api, pattern, options, compileContext);
        int jitResult;
        if (jitOptions == null) {
            jitOptions = EnumSet.of(Pcre2JitOption.COMPLETE, Pcre2JitOption.PARTIAL_SOFT, Pcre2JitOption.PARTIAL_HARD);
        }
        if ((jitResult = api.jitCompile(this.handle, jitOptions.stream().mapToInt(Pcre2JitOption::value).sum())) != 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(api, jitResult));
        }
    }

    public static EnumSet<Pcre2MatchOption> getSupportedMatchOptions() {
        return EnumSet.copyOf(SUPPORTED_MATCH_OPTIONS);
    }

    @Override
    public int match(String subject, int startOffset, EnumSet<Pcre2MatchOption> options, Pcre2MatchData matchData, Pcre2MatchContext matchContext) {
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (startOffset < 0) {
            throw new IllegalArgumentException("startOffset must be greater than or equal to zero");
        }
        if (startOffset >= subject.length()) {
            throw new IllegalArgumentException("startOffset must be less than the length of the subject");
        }
        if (matchData == null) {
            throw new IllegalArgumentException("matchData must not be null");
        }
        return this.api.jitMatch(this.handle, subject, Pcre4jUtils.convertCharacterIndexToByteOffset(subject, startOffset), options.stream().mapToInt(Pcre2MatchOption::value).sum(), matchData.handle, matchContext != null ? matchContext.handle : 0L);
    }
}

