/*
 * Decompiled with CFR 0.152.
 */
package org.pcre4j;

import java.lang.ref.Cleaner;
import org.pcre4j.Pcre2Code;
import org.pcre4j.Pcre4j;
import org.pcre4j.api.IPcre2;

public class Pcre2MatchData {
    private static final Cleaner cleaner = Cleaner.create();
    final long handle;
    final IPcre2 api;
    private final Cleaner.Cleanable cleanable;

    public Pcre2MatchData(int ovecsize) {
        this(Pcre4j.api(), ovecsize);
    }

    public Pcre2MatchData(IPcre2 api, int ovecsize) {
        if (api == null) {
            throw new IllegalArgumentException("api cannot be null");
        }
        long handle = api.matchDataCreate(ovecsize, 0L);
        if (handle == 0L) {
            throw new IllegalStateException("Failed to create match data");
        }
        this.api = api;
        this.handle = handle;
        this.cleanable = cleaner.register(this, new Clean(api, handle));
    }

    public Pcre2MatchData(Pcre2Code code) {
        if (code == null) {
            throw new IllegalArgumentException("code cannot be null");
        }
        long handle = code.api.matchDataCreateFromPattern(code.handle, 0L);
        if (handle == 0L) {
            throw new IllegalStateException("Failed to create match data from pattern");
        }
        this.api = code.api;
        this.handle = handle;
        this.cleanable = cleaner.register(this, new Clean(this.api, handle));
    }

    public IPcre2 api() {
        return this.api;
    }

    public long handle() {
        return this.handle;
    }

    public int ovectorCount() {
        return this.api.getOvectorCount(this.handle);
    }

    public long[] ovector() {
        long[] ovector = new long[this.api.getOvectorCount(this.handle) * 2];
        this.api.getOvector(this.handle, ovector);
        return ovector;
    }

    private record Clean(IPcre2 api, long matchData) implements Runnable
    {
        @Override
        public void run() {
            this.api.matchDataFree(this.matchData);
        }
    }
}

