/*
 * Decompiled with CFR 0.152.
 */
package org.pcre4j;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalLong;
import org.pcre4j.Pcre2Bsr;
import org.pcre4j.Pcre2Code;
import org.pcre4j.Pcre2MatchData;
import org.pcre4j.Pcre2Newline;
import org.pcre4j.Pcre2UtfWidth;
import org.pcre4j.api.IPcre2;

public final class Pcre4jUtils {
    private Pcre4jUtils() {
    }

    public static String getVersion(IPcre2 api) {
        if (api == null) {
            throw new IllegalArgumentException("api must not be null");
        }
        int versionSize = api.config(11);
        if (versionSize < 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(api, versionSize));
        }
        ByteBuffer versionBuffer = ByteBuffer.allocateDirect(versionSize);
        int versionCopyResult = api.config(11, versionBuffer);
        if (versionCopyResult < 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(api, versionCopyResult));
        }
        return StandardCharsets.UTF_8.decode(versionBuffer.limit(versionSize - 1)).toString();
    }

    public static String getUnicodeVersion(IPcre2 api) {
        if (api == null) {
            throw new IllegalArgumentException("api must not be null");
        }
        int versionSize = api.config(10);
        if (versionSize < 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(api, versionSize));
        }
        ByteBuffer versionBuffer = ByteBuffer.allocateDirect(versionSize);
        int versionCopyResult = api.config(10, versionBuffer);
        if (versionCopyResult < 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(api, versionCopyResult));
        }
        return StandardCharsets.UTF_8.decode(versionBuffer.limit(versionSize - 1)).toString();
    }

    public static boolean isUnicodeSupported(IPcre2 api) {
        if (api == null) {
            throw new IllegalArgumentException("api must not be null");
        }
        int[] unicodeSupported = new int[1];
        int result = api.config(9, unicodeSupported);
        if (result < 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(api, result));
        }
        return unicodeSupported[0] == 1;
    }

    public static int getDefaultParenthesesNestingLimit(IPcre2 api) {
        if (api == null) {
            throw new IllegalArgumentException("api must not be null");
        }
        int[] parensLimit = new int[1];
        int result = api.config(6, parensLimit);
        if (result < 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(api, result));
        }
        return parensLimit[0];
    }

    public static Pcre2Newline getDefaultNewline(IPcre2 api) {
        if (api == null) {
            throw new IllegalArgumentException("api must not be null");
        }
        int[] newline = new int[1];
        int result = api.config(5, newline);
        if (result < 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(api, result));
        }
        return Pcre2Newline.valueOf(newline[0]).orElseThrow();
    }

    public static boolean isBackslashCDisabled(IPcre2 api) {
        if (api == null) {
            throw new IllegalArgumentException("api must not be null");
        }
        int[] backslashCDisabled = new int[1];
        int result = api.config(0, backslashCDisabled);
        if (result < 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(api, result));
        }
        return backslashCDisabled[0] == 1;
    }

    public static int getDefaultMatchLimit(IPcre2 api) {
        if (api == null) {
            throw new IllegalArgumentException("api must not be null");
        }
        int[] matchLimit = new int[1];
        int result = api.config(4, matchLimit);
        if (result < 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(api, result));
        }
        return matchLimit[0];
    }

    public static int getInternalLinkSize(IPcre2 api) {
        if (api == null) {
            throw new IllegalArgumentException("api must not be null");
        }
        int[] internalLinkSize = new int[1];
        int result = api.config(3, internalLinkSize);
        if (result < 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(api, result));
        }
        return internalLinkSize[0];
    }

    public static String getJitTarget(IPcre2 api) {
        if (api == null) {
            throw new IllegalArgumentException("api must not be null");
        }
        int targetSize = api.config(2);
        if (targetSize < 0) {
            if (targetSize == -34) {
                return null;
            }
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(api, targetSize));
        }
        ByteBuffer targetBuffer = ByteBuffer.allocateDirect(targetSize);
        int targetCopyResult = api.config(2, targetBuffer);
        if (targetCopyResult < 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(api, targetCopyResult));
        }
        return StandardCharsets.UTF_8.decode(targetBuffer.limit(targetSize - 1)).toString();
    }

    public static boolean isJitSupported(IPcre2 api) {
        if (api == null) {
            throw new IllegalArgumentException("api must not be null");
        }
        int[] jitSupported = new int[1];
        int result = api.config(1, jitSupported);
        if (result < 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(api, result));
        }
        return jitSupported[0] == 1;
    }

    public static int getDefaultHeapLimit(IPcre2 api) {
        if (api == null) {
            throw new IllegalArgumentException("api must not be null");
        }
        int[] heapLimit = new int[1];
        int result = api.config(12, heapLimit);
        if (result < 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(api, result));
        }
        return heapLimit[0];
    }

    public static int getDefaultDepthLimit(IPcre2 api) {
        if (api == null) {
            throw new IllegalArgumentException("api must not be null");
        }
        int[] depthLimit = new int[1];
        int result = api.config(7, depthLimit);
        if (result < 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(api, result));
        }
        return depthLimit[0];
    }

    public static EnumSet<Pcre2UtfWidth> getCompiledWidths(IPcre2 api) {
        if (api == null) {
            throw new IllegalArgumentException("api must not be null");
        }
        int[] widthsMask = new int[1];
        int result = api.config(14, widthsMask);
        if (result < 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(api, result));
        }
        EnumSet<Pcre2UtfWidth> widths = EnumSet.noneOf(Pcre2UtfWidth.class);
        if ((widthsMask[0] & Pcre2UtfWidth.UTF8.value()) != 0) {
            widths.add(Pcre2UtfWidth.UTF8);
        }
        if ((widthsMask[0] & Pcre2UtfWidth.UTF16.value()) != 0) {
            widths.add(Pcre2UtfWidth.UTF16);
        }
        if ((widthsMask[0] & Pcre2UtfWidth.UTF32.value()) != 0) {
            widths.add(Pcre2UtfWidth.UTF32);
        }
        return widths;
    }

    public static int convertCharacterIndexToByteOffset(String input, int index) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        if (index < 0) {
            throw new IllegalArgumentException("index must be non-negative");
        }
        if (index >= input.length()) {
            throw new IllegalArgumentException("index must be within the bounds of the input string");
        }
        int offset = 0;
        for (int charIndex = 0; charIndex < index; ++charIndex) {
            char theChar = input.charAt(charIndex);
            if (theChar <= '\u007f') {
                ++offset;
                continue;
            }
            if (theChar <= '\u07ff') {
                offset += 2;
                continue;
            }
            if (Character.isHighSurrogate(theChar) || Character.isLowSurrogate(theChar)) {
                offset += 2;
                continue;
            }
            offset += 3;
        }
        return offset;
    }

    public static Pcre2Bsr getDefaultBsr(IPcre2 api) {
        if (api == null) {
            throw new IllegalArgumentException("api must not be null");
        }
        int[] bsr = new int[1];
        int result = api.config(0, bsr);
        if (result < 0) {
            throw new IllegalStateException(Pcre4jUtils.getErrorMessage(api, result));
        }
        return Pcre2Bsr.valueOf(bsr[0]).orElseThrow();
    }

    public static String getErrorMessage(IPcre2 api, int errorcode) {
        int size;
        if (api == null) {
            throw new IllegalArgumentException("api must not be null");
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(256);
        while ((size = api.getErrorMessage(errorcode, buffer)) == -48) {
            buffer = ByteBuffer.allocateDirect(buffer.capacity() * 2);
        }
        if (size < 0) {
            throw new IllegalStateException("Error getting error message: %d".formatted(size));
        }
        return StandardCharsets.UTF_8.decode(buffer.slice(0, size)).toString();
    }

    public static String[] getGroupNames(Pcre2Code code) {
        if (code == null) {
            throw new IllegalArgumentException("code must not be null");
        }
        String[] groupNames = new String[code.captureCount()];
        for (Pcre2Code.NameTableEntry nameTableEntry : code.nameTable()) {
            groupNames[nameTableEntry.group() - 1] = nameTableEntry.name();
        }
        return groupNames;
    }

    public static String[] getMatchGroups(Pcre2Code code, String subject, Pcre2MatchData matchData) {
        if (matchData == null) {
            throw new IllegalArgumentException("matchData must not be null");
        }
        return Pcre4jUtils.getMatchGroups(code, subject, matchData.ovector());
    }

    public static String[] getMatchGroups(Pcre2Code code, String subject, long[] ovector) {
        if (code == null) {
            throw new IllegalArgumentException("code must not be null");
        }
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (ovector == null) {
            throw new IllegalArgumentException("ovector must not be null");
        }
        int[] stringIndices = Pcre4jUtils.convertOvectorToStringIndices(subject, ovector);
        int matchGroupsCount = ovector.length / 2;
        String[] matchGroups = new String[matchGroupsCount];
        for (int matchIndex = 0; matchIndex < matchGroupsCount; ++matchIndex) {
            matchGroups[matchIndex] = subject.substring(stringIndices[matchIndex * 2], stringIndices[matchIndex * 2 + 1]);
        }
        return matchGroups;
    }

    public static Map<String, String> getNamedMatchGroups(Pcre2Code code, String subject, Pcre2MatchData matchData) {
        if (matchData == null) {
            throw new IllegalArgumentException("matchData must not be null");
        }
        return Pcre4jUtils.getNamedMatchGroups(code, subject, matchData.ovector());
    }

    public static Map<String, String> getNamedMatchGroups(Pcre2Code code, String subject, long[] ovector) {
        if (code == null) {
            throw new IllegalArgumentException("code must not be null");
        }
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (ovector == null) {
            throw new IllegalArgumentException("ovector must not be null");
        }
        int[] stringIndices = Pcre4jUtils.convertOvectorToStringIndices(subject, ovector);
        String[] groupNames = Pcre4jUtils.getGroupNames(code);
        HashMap<String, String> matchGroups = new HashMap<String, String>();
        for (int matchIndex = 1; matchIndex < ovector.length; ++matchIndex) {
            String groupName = groupNames[matchIndex - 1];
            if (groupName == null) continue;
            matchGroups.put(groupName, subject.substring(stringIndices[matchIndex * 2], stringIndices[matchIndex * 2 + 1]));
        }
        return matchGroups;
    }

    public static int[] convertOvectorToStringIndices(String subject, long[] ovector) {
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        return Pcre4jUtils.convertOvectorToStringIndices(subject, subject.getBytes(StandardCharsets.UTF_8), ovector);
    }

    public static int[] convertOvectorToStringIndices(String subject, byte[] subjectUtf8, long[] ovector) {
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (subjectUtf8 == null) {
            throw new IllegalArgumentException("subjectUtf8 must not be null");
        }
        if (ovector == null) {
            throw new IllegalArgumentException("ovector must not be null");
        }
        if (ovector.length < 2) {
            throw new IllegalArgumentException("ovector must have at least 2 elements");
        }
        if (ovector.length % 2 != 0) {
            throw new IllegalArgumentException("ovector must have an even number of elements");
        }
        OptionalLong ovectorMin = Arrays.stream(ovector).filter(value -> value != -1L).min();
        if (ovectorMin.isEmpty()) {
            int[] result = new int[ovector.length];
            Arrays.fill(result, -1);
            return result;
        }
        int matchSince = (int)ovectorMin.getAsLong();
        int matchUntil = (int)Arrays.stream(ovector).max().orElseThrow();
        int matchSizeInBytes = matchUntil - matchSince;
        int stringIndex = 0;
        int[] byteOffsetToStringIndex = new int[matchSizeInBytes + 1];
        int byteIndex = 0;
        while (byteIndex < matchUntil) {
            char subjectChar;
            if (byteIndex >= matchSince) {
                byteOffsetToStringIndex[byteIndex - matchSince] = stringIndex;
            }
            int subjectCharByteLength = (subjectChar = subject.charAt(stringIndex)) <= '\u007f' ? 1 : (subjectChar <= '\u07ff' ? 2 : (Character.isHighSurrogate(subjectChar) || Character.isLowSurrogate(subjectChar) ? 2 : 3));
            for (int subjectCharByteIndex = 0; subjectCharByteIndex < subjectCharByteLength; ++subjectCharByteIndex) {
                if (byteIndex >= matchSince) {
                    byteOffsetToStringIndex[byteIndex - matchSince] = stringIndex;
                }
                ++byteIndex;
            }
            ++stringIndex;
        }
        byteOffsetToStringIndex[matchSizeInBytes] = stringIndex;
        int[] stringIndices = new int[ovector.length];
        for (int valueIndex = 0; valueIndex < ovector.length; ++valueIndex) {
            int byteIndex2 = (int)ovector[valueIndex];
            stringIndices[valueIndex] = byteIndex2 == -1 ? -1 : byteOffsetToStringIndex[byteIndex2 - matchSince];
        }
        return stringIndices;
    }
}

