/*
 * Decompiled with CFR 0.152.
 */
package org.pcre4j.regex;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import org.pcre4j.Pcre2Code;
import org.pcre4j.Pcre2JitCode;
import org.pcre4j.Pcre2JitStack;
import org.pcre4j.Pcre2MatchContext;
import org.pcre4j.Pcre2MatchData;
import org.pcre4j.Pcre2MatchOption;
import org.pcre4j.Pcre4jUtils;
import org.pcre4j.api.IPcre2;
import org.pcre4j.regex.Pattern;

public class Matcher
implements java.util.regex.MatchResult {
    private static final long JIT_STACK_START_SIZE = 32768L;
    private static final long JIT_STACK_MAX_SIZE = 524288L;
    private Pattern pattern;
    private Pcre2MatchContext matchContext;
    private Pcre2JitStack jitStack;
    private Map<String, Integer> groupNameToIndex;
    private String input;
    private byte[] inputBytes;
    private int regionStart;
    private int regionEnd;
    private Pcre2MatchData lastMatchData;
    private int[] lastMatchIndices;

    Matcher(Pattern pattern, CharSequence input) {
        this.pattern = pattern;
        this.matchContext = new Pcre2MatchContext(pattern.code.api(), null);
        if (pattern.code instanceof Pcre2JitCode) {
            this.jitStack = new Pcre2JitStack(pattern.code.api(), 32768L, 524288L, null);
            this.matchContext.assignJitStack(this.jitStack);
        } else {
            this.jitStack = null;
        }
        this.groupNameToIndex = pattern.namedGroups();
        this.input = input.toString();
        this.inputBytes = this.input.getBytes(StandardCharsets.UTF_8);
        this.reset();
    }

    @Override
    public int end() {
        if (!this.hasMatch()) {
            throw new IllegalStateException("No match found");
        }
        return this.lastMatchIndices[1];
    }

    @Override
    public int end(int group) {
        if (!this.hasMatch()) {
            throw new IllegalStateException("No match found");
        }
        if (group < 0 || group > this.groupCount()) {
            throw new IndexOutOfBoundsException("No such group: " + group);
        }
        return this.lastMatchIndices[group * 2 + 1];
    }

    @Override
    public int end(String name) {
        if (!this.hasMatch()) {
            throw new IllegalStateException("No match found");
        }
        Integer group = this.groupNameToIndex.get(name);
        if (group == null) {
            throw new IllegalArgumentException("No group with name <" + name + ">");
        }
        return this.lastMatchIndices[group * 2 + 1];
    }

    public boolean find() {
        int start = 0;
        if (this.lastMatchIndices != null && (start = this.lastMatchIndices[1]) == this.lastMatchIndices[0]) {
            ++start;
        }
        if (start < this.regionStart) {
            start = this.regionStart;
        }
        if (start >= this.regionEnd) {
            this.lastMatchData = null;
            this.lastMatchIndices = null;
            return false;
        }
        return this.search(start);
    }

    public boolean find(int start) {
        int limit = this.input.length();
        if (start < 0 || start > limit) {
            throw new IndexOutOfBoundsException("Illegal start index");
        }
        this.reset();
        return this.search(start);
    }

    @Override
    public String group() {
        if (!this.hasMatch()) {
            throw new IllegalStateException("No match found");
        }
        return this.input.substring(this.lastMatchIndices[0], this.lastMatchIndices[1]);
    }

    @Override
    public String group(int group) {
        if (!this.hasMatch()) {
            throw new IllegalStateException("No match found");
        }
        if (group < 0 || group > this.groupCount()) {
            throw new IndexOutOfBoundsException("No such group: " + group);
        }
        int since = this.lastMatchIndices[group * 2];
        int until = this.lastMatchIndices[group * 2 + 1];
        if (since == -1 && until == -1) {
            return null;
        }
        return this.input.substring(since, until);
    }

    @Override
    public String group(String name) {
        if (!this.hasMatch()) {
            throw new IllegalStateException("No match found");
        }
        Integer group = this.groupNameToIndex.get(name);
        if (group == null) {
            throw new IllegalArgumentException("No group with name <" + name + ">");
        }
        int since = this.lastMatchIndices[group * 2];
        int until = this.lastMatchIndices[group * 2 + 1];
        if (since == -1 && until == -1) {
            return null;
        }
        return this.input.substring(since, until);
    }

    @Override
    public int groupCount() {
        return this.pattern.code.captureCount();
    }

    @Override
    public boolean hasMatch() {
        return this.lastMatchData != null;
    }

    public boolean lookingAt() {
        EnumSet<Pcre2MatchOption> matchOptions;
        Pcre2Code lookingAtCode;
        if (this.pattern.lookingAtCode != null) {
            lookingAtCode = this.pattern.lookingAtCode;
            matchOptions = EnumSet.noneOf(Pcre2MatchOption.class);
        } else {
            lookingAtCode = this.pattern.code;
            matchOptions = EnumSet.of(Pcre2MatchOption.ANCHORED);
        }
        Pcre2MatchData matchData = new Pcre2MatchData(lookingAtCode);
        int result = lookingAtCode.match(this.input.subSequence(0, this.regionEnd).toString(), this.regionStart, matchOptions, matchData, this.matchContext);
        if (result < 1) {
            if (result == -1) {
                return false;
            }
            String errorMessage = Pcre4jUtils.getErrorMessage((IPcre2)this.pattern.lookingAtCode.api(), (int)result);
            throw new RuntimeException("Failed to find an anchored match", new IllegalStateException(errorMessage));
        }
        this.lastMatchData = matchData;
        this.lastMatchIndices = Pcre4jUtils.convertOvectorToStringIndices((String)this.input, (byte[])this.inputBytes, (long[])matchData.ovector());
        return true;
    }

    public boolean matches() {
        EnumSet<Pcre2MatchOption> matchOptions;
        Pcre2Code matchingCode;
        if (this.pattern.matchingCode != null) {
            matchingCode = this.pattern.matchingCode;
            matchOptions = EnumSet.noneOf(Pcre2MatchOption.class);
        } else {
            matchingCode = this.pattern.code;
            matchOptions = EnumSet.of(Pcre2MatchOption.ANCHORED, Pcre2MatchOption.ENDANCHORED);
        }
        Pcre2MatchData matchData = new Pcre2MatchData(matchingCode);
        int result = matchingCode.match(this.input.subSequence(0, this.regionEnd).toString(), this.regionStart, matchOptions, matchData, this.matchContext);
        if (result < 1) {
            if (result == -1) {
                return false;
            }
            String errorMessage = Pcre4jUtils.getErrorMessage((IPcre2)this.pattern.matchingCode.api(), (int)result);
            throw new RuntimeException("Failed to find an anchored match", new IllegalStateException(errorMessage));
        }
        this.lastMatchData = matchData;
        this.lastMatchIndices = Pcre4jUtils.convertOvectorToStringIndices((String)this.input, (byte[])this.inputBytes, (long[])matchData.ovector());
        return true;
    }

    @Override
    public Map<String, Integer> namedGroups() {
        return this.groupNameToIndex;
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public Matcher region(int start, int end) {
        if (start < 0 || start > this.input.length()) {
            throw new IndexOutOfBoundsException("start");
        }
        if (end < 0 || end > this.input.length()) {
            throw new IndexOutOfBoundsException("end");
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start > end");
        }
        this.reset();
        this.regionStart = start;
        this.regionEnd = end;
        return this;
    }

    public int regionEnd() {
        return this.regionEnd;
    }

    public int regionStart() {
        return this.regionStart;
    }

    public Matcher reset() {
        this.regionStart = 0;
        this.regionEnd = this.input.length();
        this.lastMatchData = null;
        this.lastMatchIndices = null;
        return this;
    }

    public Matcher reset(CharSequence input) {
        this.input = input.toString();
        this.inputBytes = this.input.getBytes(StandardCharsets.UTF_8);
        return this.reset();
    }

    @Override
    public int start() {
        if (!this.hasMatch()) {
            throw new IllegalStateException("No match found");
        }
        return this.lastMatchIndices[0];
    }

    @Override
    public int start(int group) {
        if (!this.hasMatch()) {
            throw new IllegalStateException("No match found");
        }
        if (group < 0 || group > this.groupCount()) {
            throw new IndexOutOfBoundsException("No such group: " + group);
        }
        return this.lastMatchIndices[group * 2];
    }

    @Override
    public int start(String name) {
        if (!this.hasMatch()) {
            throw new IllegalStateException("No match found");
        }
        Integer group = this.groupNameToIndex.get(name);
        if (group == null) {
            throw new IllegalArgumentException("No group with name <" + name + ">");
        }
        return this.lastMatchIndices[group * 2];
    }

    public MatchResult toMatchResult() {
        if (!this.hasMatch()) {
            return new MatchResult(null, null, this.groupNameToIndex);
        }
        return new MatchResult(this.input.substring(this.lastMatchIndices[0], this.lastMatchIndices[1]), Arrays.copyOf(this.lastMatchIndices, this.lastMatchIndices.length), this.groupNameToIndex);
    }

    public String toString() {
        return Matcher.class.getName() + "[pattern=" + String.valueOf(this.pattern) + " region=" + this.regionStart + "," + this.regionEnd + " lastMatchIndices=" + Arrays.toString(this.lastMatchIndices) + "]";
    }

    public Matcher usePattern(Pattern newPattern) {
        if (newPattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        this.pattern = newPattern;
        this.matchContext = new Pcre2MatchContext(this.pattern.code.api(), null);
        if (this.pattern.code instanceof Pcre2JitCode) {
            this.jitStack = new Pcre2JitStack(this.pattern.code.api(), 32768L, 524288L, null);
            this.matchContext.assignJitStack(this.jitStack);
        } else {
            this.jitStack = null;
        }
        this.groupNameToIndex = newPattern.namedGroups();
        this.reset();
        return this;
    }

    private boolean search(int start) {
        Pcre2MatchData matchData = new Pcre2MatchData(this.pattern.code);
        int result = this.pattern.code.match(this.input.subSequence(0, this.regionEnd).toString(), start, EnumSet.noneOf(Pcre2MatchOption.class), matchData, this.matchContext);
        if (result < 1) {
            if (result == -1) {
                return false;
            }
            String errorMessage = Pcre4jUtils.getErrorMessage((IPcre2)this.pattern.code.api(), (int)result);
            throw new RuntimeException("Failed to find a match", new IllegalStateException(errorMessage));
        }
        this.lastMatchData = matchData;
        this.lastMatchIndices = Pcre4jUtils.convertOvectorToStringIndices((String)this.input, (byte[])this.inputBytes, (long[])matchData.ovector());
        return true;
    }

    public static class MatchResult
    implements java.util.regex.MatchResult {
        private final String substring;
        private final int[] matchIndices;
        private final Map<String, Integer> groupNameToIndex;

        MatchResult(String substring, int[] matchIndices, Map<String, Integer> groupNameToIndex) {
            this.substring = substring;
            this.matchIndices = matchIndices;
            this.groupNameToIndex = groupNameToIndex;
        }

        @Override
        public int start() {
            if (!this.hasMatch()) {
                throw new IllegalStateException("No match found");
            }
            return this.matchIndices[0];
        }

        @Override
        public int start(int group) {
            if (!this.hasMatch()) {
                throw new IllegalStateException("No match found");
            }
            if (group < 0 || group > this.groupCount()) {
                throw new IndexOutOfBoundsException("No such group: " + group);
            }
            return this.matchIndices[group * 2];
        }

        @Override
        public int start(String name) {
            if (!this.hasMatch()) {
                throw new IllegalStateException("No match found");
            }
            Integer group = this.groupNameToIndex.get(name);
            if (group == null) {
                throw new IllegalArgumentException("No group with name <" + name + ">");
            }
            return this.matchIndices[group * 2];
        }

        @Override
        public int end() {
            if (!this.hasMatch()) {
                throw new IllegalStateException("No match found");
            }
            return this.matchIndices[1];
        }

        @Override
        public int end(int group) {
            if (!this.hasMatch()) {
                throw new IllegalStateException("No match found");
            }
            if (group < 0 || group > this.groupCount()) {
                throw new IndexOutOfBoundsException("No such group: " + group);
            }
            return this.matchIndices[group * 2 + 1];
        }

        @Override
        public int end(String name) {
            if (!this.hasMatch()) {
                throw new IllegalStateException("No match found");
            }
            Integer group = this.groupNameToIndex.get(name);
            if (group == null) {
                throw new IllegalArgumentException("No group with name <" + name + ">");
            }
            return this.matchIndices[group * 2 + 1];
        }

        @Override
        public String group() {
            if (!this.hasMatch()) {
                throw new IllegalStateException("No match found");
            }
            return this.substring;
        }

        @Override
        public String group(int group) {
            if (!this.hasMatch()) {
                throw new IllegalStateException("No match found");
            }
            if (group < 0 || group > this.groupCount()) {
                throw new IndexOutOfBoundsException("No such group: " + group);
            }
            return this.substring.substring(this.matchIndices[group * 2] - this.matchIndices[0], this.matchIndices[group * 2 + 1] - this.matchIndices[0]);
        }

        @Override
        public String group(String name) {
            if (!this.hasMatch()) {
                throw new IllegalStateException("No match found");
            }
            Integer group = this.groupNameToIndex.get(name);
            if (group == null) {
                throw new IllegalArgumentException("No group with name <" + name + ">");
            }
            return this.substring.substring(this.matchIndices[group * 2] - this.matchIndices[0], this.matchIndices[group * 2 + 1] - this.matchIndices[0]);
        }

        @Override
        public int groupCount() {
            if (this.matchIndices == null) {
                return 0;
            }
            return this.matchIndices.length / 2 - 1;
        }

        @Override
        public Map<String, Integer> namedGroups() {
            return Map.copyOf(this.groupNameToIndex);
        }

        @Override
        public boolean hasMatch() {
            return this.matchIndices != null;
        }
    }
}

