/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.converters;

import httl.spi.Converter;
import httl.util.ClassComparator;
import httl.util.ClassUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiConverter
implements Converter<Object, Object> {
    private final Map<Class<?>, Converter<Object, Object>> converters = new ConcurrentHashMap();
    private Map<Class<?>, Converter<Object, Object>> sortedConverters;

    public void setConverters(Converter<Object, Object>[] converters) {
        if (converters != null && converters.length > 0) {
            for (Converter<Object, Object> converter : converters) {
                Class<?> type;
                if (converter == null || (type = ClassUtils.getGenericClass(converter.getClass())) == null || this.converters.containsKey(type)) continue;
                this.converters.put(type, converter);
            }
            TreeMap sorted = new TreeMap(ClassComparator.COMPARATOR);
            sorted.putAll(this.converters);
            this.sortedConverters = Collections.unmodifiableMap(sorted);
        }
    }

    @Override
    public Object convert(Object value, Map<String, Class<?>> types) throws IOException, ParseException {
        if (value != null && this.converters != null) {
            Class<?> cls = value.getClass();
            Converter<Object, Object> converter = this.converters.get(cls);
            if (converter != null) {
                return converter.convert(value, types);
            }
            if (this.sortedConverters != null) {
                for (Map.Entry<Class<?>, Converter<Object, Object>> entry : this.sortedConverters.entrySet()) {
                    if (!entry.getKey().isAssignableFrom(cls)) continue;
                    converter = entry.getValue();
                    this.converters.put(cls, converter);
                    return converter.convert(value, types);
                }
            }
        }
        return value;
    }
}

