/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.filters;

import httl.spi.filters.AbstractFilter;
import httl.util.Reqiured;
import httl.util.StringUtils;

public class CommentSyntaxFilter
extends AbstractFilter {
    private String commentLeft;
    private String commentRight;
    private boolean removeDirectiveBlankLine;

    @Reqiured
    public void setCommentLeft(String commentLeft) {
        this.commentLeft = commentLeft;
    }

    @Reqiured
    public void setCommentRight(String commentRight) {
        this.commentRight = commentRight;
    }

    public void setRemoveDirectiveBlankLine(boolean removeDirectiveBlankLine) {
        this.removeDirectiveBlankLine = removeDirectiveBlankLine;
    }

    public String filter(String key, String value) {
        boolean left = false;
        boolean right = false;
        String trim = value.trim();
        if (trim.startsWith(this.commentRight)) {
            value = value.substring(value.indexOf(this.commentRight) + this.commentRight.length());
            left = true;
        }
        if (trim.endsWith(this.commentLeft)) {
            value = value.substring(0, value.lastIndexOf(this.commentLeft));
            right = true;
        }
        if (this.removeDirectiveBlankLine && (left || right)) {
            value = StringUtils.trimBlankLine(value, left, right);
        }
        return value;
    }
}

