/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.interceptors;

import httl.Context;
import httl.Engine;
import httl.Template;
import httl.spi.Listener;
import httl.spi.interceptors.FirstInterceptor;
import httl.spi.methods.FileMethod;
import httl.spi.translators.templates.ListenerTemplate;
import httl.util.Optional;
import httl.util.StringUtils;
import httl.util.UrlUtils;
import java.io.IOException;
import java.text.ParseException;

public class ExtendsInterceptor
extends FirstInterceptor {
    private final FileMethod fileMethod = new FileMethod();
    private Engine engine;
    private String extendsDirectory;
    private String extendsDefault;
    private String extendsNested;
    private String extendsVariable;

    public void setEngine(Engine engine) {
        this.engine = engine;
        this.fileMethod.setEngine(engine);
    }

    public void setExtendsDirectory(String extendsDirectory) {
        this.extendsDirectory = UrlUtils.cleanDirectory(extendsDirectory);
        if ("/".equals(this.extendsDirectory)) {
            this.extendsDirectory = null;
        }
        this.fileMethod.setExtendsDirectory(extendsDirectory);
    }

    @Optional
    public void setExtendsDefault(String extendsDefault) {
        this.extendsDefault = extendsDefault;
    }

    @Optional
    public void setExtendsVariable(String extendsVariable) {
        this.extendsVariable = extendsVariable;
    }

    public void setExtendsNested(String extendsNested) {
        this.extendsNested = extendsNested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRender(Context context, Listener listener) throws IOException, ParseException {
        String extendsName = null;
        if (StringUtils.isNotEmpty(this.extendsVariable)) {
            extendsName = (String)context.get(this.extendsVariable);
        }
        Template template = context.getTemplate();
        if (StringUtils.isEmpty(extendsName) && StringUtils.isNotEmpty(this.extendsDefault)) {
            String templateName = template.getName();
            String name = UrlUtils.relativeUrl(this.extendsDefault, templateName);
            if (StringUtils.isNotEmpty(this.extendsDirectory)) {
                name = this.extendsDirectory + name;
            }
            if (!name.equals(templateName) && this.engine.hasResource(name)) {
                extendsName = this.extendsDefault;
            }
        }
        if (StringUtils.isNotEmpty(extendsName)) {
            Object oldNested = null;
            if (StringUtils.isNotEmpty(this.extendsNested)) {
                oldNested = context.put(this.extendsNested, (Object)new ListenerTemplate(template, listener));
            }
            try {
                Template extend = this.fileMethod.$extends(extendsName, template.getLocale(), template.getEncoding());
                extend.render(context.getOut());
            }
            finally {
                if (StringUtils.isNotEmpty(this.extendsNested)) {
                    if (oldNested != null) {
                        context.put(this.extendsNested, oldNested);
                    } else {
                        context.remove(this.extendsNested);
                    }
                }
            }
        } else {
            listener.render(context);
        }
    }
}

