/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.listeners;

import httl.Context;
import httl.spi.Listener;
import httl.spi.Logger;
import java.io.IOException;
import java.text.ParseException;

public class MultiListener
implements Listener {
    private Listener[] listeners;
    private Logger logger;

    public void setListeners(Listener[] listeners) {
        if (listeners != null && listeners.length > 0 && this.listeners != null && this.listeners.length > 0) {
            Listener[] oldListeners = this.listeners;
            this.listeners = new Listener[oldListeners.length + listeners.length];
            System.arraycopy(oldListeners, 0, this.listeners, 0, oldListeners.length);
            System.arraycopy(listeners, 0, this.listeners, oldListeners.length, listeners.length);
        } else {
            this.listeners = listeners;
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void render(Context context) throws IOException, ParseException {
        if (this.listeners == null || this.listeners.length == 0) {
            return;
        }
        if (this.listeners.length == 1) {
            this.listeners[0].render(context);
            return;
        }
        for (Listener listener : this.listeners) {
            try {
                listener.render(context);
            }
            catch (Exception e) {
                if (this.logger == null || !this.logger.isErrorEnabled()) continue;
                this.logger.error(e.getMessage(), e);
            }
        }
    }
}

