/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.loaders;

import httl.Engine;
import httl.Resource;
import httl.spi.Loader;
import httl.spi.Logger;
import httl.spi.loaders.resources.InputStreamResource;
import httl.util.CollectionUtils;
import httl.util.LocaleUtils;
import httl.util.StringUtils;
import httl.util.UrlUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLoader
implements Loader {
    private Engine engine;
    private Logger logger;
    private String encoding;
    private boolean reloadable;
    private volatile boolean first = true;
    private String[] templateDirectory;
    private String[] templateSuffix;
    private String[] messageDirectory;
    private String messageBasename;
    private String[] messageSuffix;

    public void setTemplateDirectory(String[] directory) {
        this.templateDirectory = UrlUtils.cleanDirectory(directory);
    }

    public void setTemplateSuffix(String[] suffix) {
        this.templateSuffix = suffix;
    }

    public void setMessageDirectory(String[] directory) {
        this.messageDirectory = UrlUtils.cleanDirectory(directory);
    }

    public void setMessageBasename(String messageBasename) {
        this.messageBasename = UrlUtils.cleanName(messageBasename);
    }

    public void setMessageSuffix(String[] suffix) {
        this.messageSuffix = suffix;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setReloadable(boolean reloadable) {
        this.reloadable = reloadable;
    }

    public void setInputEncoding(String encoding) {
        if (StringUtils.isNotEmpty(encoding)) {
            Charset.forName(encoding);
            this.encoding = encoding;
        }
    }

    protected Engine getEngine() {
        return this.engine;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    protected String relocate(String name, Locale locale, String[] directories) {
        if (CollectionUtils.isNotEmpty(directories)) {
            for (String directory : directories) {
                try {
                    if (!this.doExists(name, locale, directory + name)) continue;
                    name = directory + name;
                    return name;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return directories[0] + name;
        }
        return name;
    }

    protected String toPath(String name, Locale locale) {
        if (StringUtils.endsWith(name, this.templateSuffix)) {
            name = this.relocate(name, locale, this.templateDirectory);
        } else if (StringUtils.isNotEmpty(this.messageBasename) && name.startsWith(this.messageBasename) && StringUtils.endsWith(name, this.messageSuffix)) {
            name = this.relocate(name, locale, this.messageDirectory);
        }
        return LocaleUtils.appendLocale(name, locale);
    }

    @Override
    public List<String> list(String suffix) throws IOException {
        Object directories = StringUtils.endsWith(suffix, this.templateSuffix) ? this.templateDirectory : (StringUtils.endsWith(suffix, this.messageSuffix) ? this.messageDirectory : null);
        if (CollectionUtils.isEmpty(directories)) {
            directories = new String[]{"/"};
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Object directory : directories) {
            List<String> list = this.doList((String)directory, suffix);
            if (!CollectionUtils.isNotEmpty(list)) continue;
            for (String name : list) {
                if (!StringUtils.isNotEmpty(name)) continue;
                result.add(UrlUtils.cleanName(name));
            }
        }
        return result;
    }

    @Override
    public boolean exists(String name, Locale locale) {
        Locale cur = locale;
        while (cur != null) {
            if (this._exists(name, locale, this.toPath(name, cur))) {
                return true;
            }
            cur = LocaleUtils.getParentLocale(cur);
        }
        return this._exists(name, locale, this.toPath(name, null));
    }

    private boolean _exists(String name, Locale locale, String path) {
        try {
            return this.doExists(name, locale, path);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Resource load(String name, Locale locale, String encoding) throws IOException {
        if (StringUtils.isEmpty(encoding)) {
            encoding = this.encoding;
        }
        Locale cur = locale;
        String path = this.toPath(name, cur);
        while (cur != null && !this._exists(name, locale, path)) {
            cur = LocaleUtils.getParentLocale(cur);
            path = this.toPath(name, cur);
        }
        Resource resource = this.doLoad(name, locale, encoding, path);
        this.logResourceDirectory(resource);
        return resource;
    }

    private void logResourceDirectory(Resource resource) {
        if (this.first) {
            File file;
            this.first = false;
            if (this.logger != null && this.logger.isInfoEnabled() && resource instanceof InputStreamResource && (file = ((InputStreamResource)resource).getFile()) != null && file.exists()) {
                int i;
                String uri = resource.getName().replace('\\', '/');
                String abs = file.getAbsolutePath().replace('\\', '/');
                abs = abs.endsWith(uri) ? abs.substring(0, abs.length() - uri.length()) : ((i = abs.lastIndexOf(47)) > 0 ? abs.substring(0, i) : "/");
                this.logger.info("Load httl template from" + (this.reloadable ? " RELOADABLE" : "") + " directory " + abs + " by " + this.getClass().getSimpleName() + ".");
            }
        }
    }

    protected abstract List<String> doList(String var1, String var2) throws IOException;

    protected abstract boolean doExists(String var1, Locale var2, String var3) throws IOException;

    protected abstract Resource doLoad(String var1, Locale var2, String var3, String var4) throws IOException;
}

