/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.loaders;

import httl.Resource;
import httl.spi.loaders.AbstractLoader;
import httl.spi.loaders.resources.ServletResource;
import httl.util.UrlUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletLoader
extends AbstractLoader
implements ServletContextListener {
    private static ServletContext SERVLET_CONTEXT;

    public static ServletContext getAndCheckServletContext() {
        if (SERVLET_CONTEXT == null) {
            throw new IllegalStateException("servletContext == null. Please add config in your /WEB-INF/web.xml: \n<listener>\n\t<listener-class>" + ServletLoader.class.getName() + "</listener-class>\n</listener>\n");
        }
        return SERVLET_CONTEXT;
    }

    public static ServletContext getServletContext() {
        return SERVLET_CONTEXT;
    }

    public static void setServletContext(ServletContext servletContext) {
        SERVLET_CONTEXT = servletContext;
    }

    public void contextInitialized(ServletContextEvent sce) {
        ServletLoader.setServletContext(sce.getServletContext());
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletLoader.setServletContext(null);
    }

    @Override
    public List<String> doList(String directory, String suffix) throws IOException {
        String path = ServletLoader.getAndCheckServletContext().getRealPath(directory);
        if (path == null || path.length() == 0) {
            return null;
        }
        return UrlUtils.listFile(new File(path), suffix);
    }

    @Override
    protected Resource doLoad(String name, Locale locale, String encoding, String path) throws IOException {
        return new ServletResource(this.getEngine(), name, locale, encoding, path, ServletLoader.getAndCheckServletContext());
    }

    @Override
    public boolean doExists(String name, Locale locale, String path) throws IOException {
        return SERVLET_CONTEXT != null && SERVLET_CONTEXT.getResource(path) != null;
    }
}

