/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.loaders;

import httl.Resource;
import httl.spi.loaders.AbstractLoader;
import httl.spi.loaders.resources.UrlResource;
import httl.util.UrlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlLoader
extends AbstractLoader {
    @Override
    public List<String> doList(String directory, String suffix) throws IOException {
        return UrlUtils.listUrl(new URL(this.cleanPath(directory)), suffix);
    }

    @Override
    protected Resource doLoad(String name, Locale locale, String encoding, String path) throws IOException {
        return new UrlResource(this.getEngine(), name, locale, encoding, this.cleanPath(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doExists(String name, Locale locale, String path) throws IOException {
        InputStream in = new URL(this.cleanPath(path)).openStream();
        try {
            boolean bl = in != null;
            return bl;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private String cleanPath(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }
}

