/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.loaders.resources;

import httl.Engine;
import httl.Resource;
import httl.util.IOUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;

public abstract class AbstractResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 6834431114838915042L;
    private final transient Engine engine;
    private final String name;
    private final String encoding;
    private final Locale locale;
    private final long lastModified;

    public AbstractResource(Engine engine, String name, Locale locale, String encoding) {
        this(engine, name, locale, encoding, -1L);
    }

    public AbstractResource(Engine engine, String name, Locale locale, String encoding, long lastModified) {
        this.engine = engine;
        this.name = name;
        this.encoding = encoding;
        this.locale = locale;
        this.lastModified = lastModified;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public String getName() {
        return this.name;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getLength() {
        return -1L;
    }

    public String getSource() throws IOException {
        try {
            return IOUtils.readToString(this.openReader());
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public String toString() {
        return this.getName();
    }
}

