/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.loaders.resources;

import httl.Engine;
import httl.spi.loaders.resources.AbstractResource;
import httl.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Locale;

public abstract class InputStreamResource
extends AbstractResource {
    private static final long serialVersionUID = -5150738383353330217L;
    protected static final String FILE_PROTOCOL = "file";
    protected static final String FILE_PROTOCOL_PREFIX = "file:";
    protected static final String JAR_PROTOCOL = "jar";
    protected static final String JAR_PROTOCOL_PREFIX = "jar:";
    protected static final String JAR_FILE_SEPARATOR = "!/";
    private final String path;

    public InputStreamResource(Engine engine, String name, Locale locale, String encoding, String path) {
        super(engine, name, locale, encoding);
        this.path = path;
    }

    public Reader openReader() throws IOException {
        InputStream in = this.openStream();
        if (in == null) {
            throw new FileNotFoundException("Not found template " + this.getName() + " in " + this.getClass().getSimpleName() + ": " + this.getPath());
        }
        String encoding = this.getEncoding();
        return StringUtils.isEmpty(encoding) ? new InputStreamReader(in) : new InputStreamReader(in, encoding);
    }

    public long getLastModified() {
        File file = this.getFile();
        if (file != null && file.exists()) {
            return file.lastModified();
        }
        URL url = this.getUrl();
        if (url != null && JAR_PROTOCOL.equals(url.getProtocol())) {
            int i;
            String path = url.getFile();
            if (path.startsWith(JAR_PROTOCOL_PREFIX)) {
                path = path.substring(JAR_PROTOCOL_PREFIX.length());
            }
            if (path.startsWith(FILE_PROTOCOL_PREFIX)) {
                path = path.substring(FILE_PROTOCOL_PREFIX.length());
            }
            if ((i = path.indexOf(JAR_FILE_SEPARATOR)) > 0) {
                path = path.substring(0, i);
            }
            if ((file = new File(path)).exists()) {
                return file.lastModified();
            }
        }
        return super.getLastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLength() {
        block6: {
            long l;
            File file = this.getFile();
            if (file != null) {
                return file.length();
            }
            InputStream in = this.openStream();
            if (in == null) break block6;
            try {
                l = in.available();
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            in.close();
            return l;
        }
        return super.getLength();
    }

    public File getFile() {
        URL url = this.getUrl();
        if (url != null && FILE_PROTOCOL.equals(url.getProtocol())) {
            File file;
            String path = url.getFile();
            if (path.startsWith(FILE_PROTOCOL_PREFIX)) {
                path = path.substring(FILE_PROTOCOL_PREFIX.length());
            }
            if ((file = new File(path)).exists()) {
                return file;
            }
        }
        return null;
    }

    protected URL getUrl() {
        return null;
    }

    protected String getPath() {
        return this.path;
    }
}

