/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.loaders.resources;

import httl.Engine;
import httl.spi.loaders.resources.InputStreamResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.zip.ZipFile;

public class ZipResource
extends InputStreamResource {
    private static final long serialVersionUID = 1L;
    private final File file;

    public ZipResource(Engine engine, String name, Locale locale, String encoding, File file) {
        super(engine, name, locale, encoding, file.getPath() + "!/" + name);
        this.file = file;
    }

    public InputStream openStream() throws IOException {
        ZipFile zipFile = new ZipFile(this.file);
        return zipFile.getInputStream(zipFile.getEntry(this.getName()));
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLength() {
        long l;
        ZipFile zipFile = new ZipFile(this.file);
        try {
            l = zipFile.getEntry(this.getName()).getSize();
        }
        catch (Throwable throwable) {
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException e) {
                return super.getLength();
            }
        }
        zipFile.close();
        return l;
    }
}

