/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.methods;

import httl.Context;
import httl.Engine;
import httl.Resource;
import httl.Template;
import httl.spi.Logger;
import httl.spi.Resolver;
import httl.util.EncodingProperties;
import httl.util.LocaleUtils;
import httl.util.StringUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MessageMethod {
    private Engine engine;
    private Resolver resolver;
    private Logger logger;
    private String messageBasename;
    private String messageFormat;
    private String messageEncoding;
    private String messageSuffix;
    private boolean reloadable;
    private final ConcurrentMap<String, EncodingProperties> messageCache = new ConcurrentHashMap<String, EncodingProperties>();

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public void setReloadable(boolean reloadable) {
        this.reloadable = reloadable;
    }

    public void setMessageEncoding(String messageEncoding) {
        this.messageEncoding = messageEncoding;
    }

    public void setMessageSuffix(String messageSuffix) {
        this.messageSuffix = messageSuffix;
    }

    public void setMessageBasename(String messageBasename) {
        this.messageBasename = messageBasename;
    }

    public void setMessageFormat(String messageFormat) {
        if (!"string".equals(messageFormat) && !"message".equals(messageFormat)) {
            throw new IllegalArgumentException("Unsupported message.format=" + messageFormat + ", only supported \"string\" or \"message\" format.");
        }
        this.messageFormat = messageFormat;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private Locale getLocale() {
        Template template = Context.getContext().getTemplate();
        if (template != null && template.getLocale() != null) {
            return template.getLocale();
        }
        Object locale = this.resolver.get("locale");
        if (locale instanceof Locale) {
            return (Locale)locale;
        }
        if (locale instanceof String) {
            return LocaleUtils.getLocale((String)locale);
        }
        return null;
    }

    public String message(String key) {
        return this.message(key, (Locale)null, new String[0]);
    }

    public String message(String key, Object arg0) {
        return this.message(key, (Locale)null, new Object[]{arg0});
    }

    public String message(String key, Object arg0, Object arg1) {
        return this.message(key, (Locale)null, new Object[]{arg0, arg1});
    }

    public String message(String key, Object arg0, Object arg1, Object arg2) {
        return this.message(key, (Locale)null, new Object[]{arg0, arg1, arg2});
    }

    public String message(String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        return this.message(key, (Locale)null, new Object[]{arg0, arg1, arg2, arg3});
    }

    public String message(String key, Object[] args) {
        return this.message(key, (Locale)null, args);
    }

    public String message(String key, Locale locale) {
        return this.message(key, locale, new String[0]);
    }

    public String message(String key, Locale locale, Object arg0) {
        return this.message(key, locale, new Object[]{arg0});
    }

    public String message(String key, Locale locale, Object arg0, Object arg1) {
        return this.message(key, locale, new Object[]{arg0, arg1});
    }

    public String message(String key, Locale locale, Object arg0, Object arg1, Object arg2) {
        return this.message(key, locale, new Object[]{arg0, arg1, arg2});
    }

    public String message(String key, Locale locale, Object arg0, Object arg1, Object arg2, Object arg3) {
        return this.message(key, locale, new Object[]{arg0, arg1, arg2, arg3});
    }

    public String message(String key, Locale locale, Object[] args) {
        String value;
        if (StringUtils.isEmpty(key) || this.messageBasename == null) {
            return key;
        }
        if (locale == null) {
            locale = this.getLocale();
        }
        if (StringUtils.isNotEmpty(value = this.findMessageByLocale(key, locale))) {
            if (args != null && args.length > 0) {
                if ("string".equals(this.messageFormat)) {
                    return String.format(value, args);
                }
                return MessageFormat.format(value, args);
            }
            return value;
        }
        return key;
    }

    private String findMessageByLocale(String key, Locale locale) {
        String value;
        EncodingProperties properties;
        block7: {
            String file = this.messageBasename + (locale == null ? "" : "_" + locale) + this.messageSuffix;
            properties = (EncodingProperties)this.messageCache.get(file);
            if ((properties == null || this.reloadable) && this.engine.hasResource(file)) {
                EncodingProperties old;
                if (properties == null && (old = this.messageCache.putIfAbsent(file, properties = new EncodingProperties())) != null) {
                    properties = old;
                }
                try {
                    Resource resource = this.engine.getResource(file);
                    if (properties.getLastModified() < resource.getLastModified()) {
                        String encoding = StringUtils.isEmpty(this.messageEncoding) ? "UTF-8" : this.messageEncoding;
                        properties.load(resource.openStream(), encoding, resource.getLastModified());
                    }
                }
                catch (IOException e) {
                    if (this.logger == null || !this.logger.isErrorEnabled()) break block7;
                    this.logger.error("Failed to load httl message file " + file + " with locale " + locale + ", cause: " + e.getMessage(), e);
                }
            }
        }
        if (properties != null && StringUtils.isNotEmpty(value = properties.getProperty(key))) {
            return value;
        }
        if (locale != null) {
            return this.findMessageByLocale(key, LocaleUtils.getParentLocale(locale));
        }
        return null;
    }
}

