/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.parsers;

import httl.Engine;
import httl.Node;
import httl.Template;
import httl.ast.BlockDirective;
import httl.ast.BreakDirective;
import httl.ast.Comment;
import httl.ast.Directive;
import httl.ast.ElseDirective;
import httl.ast.EndDirective;
import httl.ast.Expression;
import httl.ast.ForDirective;
import httl.ast.IfDirective;
import httl.ast.MacroDirective;
import httl.ast.RootDirective;
import httl.ast.SetDirective;
import httl.ast.Statement;
import httl.ast.Text;
import httl.ast.ValueDirective;
import httl.spi.Parser;
import httl.util.ClassUtils;
import httl.util.DfaScanner;
import httl.util.LinkedStack;
import httl.util.ParameterizedTypeImpl;
import httl.util.StringUtils;
import httl.util.Token;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateParser
implements Parser {
    private static final int E = -1;
    private static final int B = -2;
    private static final int S = -51;
    private static final int P = -104;
    private static final int O = -1000004;
    private static final int P2 = -107;
    private static final int O2 = -1000007;
    static final int[][] states = new int[][]{{1, 1, 2, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 8, 1, 1}, {1, 1, -2, -2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 8, 1, 1}, {1, 3, 9, -2, 6, 10, 1, 1, 12, 1, -107, 1, 1, 1, 1, 1, 1, 1}, {26, 3, -2, -2, -2, -2, -104, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2}, {4, 4, 4, 4, 4, 4, -104, -1000004, 4, 4, 4, 4, 14, 16, 18, 4, 4, 4}, {1, 1, -2, -2, 6, 1, 1, 1, 1, 1, -107, 1, 1, 1, 1, 1, 1, 1}, {1, 1, -2, -2, 1, 1, 1, 1, 1, 1, -107, 1, 1, 1, 1, 1, 1, 1}, {7, 7, 7, 7, 7, 7, 7, 7, 7, 7, -107, -1000007, 20, 22, 24, 7, 7, 7}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, -2, 9}, {10, 10, 10, 10, 10, 11, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10}, {10, 10, -1, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10}, {12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 12, 12, 12, 12, 12, 12, 12, 12}, {12, 12, -1, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12}, {14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 4, 14, 14, 15, 14, 14}, {14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14}, {16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 4, 16, 17, 16, 16}, {16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16}, {18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 4, 19, 18, 18}, {18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18}, {20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 7, 20, 20, 21, 20, 20}, {20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20}, {22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 7, 22, 23, 22, 22}, {22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22}, {24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 7, 25, 24, 24}, {24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24}, {26, -51, -51, -51, -51, -51, -104, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51}};
    private static DfaScanner scanner = new DfaScanner(){

        public int next(int state, char ch) {
            return states[state][TemplateParser.getCharType(ch)];
        }
    };
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("\\\\+[#$]");
    private String[] setDirective = new String[]{"set"};
    private String[] ifDirective = new String[]{"if"};
    private String[] elseDirective = new String[]{"else"};
    private String[] forDirective = new String[]{"for"};
    private String[] breakDirective = new String[]{"break"};
    private String[] macroDirective = new String[]{"macro"};
    private String[] endDirective = new String[]{"end"};
    private Engine engine;
    private Parser expressionParser;
    private String[] importMacros;
    private final Map<String, Template> importMacroTemplates = new ConcurrentHashMap<String, Template>();
    private String[] importPackages;
    private String[] importVariables;
    private Map<String, Class<?>> importTypes;
    private final Map<Class<?>, Object> functions = new ConcurrentHashMap();
    private Class<?> defaultVariableType;
    private boolean removeDirectiveBlankLine = true;
    private static final Pattern DEFINE_PATTERN = Pattern.compile("([\\w>\\]]\\s+\\w+)\\s*[,]?");

    static int getCharType(char ch) {
        switch (ch) {
            case '\b': 
            case '\t': 
            case '\f': 
            case ' ': {
                return 0;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return 1;
            }
            case '#': {
                return 2;
            }
            case '$': {
                return 3;
            }
            case '!': {
                return 4;
            }
            case '*': {
                return 5;
            }
            case '(': {
                return 6;
            }
            case ')': {
                return 7;
            }
            case '[': {
                return 8;
            }
            case ']': {
                return 9;
            }
            case '{': {
                return 10;
            }
            case '}': {
                return 11;
            }
            case '\"': {
                return 12;
            }
            case '\'': {
                return 13;
            }
            case '`': {
                return 14;
            }
            case '\\': {
                return 15;
            }
            case '\n': 
            case '\r': {
                return 16;
            }
        }
        return 17;
    }

    private boolean isDirective(String message) {
        if (message.length() > 1 && message.charAt(0) == '#' && message.charAt(1) >= 'a' && message.charAt(1) <= 'z') {
            int i = message.indexOf(40);
            String name = i > 0 ? message.substring(1, i) : message.substring(1);
            return this.isDirectiveName(name);
        }
        return false;
    }

    private boolean isDirectiveName(String name) {
        return StringUtils.inArray(name, this.setDirective) || StringUtils.inArray(name, this.ifDirective) || StringUtils.inArray(name, this.elseDirective) || StringUtils.inArray(name, this.forDirective) || StringUtils.inArray(name, this.breakDirective) || StringUtils.inArray(name, this.macroDirective) || StringUtils.inArray(name, this.endDirective);
    }

    private void defineVariableTypes(String value, int offset, List<Statement> directives) throws ParseException {
        int o = offset;
        for (String v : TemplateParser.splitDefine(value)) {
            String var;
            String type;
            int i = (v = v.trim().replaceAll("\\s", " ")).lastIndexOf(32);
            if (i <= 0) {
                type = this.defaultVariableType == null ? Object.class.getSimpleName() : this.defaultVariableType.getCanonicalName();
                var = v;
            } else {
                type = v.substring(0, i).trim();
                var = v.substring(i + 1).trim();
            }
            directives.add(new SetDirective(this.parseGenericType(type, o), var, null, false, false, offset));
            o += v.length() + 1;
        }
    }

    private boolean isNoLiteralText(Statement node) {
        return node instanceof Text && !((Text)node).isLiteral();
    }

    private List<Statement> clean(List<Statement> nodes) throws ParseException {
        ArrayList<Statement> result = null;
        for (int i = 0; i < nodes.size(); ++i) {
            if (i + 1 < nodes.size() && this.isNoLiteralText(nodes.get(i)) && this.isNoLiteralText(nodes.get(i + 1))) {
                if (result == null) {
                    result = new ArrayList<Statement>();
                    for (int j = 0; j < i; ++j) {
                        result.add(nodes.get(j));
                    }
                }
                int offset = nodes.get(i).getOffset();
                StringBuilder buf = new StringBuilder();
                buf.append(((Text)nodes.get(i)).getContent());
                while (i + 1 < nodes.size() && this.isNoLiteralText(nodes.get(i + 1))) {
                    buf.append(((Text)nodes.get(i + 1)).getContent());
                    ++i;
                }
                result.add(new Text(buf.toString(), false, offset));
                continue;
            }
            if (result == null) continue;
            result.add(nodes.get(i));
        }
        if (result != null) {
            return result;
        }
        return nodes;
    }

    private List<Statement> scan(String source, int sourceOffset) throws ParseException {
        ArrayList<Statement> directives = new ArrayList<Statement>();
        List<Token> tokens = scanner.scan(source, sourceOffset);
        AtomicInteger seq = new AtomicInteger();
        for (int t = 0; t < tokens.size(); ++t) {
            boolean literal;
            Token token = tokens.get(t);
            String message = token.getMessage();
            int offset = token.getOffset();
            if (this.isDirective(message)) {
                String value;
                String name;
                int exprOffset;
                int s = message.indexOf(40);
                if (s > 0) {
                    exprOffset = offset + s + 1;
                    name = message.substring(1, s);
                    if (!message.endsWith(")")) {
                        throw new ParseException("The #" + name + " directive mismatch right parentheses.", exprOffset);
                    }
                    value = message.substring(s + 1, message.length() - 1);
                } else {
                    exprOffset = token.getOffset() + message.length();
                    name = message.substring(1);
                    value = "";
                    if (!(StringUtils.inArray(name, this.elseDirective) || StringUtils.inArray(name, this.endDirective) || StringUtils.inArray(name, this.breakDirective))) {
                        throw new ParseException("Not found parameter expression in the #" + name + " directive.", offset);
                    }
                }
                if (StringUtils.inArray(name, this.setDirective)) {
                    if (value.contains("=")) {
                        int o = 0;
                        for (String v : TemplateParser.splitAssign(value)) {
                            int blank;
                            int i = v.indexOf(61);
                            String var = v.substring(0, i).trim();
                            String expr = v.substring(i + 1);
                            for (blank = 0; blank < expr.length() && Character.isWhitespace(expr.charAt(blank)); ++blank) {
                            }
                            if (blank > 0) {
                                expr = expr.substring(blank);
                            }
                            Expression expression = (Expression)this.expressionParser.parse(expr, exprOffset + i + 1 + blank + o);
                            boolean export = false;
                            boolean hide = false;
                            if (var.endsWith(":")) {
                                export = true;
                                var = var.substring(0, var.length() - 1).trim();
                            } else if (var.endsWith(".")) {
                                hide = true;
                                var = var.substring(0, var.length() - 1).trim();
                            }
                            int j = var.lastIndexOf(32);
                            String type = null;
                            if (j > 0) {
                                type = var.substring(0, j).trim();
                                var = var.substring(j + 1).trim();
                            }
                            directives.add(new SetDirective(this.parseGenericType(type, exprOffset), var, expression, export, hide, offset));
                            o += v.length() + 1;
                        }
                        continue;
                    }
                    this.defineVariableTypes(value, offset, directives);
                    continue;
                }
                if (StringUtils.inArray(name, this.forDirective)) {
                    int blank;
                    if (StringUtils.isNumber(value.trim())) {
                        value = "__for" + seq.incrementAndGet() + " : 1 .. " + value.trim();
                    }
                    int i = value.indexOf(" in ");
                    int n = 4;
                    if (i < 0) {
                        i = value.indexOf(58);
                        n = 1;
                    }
                    if (i < 0) {
                        throw new ParseException("Miss colon \":\" in invalid directive #for(" + value + ")", offset);
                    }
                    String var = value.substring(0, i).trim();
                    String expr = value.substring(i + n);
                    for (blank = 0; blank < expr.length() && Character.isWhitespace(expr.charAt(blank)); ++blank) {
                    }
                    if (blank > 0) {
                        expr = expr.substring(blank);
                    }
                    Expression expression = (Expression)this.expressionParser.parse(expr, exprOffset + i + n + blank);
                    int j = var.lastIndexOf(32);
                    String type = null;
                    if (j > 0) {
                        type = var.substring(0, j).trim();
                        var = var.substring(j + 1).trim();
                    }
                    directives.add(new ForDirective(this.parseGenericType(type, exprOffset), var, expression, offset));
                    continue;
                }
                if (StringUtils.inArray(name, this.ifDirective)) {
                    directives.add(new IfDirective((Expression)this.expressionParser.parse(value, exprOffset), offset));
                    continue;
                }
                if (StringUtils.inArray(name, this.elseDirective)) {
                    directives.add(new ElseDirective(StringUtils.isEmpty(value) ? null : (Expression)this.expressionParser.parse(value, exprOffset), offset));
                    continue;
                }
                if (StringUtils.inArray(name, this.breakDirective)) {
                    directives.add(new BreakDirective(StringUtils.isBlank(value) ? null : (Expression)this.expressionParser.parse(value, exprOffset), offset));
                    continue;
                }
                if (StringUtils.inArray(name, this.macroDirective)) {
                    int i;
                    String macroName = value;
                    String macroParams = null;
                    String filter = null;
                    int idx = macroName.indexOf("=>");
                    if (idx > 0) {
                        filter = macroName.substring(idx + 2).trim();
                        macroName = macroName.substring(0, idx);
                    }
                    if ((i = value.indexOf(40)) > 0) {
                        if (!message.endsWith(")")) {
                            throw new ParseException("The #" + name + " directive mismatch right parentheses.", exprOffset);
                        }
                        macroName = value.substring(0, i);
                        macroParams = value.substring(i + 1, value.length() - 1);
                    }
                    String set = null;
                    boolean parent = false;
                    boolean hide = false;
                    i = macroName.indexOf(61);
                    if (i > 0) {
                        set = macroName.substring(0, i);
                        if (set.endsWith(":")) {
                            parent = true;
                            set = set.substring(0, set.length() - 1);
                        } else if (set.endsWith(".")) {
                            hide = true;
                            set = set.substring(0, set.length() - 1);
                        }
                        set = set.trim();
                        macroName = macroName.substring(i + 1);
                    }
                    boolean out = false;
                    if (macroName.startsWith("$")) {
                        out = true;
                        macroName = macroName.substring(macroName.startsWith("$!") ? 2 : 1);
                    }
                    String expr = StringUtils.isNotEmpty(filter) ? (filter.contains("(") ? filter : filter + "(" + macroName + ")") : macroName;
                    if (StringUtils.isNotEmpty(set)) {
                        directives.add(new SetDirective((Type)((Object)Template.class), set, (Expression)this.expressionParser.parse(expr, exprOffset), parent, hide, offset));
                    }
                    if (out) {
                        directives.add(new ValueDirective((Expression)this.expressionParser.parse(expr, exprOffset), true, offset));
                    }
                    macroName = macroName.trim();
                    directives.add(new MacroDirective(macroName, offset));
                    if (!StringUtils.isNotEmpty(macroParams)) continue;
                    this.defineVariableTypes(macroParams, exprOffset, directives);
                    continue;
                }
                if (!StringUtils.inArray(name, this.endDirective)) continue;
                directives.add(new EndDirective(offset));
                continue;
            }
            if (message.endsWith("}") && (message.startsWith("${") || message.startsWith("$!{") || message.startsWith("#{") || message.startsWith("#!{"))) {
                int i = message.indexOf(123);
                directives.add(new ValueDirective((Expression)this.expressionParser.parse(message.substring(i + 1, message.length() - 1), offset + i + 1), message.startsWith("$!") || message.startsWith("#!"), offset));
                continue;
            }
            if (message.startsWith("##")) {
                directives.add(new Comment(message.substring(2), false, offset));
                continue;
            }
            if (message.startsWith("#*") && message.endsWith("*#")) {
                directives.add(new Comment(message.substring(2, message.length() - 2), true, offset));
                continue;
            }
            if (message.startsWith("#[") && message.endsWith("]#")) {
                message = message.substring(2, message.length() - 2);
                literal = true;
            } else {
                message = this.filterEscape(message);
                literal = false;
            }
            directives.add(new Text(message, literal, offset));
        }
        return directives;
    }

    private BlockDirective reduce(List<Statement> directives) throws ParseException {
        LinkedStack<BlockDirectiveEntry> directiveStack = new LinkedStack<BlockDirectiveEntry>();
        RootDirective rootDirective = new RootDirective();
        directiveStack.push(new BlockDirectiveEntry(rootDirective));
        int n = directives.size();
        for (int i = 0; i < n; ++i) {
            Statement directive = directives.get(i);
            if (directive == null) continue;
            Class<?> directiveClass = directive.getClass();
            if (directiveClass == EndDirective.class || directiveClass == ElseDirective.class) {
                if (directiveStack.isEmpty()) {
                    throw new ParseException("Miss #end directive.", directive.getOffset());
                }
                BlockDirective blockDirective = ((BlockDirectiveEntry)directiveStack.pop()).popDirective();
                if (blockDirective == rootDirective) {
                    throw new ParseException("Miss #end directive.", directive.getOffset());
                }
                EndDirective endDirective = directiveClass == ElseDirective.class ? new EndDirective(directive.getOffset()) : (EndDirective)directive;
                blockDirective.setEnd(endDirective);
            }
            if (directiveClass != EndDirective.class) {
                if (directiveStack.isEmpty()) {
                    throw new ParseException("Miss #end directive.", directive.getOffset());
                }
                ((BlockDirectiveEntry)directiveStack.peek()).appendInnerDirective(directive);
            }
            if (!(directive instanceof BlockDirective)) continue;
            directiveStack.push(new BlockDirectiveEntry((BlockDirective)directive));
        }
        BlockDirective root = ((BlockDirectiveEntry)directiveStack.pop()).popDirective();
        if (!directiveStack.isEmpty()) {
            throw new ParseException("Miss #end directive." + root.getClass().getSimpleName(), root.getOffset());
        }
        return root;
    }

    public void setRemoveDirectiveBlankLine(boolean removeDirectiveBlankLine) {
        this.removeDirectiveBlankLine = removeDirectiveBlankLine;
    }

    public void setSetDirective(String[] setDirective) {
        this.setDirective = setDirective;
    }

    public void setIfDirective(String[] ifDirective) {
        this.ifDirective = ifDirective;
    }

    public void setElseDirective(String[] elseDirective) {
        this.elseDirective = elseDirective;
    }

    public void setForDirective(String[] forDirective) {
        this.forDirective = forDirective;
    }

    public void setBreakDirective(String[] breakDirective) {
        this.breakDirective = breakDirective;
    }

    public void setMacroDirective(String[] macroDirective) {
        this.macroDirective = macroDirective;
    }

    public void setEndDirective(String[] endDirective) {
        this.endDirective = endDirective;
    }

    public void setDefaultVariableType(String defaultVariableType) {
        this.defaultVariableType = ClassUtils.forName(defaultVariableType);
    }

    public void setImportMacros(String[] importMacros) {
        this.importMacros = importMacros;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public void setExpressionParser(Parser expressionParser) {
        this.expressionParser = expressionParser;
    }

    public void setImportPackages(String[] importPackages) {
        this.importPackages = importPackages;
    }

    public void setImportVariables(String[] importVariables) {
        this.importVariables = importVariables;
    }

    public void setImportMethods(Object[] importMethods) {
        for (Object function : importMethods) {
            if (function instanceof Class) {
                this.functions.put((Class)function, function);
                continue;
            }
            this.functions.put(function.getClass(), function);
        }
    }

    public void init() {
        if (this.importVariables != null && this.importVariables.length > 0) {
            this.importTypes = new HashMap();
            for (String var : this.importVariables) {
                int i = var.lastIndexOf(32);
                if (i < 0) {
                    throw new IllegalArgumentException("Illegal config import.setVariables");
                }
                this.importTypes.put(var.substring(i + 1), ClassUtils.forName(this.importPackages, var.substring(0, i)));
            }
        }
    }

    public void inited() {
        if (this.importMacros != null && this.importMacros.length > 0) {
            for (String importMacro : this.importMacros) {
                try {
                    Template importMacroTemplate = this.engine.getTemplate(importMacro);
                    this.importMacroTemplates.putAll(importMacroTemplate.getMacros());
                }
                catch (Exception e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public Node parse(String source, int offset) throws ParseException {
        return this.reduce(this.trim(this.clean(this.scan(source, offset))));
    }

    private List<Statement> trim(List<Statement> nodes) throws ParseException {
        int i;
        if (!this.removeDirectiveBlankLine) {
            return nodes;
        }
        ArrayList<Integer> empty_text_index_list = new ArrayList<Integer>();
        for (i = 0; i < nodes.size(); ++i) {
            String head;
            int next_index;
            Statement next;
            String tail;
            String text;
            int pos;
            int prev_index;
            Statement prev;
            Statement node = nodes.get(i);
            if (!this.isTrimableDirective(node)) continue;
            if (i > 0 && this.isNoLiteralText(prev = nodes.get(prev_index = i - 1)) && !empty_text_index_list.contains(prev_index) && (pos = (text = ((Text)prev).getContent()).lastIndexOf(10)) >= 0 && (tail = text.substring(pos + 1)).length() > 0 && tail.trim().length() == 0) {
                if ((text = text.substring(0, pos + 1)).length() == 0) {
                    empty_text_index_list.add(prev_index);
                } else {
                    nodes.set(prev_index, new Text(text, false, prev.getOffset()));
                }
            }
            if (i + 1 >= nodes.size() || !this.isNoLiteralText(next = nodes.get(next_index = i + 1))) continue;
            text = ((Text)next).getContent();
            pos = text.indexOf(10);
            if (pos >= 0 && (head = text.substring(0, pos)).trim().length() == 0) {
                Statement next_next;
                text = text.substring(pos + 1);
                boolean isEmptyNode = false;
                if (text.length() == 0) {
                    empty_text_index_list.add(next_index);
                    isEmptyNode = true;
                } else if (text.indexOf(10) == -1 && text.trim().length() == 0 && next_index + 1 < nodes.size() && this.isTrimableDirective(next_next = nodes.get(next_index + 1))) {
                    empty_text_index_list.add(next_index);
                    isEmptyNode = true;
                }
                if (!isEmptyNode) {
                    nodes.set(next_index, new Text(text, false, next.getOffset()));
                }
            }
            ++i;
        }
        if (empty_text_index_list.size() > 0) {
            for (i = empty_text_index_list.size() - 1; i >= 0; --i) {
                int index = (Integer)empty_text_index_list.get(i);
                nodes.remove(index);
            }
        }
        return nodes;
    }

    private boolean isTrimableDirective(Statement node) {
        if (node instanceof Directive) {
            return !(node instanceof ValueDirective);
        }
        return false;
    }

    private String filterEscape(String source) {
        StringBuffer buf = new StringBuffer();
        Matcher matcher = ESCAPE_PATTERN.matcher(source + "#");
        while (matcher.find()) {
            String escape = matcher.group();
            String slash = escape.substring(0, escape.length() - 1);
            String symbol = escape.substring(escape.length() - 1);
            int length = slash.length();
            int half = (length - length % 2) / 2;
            matcher.appendReplacement(buf, Matcher.quoteReplacement(slash.substring(0, half) + symbol));
        }
        matcher.appendTail(buf);
        return buf.toString().substring(0, buf.length() - 1);
    }

    private Type parseGenericType(String type, int offset) throws ParseException {
        Class<?> raw;
        if (StringUtils.isBlank(type)) {
            return null;
        }
        int i = type.indexOf(60);
        if (i < 0) {
            try {
                return ClassUtils.forName(this.importPackages, type);
            }
            catch (Exception e) {
                throw new ParseException("No such class " + type + ", cause: " + ClassUtils.dumpException(e), offset);
            }
        }
        if (!type.endsWith(">")) {
            throw new ParseException("Illegal type: " + type, offset);
        }
        try {
            raw = ClassUtils.forName(this.importPackages, type.substring(0, i));
        }
        catch (Exception e) {
            throw new ParseException("No such class " + type.substring(0, i) + ", cause: " + ClassUtils.dumpException(e), offset);
        }
        String parameterType = type.substring(i + 1, type.length() - 1).trim();
        ArrayList<String> genericTypes = new ArrayList<String>();
        ArrayList<Integer> genericOffsets = new ArrayList<Integer>();
        this.parseGenericTypeString(parameterType, ++offset, genericTypes, genericOffsets);
        if (genericTypes != null && genericTypes.size() > 0) {
            Type[] types = new Type[genericTypes.size()];
            for (int k = 0; k < genericTypes.size(); ++k) {
                types[k] = this.parseGenericType((String)genericTypes.get(k), (Integer)genericOffsets.get(k));
            }
            return new ParameterizedTypeImpl(raw, types);
        }
        return raw;
    }

    private void parseGenericTypeString(String type, int offset, List<String> types, List<Integer> offsets) throws ParseException {
        StringBuilder buf = new StringBuilder();
        int begin = 0;
        for (int j = 0; j < type.length(); ++j) {
            char ch = type.charAt(j);
            if (ch == '<') {
                ++begin;
            } else if (ch == '>' && --begin < 0) {
                throw new ParseException("Illegal type: " + type, offset + j);
            }
            if (ch == ',' && begin == 0) {
                String token = buf.toString();
                types.add(token.trim());
                offsets.add(offset + j - token.length());
                buf.setLength(0);
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            String token = buf.toString();
            types.add(token.trim());
            offsets.add(offset + type.length() - token.length());
            buf.setLength(0);
        }
    }

    private static boolean isEndString(String value) {
        int sc = 0;
        int dc = 0;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if ((ch != '\'' || dc % 2 != 0) && (ch != '\"' || sc % 2 != 0)) continue;
            int c = 0;
            for (int j = i - 1; j >= 0 && value.charAt(j) == '\\'; --j) {
                ++c;
            }
            if (c % 2 != 0) continue;
            if (ch == '\'') {
                ++sc;
                continue;
            }
            ++dc;
        }
        return sc % 2 == 0 && dc % 2 == 0;
    }

    static List<String> splitAssign(String value) {
        ArrayList<String> list = new ArrayList<String>();
        int i = value.indexOf(61);
        while ((i = value.indexOf(61, i + 1)) > 0) {
            if (i + 1 < value.length() && value.charAt(i + 1) == '=') {
                ++i;
                continue;
            }
            if (value.charAt(i - 1) == '>' || value.charAt(i - 1) == '<' || value.charAt(i - 1) == '!' || !TemplateParser.isEndString(value.substring(0, i - 1))) continue;
            String sub = value.substring(0, i);
            int j = sub.lastIndexOf(44);
            int k = sub.lastIndexOf(62);
            if (j > 0 && j < k) {
                int g = 0;
                for (int n = k; n >= 0; --n) {
                    char c = sub.charAt(n);
                    if (c == '>') {
                        ++g;
                    } else if (c == '<') {
                        --g;
                    }
                    if (g != 0) continue;
                    sub = sub.substring(0, n);
                    j = sub.lastIndexOf(44);
                    break;
                }
            }
            if (j <= 0) break;
            list.add(value.substring(0, j));
            value = value.substring(j + 1);
            i = i - j - 1;
        }
        list.add(value);
        return list;
    }

    static List<String> splitDefine(String value) {
        ArrayList<String> vs = new ArrayList();
        Matcher matcher = DEFINE_PATTERN.matcher(value);
        while (matcher.find()) {
            StringBuffer rep = new StringBuffer();
            matcher.appendReplacement(rep, "$1");
            String v = rep.toString();
            if (v.contains(",")) {
                if (!v.contains("<")) {
                    vs.addAll(Arrays.asList(v.split(",")));
                    continue;
                }
                if (v.indexOf(44) < v.indexOf(60)) {
                    int j = v.indexOf(60);
                    int i = v.substring(0, j).lastIndexOf(44);
                    vs.addAll(Arrays.asList(v.substring(0, i).split(",")));
                    vs.add(v.substring(i + 1));
                    continue;
                }
                vs.add(v);
                continue;
            }
            vs.add(v);
        }
        if (vs.size() == 0) {
            vs = Arrays.asList(value.split(","));
        } else {
            StringBuffer tail = new StringBuffer();
            matcher.appendTail(tail);
            if (tail.toString().trim().length() > 0) {
                vs.add(tail.toString());
            }
        }
        return vs;
    }

    private static final class BlockDirectiveEntry {
        private BlockDirective blockDirective;
        private List<Statement> elements = new ArrayList<Statement>();

        BlockDirectiveEntry(BlockDirective blockDirective) {
            this.blockDirective = blockDirective;
        }

        void appendInnerDirective(Statement innerDirective) {
            this.elements.add(innerDirective);
        }

        BlockDirective popDirective() throws ParseException {
            this.blockDirective.setChildren(this.elements);
            return this.blockDirective;
        }
    }
}

