/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.translators;

import httl.Engine;
import httl.Node;
import httl.Resource;
import httl.Template;
import httl.spi.Converter;
import httl.spi.Filter;
import httl.spi.Formatter;
import httl.spi.Interceptor;
import httl.spi.Logger;
import httl.spi.Switcher;
import httl.spi.Translator;
import httl.spi.translators.templates.InterpretedTemplate;
import httl.util.StringSequence;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpretedTranslator
implements Translator {
    private Formatter<Object> formatter;
    private Filter textFilter;
    private Filter valueFilter;
    private Switcher<Filter> textFilterSwitcher;
    private Switcher<Filter> valueFilterSwitcher;
    private Switcher<Formatter<Object>> formatterSwitcher;
    private String filterVariable;
    private String formatterVariable;
    private String[] forVariable;
    private String ifVariable;
    private String outputEncoding;
    private Engine engine;
    private Class<?> defaultVariableType;
    private final List<StringSequence> importSequences = new CopyOnWriteArrayList<StringSequence>();
    private final Map<Class<?>, Object> functions = new ConcurrentHashMap();
    private String[] importPackages;
    private String[] importMacros;
    private final Map<String, Template> importMacroTemplates = new ConcurrentHashMap<String, Template>();
    private Interceptor interceptor;
    private Converter<Object, Object> mapConverter;
    private Converter<Object, Object> outConverter;
    private Logger logger;

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setMapConverter(Converter<Object, Object> mapConverter) {
        this.mapConverter = mapConverter;
    }

    public void setOutConverter(Converter<Object, Object> outConverter) {
        this.outConverter = outConverter;
    }

    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void inited() {
        if (this.importMacros != null && this.importMacros.length > 0) {
            for (String importMacro : this.importMacros) {
                try {
                    Template importMacroTemplate = this.engine.getTemplate(importMacro);
                    this.importMacroTemplates.putAll(importMacroTemplate.getMacros());
                }
                catch (Exception e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
        }
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public void setTextFilterSwitcher(Switcher<Filter> textFilterSwitcher) {
        this.textFilterSwitcher = textFilterSwitcher;
    }

    public void setValueFilterSwitcher(Switcher<Filter> valueFilterSwitcher) {
        this.valueFilterSwitcher = valueFilterSwitcher;
    }

    public void setFormatterSwitcher(Switcher<Formatter<Object>> formatterSwitcher) {
        this.formatterSwitcher = formatterSwitcher;
    }

    public void setFilterVariable(String filterVariable) {
        this.filterVariable = filterVariable;
    }

    public void setFormatterVariable(String formatterVariable) {
        this.formatterVariable = formatterVariable;
    }

    public void setImportMacros(String[] importMacros) {
        this.importMacros = importMacros;
    }

    public void setImportPackages(String[] importPackages) {
        this.importPackages = importPackages;
    }

    public void setImportMethods(Object[] importMethods) {
        for (Object function : importMethods) {
            if (function instanceof Class) {
                this.functions.put((Class)function, function);
                continue;
            }
            this.functions.put(function.getClass(), function);
        }
    }

    public void setImportSequences(String[] sequences) {
        for (String s : sequences) {
            if ((s = s.trim()).length() <= 0) continue;
            String[] ts = s.split("\\s+");
            ArrayList<String> sequence = new ArrayList<String>();
            for (String t : ts) {
                if ((t = t.trim()).length() <= 0) continue;
                sequence.add(t);
            }
            this.importSequences.add(new StringSequence(sequence));
        }
    }

    public void setFormatter(Formatter<Object> formatter) {
        this.formatter = formatter;
    }

    public void setTextFilter(Filter textFilter) {
        this.textFilter = textFilter;
    }

    public void setValueFilter(Filter valueFilter) {
        this.valueFilter = valueFilter;
    }

    public void setForVariable(String[] forVariable) {
        this.forVariable = forVariable;
    }

    public void setIfVariable(String ifVariable) {
        this.ifVariable = ifVariable;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setDefaultVariableType(Class<?> defaultVariableType) {
        this.defaultVariableType = defaultVariableType;
    }

    @Override
    public Template translate(Resource resource, Node root, Map<String, Class<?>> parameterTypes) throws ParseException, IOException {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Interprete template " + resource.getName());
        }
        InterpretedTemplate template = new InterpretedTemplate(resource, root, null);
        template.setInterceptor(this.interceptor);
        template.setMapConverter(this.mapConverter);
        template.setOutConverter(this.outConverter);
        template.setFormatter(this.formatter);
        template.setValueFilter(this.valueFilter);
        template.setTextFilter(this.textFilter);
        template.setForVariable(this.forVariable);
        template.setIfVariable(this.ifVariable);
        template.setOutputEncoding(this.outputEncoding);
        template.setImportSequences(this.importSequences);
        template.setImportMethods(this.functions);
        template.setImportMacros(this.importMacroTemplates);
        template.setImportPackages(this.importPackages);
        template.setTextFilterSwitcher(this.textFilterSwitcher);
        template.setValueFilterSwitcher(this.valueFilterSwitcher);
        template.setFormatterSwitcher(this.formatterSwitcher);
        template.setFilterVariable(this.filterVariable);
        template.setFormatterVariable(this.formatterVariable);
        template.setDefaultVariableType(this.defaultVariableType);
        template.init();
        return template;
    }
}

