/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.translators;

import httl.Node;
import httl.Resource;
import httl.Template;
import httl.spi.Converter;
import httl.spi.Logger;
import httl.spi.Translator;
import httl.spi.translators.templates.MixedTemplate;
import java.io.IOException;
import java.text.ParseException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixedTranslator
implements Translator {
    private Translator compiledTranslator;
    private Translator interpretedTranslator;
    private Converter<Object, Object> mapConverter;
    private Logger logger;
    private boolean compiled;
    private boolean interpreted;

    @Override
    public Template translate(Resource resource, Node root, Map<String, Class<?>> types) throws ParseException, IOException {
        if (this.interpreted && this.compiled) {
            return new MixedTemplate(this.interpretedTranslator.translate(resource, root, types), resource, root, types, this.compiledTranslator, this.mapConverter, this.logger);
        }
        if (this.interpreted) {
            return this.interpretedTranslator.translate(resource, root, types);
        }
        return this.compiledTranslator.translate(resource, root, types);
    }

    public void setCompiled(boolean compiled) {
        this.compiled = compiled;
    }

    public void setInterpreted(boolean interpreted) {
        this.interpreted = interpreted;
    }

    public void setCompiledTranslator(Translator compiledTranslator) {
        this.compiledTranslator = compiledTranslator;
    }

    public void setInterpretedTranslator(Translator interpretedTranslator) {
        this.interpretedTranslator = interpretedTranslator;
    }

    public void setMapConverter(Converter<Object, Object> mapConverter) {
        this.mapConverter = mapConverter;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

