/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.translators.templates;

import httl.Context;
import httl.Engine;
import httl.Node;
import httl.Resource;
import httl.Template;
import httl.spi.Compiler;
import httl.spi.Converter;
import httl.spi.Filter;
import httl.spi.Formatter;
import httl.spi.Interceptor;
import httl.spi.Switcher;
import httl.spi.formatters.MultiFormatter;
import httl.spi.translators.templates.AbstractTemplate;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompiledTemplate
extends AbstractTemplate {
    private final Compiler compiler;
    private final Switcher<Filter> filterSwitcher;
    private final Switcher<Formatter<Object>> formatterSwitcher;
    private final Filter filter;
    private final MultiFormatter formatter;
    private final Map<String, Template> importMacros;
    private final Map<String, Template> macros;

    public CompiledTemplate(Engine engine, Interceptor interceptor, Compiler compiler, Switcher<Filter> filterSwitcher, Switcher<Formatter<Object>> formatterSwitcher, Filter filter, Formatter<Object> formatter, Converter<Object, Object> mapConverter, Converter<Object, Object> outConverter, Map<Class<?>, Object> functions, Map<String, Template> importMacros, Resource resource, Template parent, Node root) {
        super(resource, root, parent);
        super.setMapConverter(mapConverter);
        super.setOutConverter(outConverter);
        super.setInterceptor(interceptor);
        this.compiler = compiler;
        this.filterSwitcher = filterSwitcher;
        this.formatterSwitcher = formatterSwitcher;
        this.filter = filter;
        this.formatter = this.toMultiFormatter(formatter);
        this.importMacros = importMacros;
        this.macros = this.initMacros(engine, interceptor, filterSwitcher, formatterSwitcher, filter, formatter, mapConverter, outConverter, functions, importMacros, resource, parent, root);
    }

    protected MultiFormatter getFormatter(Context context, String key) {
        Object value = context.get(key);
        if (value instanceof Formatter) {
            return this.toMultiFormatter((Formatter)value);
        }
        return this.formatter;
    }

    private MultiFormatter toMultiFormatter(Formatter<?> formatter) {
        if (formatter instanceof MultiFormatter) {
            return (MultiFormatter)formatter;
        }
        return new MultiFormatter(formatter);
    }

    protected MultiFormatter switchFormatter(String location, MultiFormatter defaultFormatter) {
        if (this.formatterSwitcher != null) {
            return this.toMultiFormatter(this.formatterSwitcher.switchover(location, defaultFormatter));
        }
        return defaultFormatter;
    }

    protected Filter getFilter(Context context, String key) {
        Object value = context.get(key);
        if (value instanceof Filter) {
            return (Filter)value;
        }
        return this.filter;
    }

    protected Filter switchFilter(String location, Filter defaultFilter) {
        if (this.filterSwitcher != null) {
            return this.filterSwitcher.switchover(location, defaultFilter);
        }
        return defaultFilter;
    }

    protected String doFilter(Filter filter, String key, String value) {
        if (filter != null) {
            return filter.filter(key, value);
        }
        return value;
    }

    protected char[] doFilter(Filter filter, String key, char[] value) {
        if (filter != null) {
            return filter.filter(key, value);
        }
        return value;
    }

    protected byte[] doFilter(Filter filter, String key, byte[] value) {
        if (filter != null) {
            return filter.filter(key, value);
        }
        return value;
    }

    protected Template getMacro(Context context, String key, Template defaultValue) {
        Object value = context.get(key);
        if (value instanceof Template) {
            return (Template)value;
        }
        return defaultValue;
    }

    @Override
    protected void doRender(Context context) throws Exception {
        if (context.getOut() instanceof OutputStream) {
            this.doRenderStream(context, (OutputStream)context.getOut());
        } else {
            this.doRenderWriter(context, (Writer)context.getOut());
        }
    }

    protected abstract void doRenderStream(Context var1, OutputStream var2) throws Exception;

    protected abstract void doRenderWriter(Context var1, Writer var2) throws Exception;

    protected Map<String, Template> getImportMacros() {
        return this.importMacros;
    }

    private Map<String, Template> initMacros(Engine engine, Interceptor interceptor, Switcher<Filter> filterSwitcher, Switcher<Formatter<Object>> formatterSwitcher, Filter filter, Formatter<Object> formatter, Converter<Object, Object> mapConverter, Converter<Object, Object> outConverter, Map<Class<?>, Object> functions, Map<String, Template> importMacros, Resource resource, Template parent, Node root) {
        HashMap<String, Template> macros = new HashMap<String, Template>();
        Map<String, Class<?>> macroTypes = this.getMacroTypes();
        if (macroTypes == null || macroTypes.size() == 0) {
            return Collections.unmodifiableMap(macros);
        }
        for (Map.Entry<String, Class<?>> entry : macroTypes.entrySet()) {
            try {
                Template macro = (Template)entry.getValue().getConstructor(Engine.class, Interceptor.class, Compiler.class, Switcher.class, Switcher.class, Filter.class, Formatter.class, Converter.class, Converter.class, Map.class, Map.class, Resource.class, Template.class, Node.class).newInstance(engine, interceptor, this.compiler, filterSwitcher, formatterSwitcher, filter, formatter, mapConverter, outConverter, functions, importMacros, resource, parent, root);
                macros.put(entry.getKey(), macro);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        return Collections.unmodifiableMap(macros);
    }

    @Override
    public Map<String, Template> getMacros() {
        return this.macros;
    }

    protected abstract Map<String, Class<?>> getMacroTypes();
}

