/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.translators.templates;

import httl.Node;
import httl.Resource;
import httl.Template;
import httl.spi.Converter;
import httl.spi.Logger;
import httl.spi.Translator;
import httl.spi.translators.templates.ProxyTemplate;
import httl.spi.translators.templates.VariableVisitor;
import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixedTemplate
extends ProxyTemplate {
    private final Map<String, Class<?>> types = new ConcurrentHashMap();
    private final ReentrantLock lock = new ReentrantLock();
    private final Resource resource;
    private final Node root;
    private final Translator compiledTranslator;
    private final Converter<Object, Object> mapConverter;
    private final Logger logger;
    private volatile Template compiledTemplate;
    private volatile boolean firstWarn = true;

    public MixedTemplate(Template template, Resource resource, Node root, Map<String, Class<?>> types, Translator translator, Converter<Object, Object> mapConverter, Logger logger) {
        super(template);
        this.compiledTranslator = translator;
        this.mapConverter = mapConverter;
        this.logger = logger;
        this.resource = resource;
        this.root = root;
        if (types != null) {
            this.types.putAll(types);
        }
        VariableVisitor visitor = new VariableVisitor(null, false);
        try {
            template.accept(visitor);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.types.putAll(visitor.getVariables());
    }

    private Map<String, Object> convertMap(Object parameters) throws IOException, ParseException {
        if (this.mapConverter != null && parameters != null && !(parameters instanceof Map)) {
            parameters = this.mapConverter.convert(parameters, null);
        }
        if (parameters == null || parameters instanceof Map) {
            return (Map)parameters;
        }
        throw new IllegalArgumentException("No such Converter to convert the " + parameters.getClass().getName() + " to Map.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Object parameters, Object stream) throws IOException, ParseException {
        if (this.compiledTemplate != null) {
            this.compiledTemplate.render(parameters, stream);
            return;
        }
        Map<String, Object> map = this.convertMap(parameters);
        if (map != null) {
            boolean compilable = true;
            for (String key : this.getVariables().keySet()) {
                if (this.types.containsKey(key)) continue;
                Object value = map.get(key);
                if (value != null) {
                    this.types.put(key, value.getClass());
                    continue;
                }
                compilable = false;
            }
            if (compilable && this.lock.tryLock()) {
                this.lock.lock();
                try {
                    if (this.compiledTemplate == null) {
                        try {
                            this.compiledTemplate = this.compiledTranslator.translate(this.resource, this.root, this.types);
                        }
                        catch (ParseException e) {
                            if (this.firstWarn && this.logger != null && this.logger.isWarnEnabled()) {
                                this.firstWarn = false;
                                this.logger.warn(e.getMessage(), e);
                            }
                        }
                    }
                }
                finally {
                    this.lock.unlock();
                }
                if (this.compiledTemplate != null) {
                    this.compiledTemplate.render(parameters, stream);
                }
                return;
            }
        }
        super.render(parameters, stream);
    }
}

