/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> parent;
    private final Map<K, V> current;
    private Map<K, V> writable;

    public DelegateMap(Map<K, V> current) {
        this(null, current);
    }

    public DelegateMap(Map<K, V> parent, Map<K, V> current) {
        this.parent = parent;
        this.current = current;
    }

    @Override
    public V get(Object key) {
        V value;
        if (this.writable != null && (value = this.writable.get(key)) != null) {
            return value;
        }
        if (this.current != null && (value = this.current.get(key)) != null) {
            return value;
        }
        return this.parent == null ? null : (V)this.parent.get(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new DelegateSet<Map.Entry<K, V>>(){

            @Override
            protected Collection<Map.Entry<K, V>> getCollection(Map<K, V> map) {
                return map.entrySet();
            }
        };
    }

    @Override
    public Set<K> keySet() {
        return new DelegateSet<K>(){

            @Override
            protected Collection<K> getCollection(Map<K, V> map) {
                return map.keySet();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new DelegateSet<V>(){

            @Override
            protected Collection<V> getCollection(Map<K, V> map) {
                return map.values();
            }
        };
    }

    @Override
    public int size() {
        int size = 0;
        if (this.writable != null) {
            size += this.writable.size();
        }
        if (this.current != null) {
            size += this.current.size();
        }
        if (this.parent != null) {
            size += this.parent.size();
        }
        return size;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.writable != null && this.writable.containsKey(key)) {
            return true;
        }
        if (this.current != null && this.current.containsKey(key)) {
            return true;
        }
        return this.parent != null && this.parent.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.writable != null && this.writable.containsValue(value)) {
            return true;
        }
        if (this.current != null && this.current.containsValue(value)) {
            return true;
        }
        return this.parent != null && this.parent.containsValue(value);
    }

    @Override
    public boolean isEmpty() {
        if (this.writable != null && !this.writable.isEmpty()) {
            return false;
        }
        if (this.current != null && !this.current.isEmpty()) {
            return false;
        }
        return this.parent == null || this.parent.isEmpty();
    }

    @Override
    public V put(K key, V value) {
        if (this.writable == null) {
            this.writable = new HashMap();
        }
        return this.writable.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (this.writable == null) {
            this.writable = new HashMap();
        }
        this.writable.putAll(map);
    }

    @Override
    public V remove(Object key) {
        if (this.writable != null) {
            return this.writable.remove(key);
        }
        return null;
    }

    @Override
    public void clear() {
        if (this.writable != null) {
            this.writable.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class DelegateSet<T>
    extends AbstractSet<T> {
        private DelegateSet() {
        }

        @Override
        public Iterator<T> iterator() {
            return new DelegateIterator();
        }

        @Override
        public int size() {
            return DelegateMap.this.size();
        }

        protected abstract Collection<T> getCollection(Map<K, V> var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class DelegateIterator
        implements Iterator<T> {
            private int level = 0;
            private Iterator<T> iterator;

            private DelegateIterator() {
            }

            private Iterator<T> getIterator() {
                if (this.iterator == null || !this.iterator.hasNext()) {
                    if (this.level < 1 && DelegateMap.this.parent != null) {
                        this.level = 1;
                        this.iterator = DelegateSet.this.getCollection(DelegateMap.this.parent).iterator();
                    } else if (this.level < 2 && DelegateMap.this.current != null) {
                        this.level = 2;
                        this.iterator = DelegateSet.this.getCollection(DelegateMap.this.current).iterator();
                    } else if (this.level < 3 && DelegateMap.this.writable != null) {
                        this.level = 3;
                        this.iterator = DelegateSet.this.getCollection(DelegateMap.this.writable).iterator();
                    }
                }
                return this.iterator;
            }

            @Override
            public boolean hasNext() {
                Iterator iterator = this.getIterator();
                return iterator == null ? false : iterator.hasNext();
            }

            @Override
            public T next() {
                Iterator iterator = this.getIterator();
                if (iterator == null) {
                    throw new NoSuchElementException();
                }
                return iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

