/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedStack<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final LinkedList<T> stack = new LinkedList();
    private volatile List<T> unmodifiable;

    public int size() {
        return this.stack.size();
    }

    public boolean isEmpty() {
        return this.stack.size() == 0;
    }

    public void push(T value) {
        this.stack.addLast(value);
    }

    public T pop() {
        T value = this.peek();
        this.stack.removeLast();
        return value;
    }

    public T peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.stack.getLast();
    }

    public void poke(T value) {
        if (!this.isEmpty()) {
            this.stack.removeLast();
        }
        this.push(value);
    }

    public void clear() {
        this.stack.clear();
    }

    public Iterator<T> iterator() {
        return this.toList().iterator();
    }

    public List<T> toList() {
        if (this.unmodifiable == null) {
            this.unmodifiable = Collections.unmodifiableList(this.stack);
        }
        return this.unmodifiable;
    }

    public String toString() {
        return this.stack.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.stack == null ? 0 : this.stack.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkedStack other = (LinkedStack)obj;
        return !(this.stack == null ? other.stack != null : !this.stack.equals(other.stack));
    }
}

