/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import httl.util.ClassUtils;
import java.io.Serializable;

public class Status
implements Serializable {
    private static final long serialVersionUID = -6011370058720809056L;
    private final Status parent;
    private final Object data;
    private final int size;
    private final int level;
    private int index = 0;

    public Status(Status parent, Object data) {
        this(parent, data, ClassUtils.getSize(data));
    }

    public Status(Status parent, Object data, int size) {
        this.parent = parent;
        this.data = data;
        this.size = size;
        this.level = parent == null ? 0 : parent.getLevel() + 1;
    }

    public void increment() {
        ++this.index;
    }

    public Status getParent() {
        return this.parent;
    }

    public Object getData() {
        return this.data;
    }

    public int getSize() {
        return this.size;
    }

    public int getLevel() {
        return this.level;
    }

    public int getIndex() {
        return this.index;
    }

    public int getCount() {
        return this.index + 1;
    }

    public boolean isEmpty() {
        return this.data == null || this.size == 0;
    }

    public boolean isOdd() {
        return this.index % 2 != 0;
    }

    public boolean isEven() {
        return this.index % 2 == 0;
    }

    public boolean isFirst() {
        return this.index == 0;
    }

    public boolean isLast() {
        return this.index >= this.size - 1;
    }

    public boolean isMiddle() {
        return this.index > 0 && this.index < this.size - 1;
    }
}

