/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import httl.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlUtils {
    public static final String PROTOCOL_SEPARATOR = "://";
    public static final String PATH_SEPARATOR = "/";
    public static final char PATH_SEPARATOR_CHAR = '/';
    public static final char PATH_PARENT_CHAR = '.';
    public static final char WINDOWS_PATH_SEPARATOR_CHAR = '\\';
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String FILE_URL_PREFIX = "file:";

    public static String relativeUrl(String name, String relativeName) throws MalformedURLException {
        if (StringUtils.isEmpty(name) || StringUtils.isEmpty(relativeName)) {
            return name;
        }
        if (name.charAt(0) == '/' || name.charAt(0) == '\\') {
            return name;
        }
        int parent = UrlUtils.getParentLevel(name);
        if (parent > 0) {
            name = name.substring(parent * 3);
        }
        return UrlUtils.getParentDirectory(relativeName, parent) + name;
    }

    public static int getParentLevel(String name) {
        int max = name.length() - 3;
        int n = 0;
        for (int i = 0; i < max && name.charAt(i) == '.' && name.charAt(i + 1) == '.' && (name.charAt(i + 2) == '/' || name.charAt(i + 2) == '\\'); i += 3) {
            ++n;
        }
        return n;
    }

    public static String removeSuffix(String name) {
        int j;
        int i = name.lastIndexOf(46);
        if (i > 0 && i > (j = name.lastIndexOf(47))) {
            return name.substring(i);
        }
        return name;
    }

    public static String cleanName(String name) {
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("name == null");
        }
        int len = name.length();
        StringBuilder buf = null;
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (ch == '\\') {
                if (buf == null) {
                    buf = new StringBuilder(len);
                    buf.append(name.substring(0, i));
                }
                buf.append('/');
                continue;
            }
            if (i == 0 && ch != '/') {
                buf = new StringBuilder(len + 1);
                buf.append('/');
                buf.append(ch);
                continue;
            }
            if (buf == null) continue;
            buf.append(ch);
        }
        if (buf != null) {
            return buf.toString();
        }
        return name;
    }

    public static String[] cleanDirectory(String[] names) {
        String[] result = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = UrlUtils.cleanDirectory(names[i]);
        }
        return result;
    }

    public static String cleanDirectory(String name) {
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("directory == null");
        }
        int last = name.length() - 1;
        StringBuilder buf = null;
        for (int i = 0; i <= last; ++i) {
            char ch = name.charAt(i);
            if (i == last && (ch == '/' || ch == '\\')) {
                if (buf != null) continue;
                return name.substring(0, last);
            }
            if (ch == '\\') {
                if (buf == null) {
                    buf = new StringBuilder(name.length());
                    buf.append(name.substring(0, i));
                }
                buf.append('/');
                continue;
            }
            if (i == 0 && ch != '/') {
                buf = new StringBuilder(name.length() + 1);
                buf.append('/');
                buf.append(ch);
                continue;
            }
            if (buf == null) continue;
            buf.append(ch);
        }
        if (buf != null) {
            return buf.toString();
        }
        return name;
    }

    public static String getParentDirectory(String url, int parent) {
        if (url != null) {
            for (int i = url.length() - 1; i >= 0; --i) {
                char ch = url.charAt(i);
                if (ch != '/' && ch != '\\' || --parent >= 0) continue;
                return url.substring(0, i + 1);
            }
        }
        return PATH_SEPARATOR;
    }

    public static List<String> listUrl(URL rootDirUrl, String suffix) throws IOException {
        if (rootDirUrl == null) {
            return new ArrayList<String>(0);
        }
        if ("file".equals(rootDirUrl.getProtocol())) {
            return UrlUtils.listFile(new File(rootDirUrl.getFile()), suffix);
        }
        return UrlUtils.listJarUrl(rootDirUrl, suffix);
    }

    public static List<String> listFile(File dirFile, String suffix) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        UrlUtils.addListFile(list, PATH_SEPARATOR, dirFile, suffix);
        return list;
    }

    private static void addListFile(List<String> list, String dir, File dirFile, String suffix) throws IOException {
        for (File file : dirFile.listFiles()) {
            if (file.isHidden() || !file.canRead()) continue;
            if (file.isDirectory()) {
                UrlUtils.addListFile(list, dir + file.getName() + PATH_SEPARATOR, file, suffix);
                continue;
            }
            if (!UrlUtils.isMatch(file.getName(), suffix)) continue;
            list.add(dir + file.getName());
        }
    }

    private static boolean isMatch(String name, String suffix) {
        if (StringUtils.isEmpty(suffix)) {
            return true;
        }
        return name.endsWith(suffix);
    }

    public static List<String> listZip(ZipFile zipFile, String suffix) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            String name;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || !UrlUtils.isMatch(name = entry.getName(), suffix)) continue;
            if (!name.startsWith(PATH_SEPARATOR)) {
                name = PATH_SEPARATOR + name;
            }
            result.add(name);
        }
        return result;
    }

    public static List<String> listJar(JarFile jarFile, String suffix) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String name;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !UrlUtils.isMatch(name = entry.getName(), suffix)) continue;
            if (!name.startsWith(PATH_SEPARATOR)) {
                name = PATH_SEPARATOR + name;
            }
            result.add(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> listJarUrl(URL rootDirUrl, String suffix) throws IOException {
        URLConnection con = rootDirUrl.openConnection();
        JarFile jarFile = null;
        String jarFileUrl = null;
        String rootEntryPath = null;
        boolean newJarFile = false;
        if (con instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)con;
            jarCon.setUseCaches(false);
            jarFile = jarCon.getJarFile();
            jarFileUrl = jarCon.getJarFileURL().toExternalForm();
            JarEntry jarEntry = jarCon.getJarEntry();
            rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
        } else {
            String urlFile = rootDirUrl.getFile();
            int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
            if (separatorIndex != -1) {
                jarFileUrl = urlFile.substring(0, separatorIndex);
                rootEntryPath = urlFile.substring(separatorIndex + JAR_URL_SEPARATOR.length());
                jarFile = UrlUtils.getJarFile(jarFileUrl);
            } else {
                jarFile = new JarFile(urlFile);
                jarFileUrl = urlFile;
                rootEntryPath = "";
            }
            newJarFile = true;
        }
        try {
            if (!"".equals(rootEntryPath) && !rootEntryPath.endsWith(PATH_SEPARATOR)) {
                rootEntryPath = rootEntryPath + PATH_SEPARATOR;
            }
            ArrayList<String> result = new ArrayList<String>();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String relativePath;
                JarEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (!entryPath.startsWith(rootEntryPath) || !(relativePath = entryPath.substring(rootEntryPath.length())).endsWith(suffix)) continue;
                result.add(relativePath);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            if (newJarFile) {
                jarFile.close();
            }
        }
    }

    private static JarFile getJarFile(String jarFileUrl) throws IOException {
        if (jarFileUrl.startsWith(FILE_URL_PREFIX)) {
            try {
                return new JarFile(UrlUtils.toURI(jarFileUrl).getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                return new JarFile(jarFileUrl.substring(FILE_URL_PREFIX.length()));
            }
        }
        return new JarFile(jarFileUrl);
    }

    public static URI toURI(URL url) throws URISyntaxException {
        return UrlUtils.toURI(url.toString());
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(location.replace(" ", "%20"));
    }
}

