/*
 * Decompiled with CFR 0.152.
 */
package org.perfrepo.model;

import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.perfrepo.model.Entity;
import org.perfrepo.model.Metric;
import org.perfrepo.model.Tag;
import org.perfrepo.model.Test;

@javax.persistence.Entity
@Table(name="alert")
@NamedQueries(value={@NamedQuery(name="Alert.getByTestAndMetric", query="SELECT distinct alert from Alert alert join alert.test test join alert.metric metric where test.id = :testId and metric.id = :metricId")})
public class Alert
implements Entity<Alert> {
    public static final String GET_BY_TEST_AND_METRIC = "Alert.getByTestAndMetric";
    @Id
    @SequenceGenerator(name="ALERT_ID_GENERATOR", sequenceName="ALERT_SEQUENCE", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ALERT_ID_GENERATOR")
    private Long id;
    @Column(name="name")
    @NotNull(message="{page.alert.nameRequired}")
    @Size(max=500)
    private String name;
    @Column(name="description")
    @Size(max=2097)
    private String description;
    @Column(name="condition")
    @NotNull(message="{page.alert.conditionRequired}")
    @Size(max=2097)
    private String condition;
    @Column(name="links")
    private String links;
    @ManyToOne(optional=false, cascade={CascadeType.PERSIST})
    @JoinColumn(name="metric_id", referencedColumnName="id")
    @NotNull(message="{page.alert.metricRequired}")
    private Metric metric;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="alert_tag", joinColumns={@JoinColumn(name="alert_id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="tag_id", nullable=false, updatable=false)})
    private Collection<Tag> tags;
    @ManyToOne(optional=false, cascade={CascadeType.PERSIST})
    @JoinColumn(name="test_id", referencedColumnName="id")
    @NotNull
    private Test test;

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getLinks() {
        return this.links;
    }

    public void setLinks(String links) {
        this.links = links;
    }

    public Test getTest() {
        return this.test;
    }

    public void setTest(Test test) {
        this.test = test;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public void setMetric(Metric metric) {
        this.metric = metric;
    }

    public Collection<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public Alert clone() {
        try {
            return (Alert)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "Alert{id=" + this.id + ", condition='" + this.condition + '\'' + ", metric=" + this.metric + '}';
    }
}

