/*
 * Decompiled with CFR 0.152.
 */
package org.perfrepo.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.perfrepo.model.Entity;
import org.perfrepo.model.Tag;
import org.perfrepo.model.Test;
import org.perfrepo.model.TestExecutionAttachment;
import org.perfrepo.model.TestExecutionParameter;
import org.perfrepo.model.Value;
import org.perfrepo.model.auth.EntityType;
import org.perfrepo.model.auth.SecuredEntity;
import org.perfrepo.model.builder.TestExecutionBuilder;

@javax.persistence.Entity
@Table(name="test_execution")
@SecuredEntity(type=EntityType.TEST, parent="test")
@NamedQueries(value={@NamedQuery(name="TestExecution.getTest", query="SELECT te.test from TestExecution te inner join te.test where te= :entity")})
@XmlRootElement(name="testExecution")
public class TestExecution
implements Entity<TestExecution> {
    private static final long serialVersionUID = -2956845045583534606L;
    public static final String GET_TEST = "TestExecution.getTest";
    @Id
    @SequenceGenerator(name="TEST_EXECUTION_ID_GENERATOR", sequenceName="TEST_EXECUTION_SEQUENCE", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="TEST_EXECUTION_ID_GENERATOR")
    private Long id;
    @Column(name="name")
    @NotNull(message="{page.testExecution.nameRequired}")
    @Size(max=2047)
    private String name;
    @ManyToOne(optional=false, cascade={CascadeType.PERSIST})
    @JoinColumn(name="test_id", referencedColumnName="id")
    private Test test;
    @OneToMany(mappedBy="testExecution")
    private Collection<TestExecutionParameter> parameters;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="test_execution_tag", joinColumns={@JoinColumn(name="test_execution_id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="tag_id", nullable=false, updatable=false)})
    private Collection<Tag> tags;
    @OneToMany(mappedBy="testExecution")
    private Collection<Value> values;
    @OneToMany(mappedBy="testExecution")
    private Collection<TestExecutionAttachment> attachments;
    @NotNull(message="{page.testExecution.startedRequired}")
    @Column(name="started")
    private Date started;
    @Column(name="comment")
    @Size(max=10239)
    private String comment;

    @Override
    @XmlTransient
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @XmlID
    @XmlAttribute(name="id")
    public String getStringId() {
        return this.id == null ? null : String.valueOf(this.id);
    }

    public void setStringId(String id) {
        this.id = Long.valueOf(id);
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setTest(Test test) {
        this.test = test;
    }

    @XmlTransient
    public Test getTest() {
        return this.test;
    }

    @XmlAttribute(name="testId")
    public String getTestId() {
        return this.test == null ? null : (this.test.getId() == null ? null : this.test.getId().toString());
    }

    public void setTestId(String id) {
        if (this.test == null) {
            this.test = new Test();
        }
        this.test.setId(Long.valueOf(id));
    }

    @XmlAttribute(name="testUid")
    public String getTestUid() {
        return this.test == null ? null : this.test.getUid();
    }

    public void setTestUid(String uid) {
        if (this.test == null) {
            this.test = new Test();
        }
        this.test.setUid(uid);
    }

    public void setParameters(Collection<TestExecutionParameter> testExecutionParameters) {
        this.parameters = testExecutionParameters;
    }

    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    public Collection<TestExecutionParameter> getParameters() {
        return this.parameters;
    }

    public void setTags(Collection<Tag> tags) {
        this.tags = tags;
    }

    @XmlElementWrapper(name="tags")
    @XmlElement(name="tag")
    public Collection<Tag> getTags() {
        return this.tags;
    }

    public void setValues(Collection<Value> values) {
        this.values = values;
    }

    @XmlElementWrapper(name="values")
    @XmlElement(name="value")
    public Collection<Value> getValues() {
        return this.values;
    }

    @XmlAttribute(name="started")
    public Date getStarted() {
        return this.started;
    }

    public void setStarted(Date started) {
        this.started = started;
    }

    @XmlTransient
    public Collection<TestExecutionAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Collection<TestExecutionAttachment> attachments) {
        this.attachments = attachments;
    }

    @XmlTransient
    public List<Tag> getSortedTags() {
        Collection<Tag> tags = this.getTags();
        if (tags == null) {
            return new ArrayList<Tag>();
        }
        return tags.stream().sorted((o1, o2) -> o1.compareTo((Tag)o2)).collect(Collectors.toList());
    }

    @XmlTransient
    public List<TestExecutionParameter> getSortedParameters() {
        if (this.parameters == null || this.parameters.isEmpty()) {
            return new ArrayList<TestExecutionParameter>(0);
        }
        ArrayList<TestExecutionParameter> result = new ArrayList<TestExecutionParameter>(this.parameters);
        Collections.sort(result);
        return result;
    }

    @XmlTransient
    public Map<String, String> getParametersAsMap() {
        if (this.parameters == null || this.parameters.isEmpty()) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> r = new HashMap<String, String>();
        for (TestExecutionParameter p : this.parameters) {
            r.put(p.getName(), p.getValue());
        }
        return r;
    }

    @Deprecated
    public TestExecutionParameter findParameter(String name) {
        if (this.parameters == null || this.parameters.isEmpty()) {
            return null;
        }
        for (TestExecutionParameter param : this.parameters) {
            if (!name.equals(param.getName())) continue;
            return param;
        }
        return null;
    }

    public static TestExecutionBuilder builder() {
        return new TestExecutionBuilder();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.started == null ? 0 : this.started.hashCode());
        result = 31 * result + (this.test == null ? 0 : this.test.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestExecution other = (TestExecution)obj;
        if (this.comment == null ? other.comment != null : !this.comment.equals(other.comment)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.started == null ? other.started != null : !this.started.equals(other.started)) {
            return false;
        }
        return !(this.test == null ? other.test != null : !this.test.equals(other.test));
    }

    @Override
    public TestExecution clone() {
        try {
            return (TestExecution)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

