/*
 * Decompiled with CFR 0.152.
 */
package org.perfrepo.model;

import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.perfrepo.model.Entity;
import org.perfrepo.model.Metric;
import org.perfrepo.model.MetricComparator;
import org.perfrepo.model.TestExecution;
import org.perfrepo.model.ValueParameter;
import org.perfrepo.model.auth.EntityType;
import org.perfrepo.model.auth.SecuredEntity;
import org.perfrepo.model.util.EntityUtils;

@javax.persistence.Entity
@Table(name="value")
@NamedQueries(value={@NamedQuery(name="Value.getTest", query="SELECT test from Value v inner join v.testExecution te inner join te.test test where v= :entity")})
@SecuredEntity(type=EntityType.TEST, parent="testExecution")
@XmlRootElement(name="value")
public class Value
implements Entity<Value> {
    private static final long serialVersionUID = 1227873698917395252L;
    public static final String GET_TEST = "Value.getTest";
    @Id
    @SequenceGenerator(name="VALUE_ID_GENERATOR", sequenceName="VALUE_SEQUENCE", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="VALUE_ID_GENERATOR")
    private Long id;
    @ManyToOne(optional=false, cascade={CascadeType.PERSIST})
    @JoinColumn(name="metric_id", referencedColumnName="id")
    private Metric metric;
    @Column(name="result_value")
    private Double resultValue;
    @ManyToOne(optional=false, cascade={CascadeType.PERSIST})
    @JoinColumn(name="test_execution_id", referencedColumnName="id")
    private TestExecution testExecution;
    @OneToMany(mappedBy="value")
    private Collection<ValueParameter> parameters;

    @Override
    @XmlTransient
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setMetric(Metric metric) {
        this.metric = metric;
    }

    @XmlTransient
    public Metric getMetric() {
        return this.metric;
    }

    public void setResultValue(Double resultValue) {
        this.resultValue = resultValue;
    }

    @XmlAttribute(name="result")
    public Double getResultValue() {
        return this.resultValue;
    }

    public void setTestExecution(TestExecution testExecution) {
        this.testExecution = testExecution;
    }

    @XmlTransient
    public TestExecution getTestExecution() {
        return this.testExecution;
    }

    public void setParameters(Collection<ValueParameter> valueParameters) {
        this.parameters = valueParameters;
    }

    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    public Collection<ValueParameter> getParameters() {
        return this.parameters;
    }

    @XmlAttribute(name="metricName")
    public String getMetricName() {
        return this.metric == null ? null : this.metric.getName();
    }

    public void setMetricName(String metricName) {
        if (this.metric == null) {
            this.metric = new Metric();
        }
        this.metric.setName(metricName);
    }

    @XmlAttribute(name="metricComparator")
    public MetricComparator getMetricComparator() {
        return this.metric == null ? null : this.metric.getComparator();
    }

    public void setMetricComparator(MetricComparator metricComparator) {
        if (this.metric == null) {
            this.metric = new Metric();
        }
        this.metric.setComparator(metricComparator);
    }

    @Override
    public Value clone() {
        try {
            return (Value)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Value cloneWithParameters() {
        Value cloneValue = this.clone();
        cloneValue.setParameters(EntityUtils.clone(cloneValue.getParameters()));
        if (cloneValue.getParameters() != null) {
            for (ValueParameter pClone : cloneValue.getParameters()) {
                pClone.setValue(cloneValue);
            }
        }
        return cloneValue;
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }
}

